/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorLanguagePreferencesPanel;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.ComboBoxItem;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.osgi.ClasspathOSGiManager;
import com.mathworks.widgets.prefs.PrefsEditorPanelV1;
import com.mathworks.widgets.prefs.PrefsHelp;
import com.mathworks.widgets.prefs.PrefsNode;
import com.mathworks.widgets.text.EditorLanguageUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class EditorPrefsLanguagePanel
implements PrefsEditorPanelV1 {
    public static final String PANEL_NAME = "EditorPrefsLanguagePanel";
    public static final String LANGUAGE_COMBOBOX_NAME = "LanguageComboBox";
    public static final String LANGUAGE_PANEL_SUFFIX = "Panel";
    private static final int VGAP = 5;
    private static final int HGAP = 6;
    private final Set<EditorLanguagePreferencesPanel> fCreatedPanels = new HashSet<EditorLanguagePreferencesPanel>();
    private final CardLayout fCardLayout;
    private final JComponent fLanguagesPanel;
    private final JComponent fPanel;

    public static List<EditorLanguagePreferencesPanel> getPanels() {
        Collection collection = ClasspathOSGiManager.getInstance().getImplementors(EditorLanguagePreferencesPanel.class);
        ArrayList<EditorLanguagePreferencesPanel> arrayList = new ArrayList<EditorLanguagePreferencesPanel>(collection);
        Collections.sort(arrayList, new Comparator<EditorLanguagePreferencesPanel>(){

            @Override
            public int compare(EditorLanguagePreferencesPanel editorLanguagePreferencesPanel, EditorLanguagePreferencesPanel editorLanguagePreferencesPanel2) {
                return EditorLanguageUtils.compareLanguages((EditorLanguage)editorLanguagePreferencesPanel.getLanguage(), (EditorLanguage)editorLanguagePreferencesPanel2.getLanguage());
            }
        });
        return arrayList;
    }

    public EditorPrefsLanguagePanel(Dimension dimension) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("pref, 3dlu, pref", "pref"));
        mJPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 5, 0));
        CellConstraints cellConstraints = new CellConstraints();
        MJLabel mJLabel = new MJLabel(EditorUtils.lookup("pref.language.Language"));
        mJLabel.setName("LanguageLabel");
        mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(1, 1));
        mJPanel.add((Component)this.createLanguageComboBox(), (Object)cellConstraints.xy(3, 1));
        this.fCardLayout = new CardLayout();
        this.fLanguagesPanel = new MJPanel((LayoutManager)this.fCardLayout);
        this.showLanguage(EditorPrefsLanguagePanel.getPanels().iterator().next());
        this.fPanel = new MJPanel((LayoutManager)new MGridLayout(2, 1, 0, 0, 131072));
        this.fPanel.setName(PANEL_NAME);
        this.fPanel.add((Component)mJPanel);
        this.fPanel.add(this.fLanguagesPanel);
    }

    private MJComboBox createLanguageComboBox() {
        final MJComboBox mJComboBox = new MJComboBox();
        mJComboBox.setName(LANGUAGE_COMBOBOX_NAME);
        mJComboBox.getAccessibleContext().setAccessibleName(EditorUtils.lookup("pref.language.accLanguages"));
        for (EditorLanguagePreferencesPanel editorLanguagePreferencesPanel : EditorPrefsLanguagePanel.getPanels()) {
            mJComboBox.addItem((Object)new ComboBoxItem(editorLanguagePreferencesPanel.getLanguage().getName(), (Object)editorLanguagePreferencesPanel));
        }
        mJComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ComboBoxItem comboBoxItem = (ComboBoxItem)mJComboBox.getSelectedItem();
                EditorPrefsLanguagePanel.this.showLanguage((EditorLanguagePreferencesPanel)comboBoxItem.getValue());
            }
        });
        return mJComboBox;
    }

    private void showLanguage(EditorLanguagePreferencesPanel editorLanguagePreferencesPanel) {
        if (!this.fCreatedPanels.contains(editorLanguagePreferencesPanel)) {
            Component component = editorLanguagePreferencesPanel.createPanel();
            assert (component.getName() == null) : "Panel for " + editorLanguagePreferencesPanel + " should not have a name; a name is automatically assigned";
            component.setName(editorLanguagePreferencesPanel.getLanguage().getInternalName() + LANGUAGE_PANEL_SUFFIX);
            this.fLanguagesPanel.add(component, editorLanguagePreferencesPanel.getLanguage().getInternalName());
            this.fCreatedPanels.add(editorLanguagePreferencesPanel);
        }
        this.fCardLayout.show(this.fLanguagesPanel, editorLanguagePreferencesPanel.getLanguage().getInternalName());
    }

    public void commitChanges(PrefsNode prefsNode) {
        for (EditorLanguagePreferencesPanel editorLanguagePreferencesPanel : this.fCreatedPanels) {
            editorLanguagePreferencesPanel.commit();
        }
    }

    public boolean validateChanges(PrefsNode prefsNode) {
        return true;
    }

    public void cancelChanges(PrefsNode prefsNode) {
    }

    public boolean canDetectPendingEdits(PrefsNode prefsNode) {
        return false;
    }

    public boolean hasPendingEdits(PrefsNode prefsNode) {
        return false;
    }

    public JComponent getComponent(PrefsNode prefsNode) {
        return this.fPanel;
    }

    public PrefsHelp getHelp() {
        return new PrefsHelp(MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_editorlanguage_prefs");
    }

    public void doHelp() {
        PrefsHelp prefsHelp = this.getHelp();
        MLHelpServices.displayTopic((String)prefsHelp.getHelpMapPath(), (String)prefsHelp.getHelpTopicKey());
    }

    public void dispose() {
        for (EditorLanguagePreferencesPanel editorLanguagePreferencesPanel : this.fCreatedPanels) {
            editorLanguagePreferencesPanel.cleanup();
        }
    }
}

