/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.jmi.AWTUtilities;
import com.mathworks.matlab.api.datamodel.BackingStore;
import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.dataview.UiInfoProvider;
import com.mathworks.matlab.api.debug.BreakpointMargin;
import com.mathworks.matlab.api.debug.ExecutionArrowMargin;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorEventListener;
import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.mde.editor.EditorGroup;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorViewClient;
import com.mathworks.mde.editor.EditorViewUtils;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.mcode.MLanguage;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;

class MatlabEditor
implements Editor {
    private final EditorViewClient fEditorViewClient;
    private final UiInfoProvider fUiInfoProvider;
    private final Map<Object, Object> fPropertyMap = new HashMap<Object, Object>();
    private final List<EditorEventListener> fEventListeners;
    private PropertyChangeSupport fPropertyChangeSupport;
    private final BackingStore<Document> fBackingStore;
    private boolean fHasBeenDisposed = false;
    static final String LANGUAGE_PROPERTY = "EditorLanguage";

    MatlabEditor(EditorViewClient editorViewClient, UiInfoProvider uiInfoProvider, BackingStore<Document> backingStore) {
        Validate.notNull((Object)((Object)editorViewClient), (String)"The given EditorViewClient cannot be null.");
        Validate.notNull((Object)uiInfoProvider, (String)"The given UiInfoProvider cannot be null.");
        Validate.notNull(backingStore, (String)"The given backingStore cannot be null.");
        this.fEditorViewClient = editorViewClient;
        this.fUiInfoProvider = uiInfoProvider;
        this.fEventListeners = new ArrayList<EditorEventListener>();
        this.fBackingStore = backingStore;
    }

    public void dispose() {
        this.fireEditorEvent(EditorEvent.CLOSED);
        this.fPropertyMap.clear();
        this.fEventListeners.clear();
        this.fHasBeenDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockIfOpen() {
        if (!this.isOpen()) {
            return false;
        }
        this.fEditorViewClient.lock();
        boolean bl = false;
        try {
            bl = this.isOpen();
        }
        finally {
            if (!bl) {
                this.unlock();
            }
        }
        return bl;
    }

    public void unlock() {
        this.fEditorViewClient.unlock();
    }

    private PropertyChangeSupport getPropertyChangeSupport() {
        if (this.fPropertyChangeSupport == null) {
            this.fPropertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.fPropertyChangeSupport;
    }

    public BreakpointMargin<?> getBreakpointMargin() {
        return this.fEditorViewClient.getEditorView().getBreakpointMargin();
    }

    public ExecutionArrowMargin getExecutionArrowMargin() {
        return this.fEditorViewClient.getEditorView().getExecutionArrowDisplay();
    }

    public void setEditorStatusBarText(String string) {
        this.fEditorViewClient.setEditorStatusBarText(string);
    }

    public int getLineNumber() {
        int n = 0;
        try {
            n = Utilities.getLineOffset((BaseDocument)((BaseDocument)this.getDocument()), (int)this.getCaretPosition());
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return n;
    }

    public void appendText(final String string) {
        this.validateEditability();
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.appendText(string);
            }
        });
    }

    public void bringToFront() {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                EditorStartup.getParentDesktop().setClientSelected((Component)((Object)MatlabEditor.this.fEditorViewClient), true);
            }
        });
    }

    public void close() {
        if (this.isOpen()) {
            EditorUtils.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MatlabEditor.this.fEditorViewClient.close();
                }
            });
        }
    }

    public void closeNoPrompt() {
        if (this.isOpen()) {
            EditorUtils.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MatlabEditor.this.fEditorViewClient.closeNoPrompt();
                }
            });
        }
    }

    public String getShortName() {
        return this.fUiInfoProvider.getShortName();
    }

    public String getLongName() {
        return this.fUiInfoProvider.getLongName();
    }

    public StorageLocation getStorageLocation() {
        return this.fBackingStore.getStorageLocation();
    }

    public Component getComponent() {
        return this.fEditorViewClient;
    }

    public JTextComponent getTextComponent() {
        return this.fEditorViewClient.getEditorView().getSyntaxTextPane().getActiveTextComponent();
    }

    public void insertTextAtCaret(final String string) {
        this.validateEditability();
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.insertTextAtCaret(string);
            }
        });
    }

    public void insertAndFormatTextAtCaret(final String string) {
        this.validateEditability();
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.insertAndFormatTextAtCaret(string);
            }
        });
    }

    public void replaceText(final String string, final int n, final int n2) {
        this.validateEditability();
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.replaceText(string, n, n2);
            }
        });
    }

    public int getCaretPosition() {
        return this.fEditorViewClient.getEditorView().getSyntaxTextPane().getCaretPosition();
    }

    public void setCaretPosition(final int n) {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane().setCaretPosition(EditorViewUtils.boundPosition(MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane(), n));
            }
        });
    }

    public void setSelection(final int n, final int n2) {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane().select(n, n2);
            }
        });
    }

    public String getSelection() {
        String string = this.fEditorViewClient.getEditorView().getSyntaxTextPane().getSelectedText();
        return string == null ? "" : string;
    }

    public int getLength() {
        return this.fEditorViewClient.getEditorView().getSyntaxTextPane().getLength();
    }

    public String getTextWithSystemLineEndings() {
        return this.fEditorViewClient.getEditorView().getSyntaxTextPane().getText();
    }

    public String getText() {
        String string = "";
        try {
            string = this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return string;
    }

    public void goToLine(final int n, final boolean bl) {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                EditorViewUtils.goToLine(MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane(), n, bl);
            }
        });
    }

    public void goToPositionAndHighlight(final int n, final int n2) {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                EditorViewUtils.goToPositionAndHighlight(MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane(), n, n2);
            }
        });
    }

    public void goToLine(final int n, final int n2) {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                EditorViewUtils.goToLine(MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane(), n, n2);
            }
        });
    }

    public boolean isBuffer() {
        return !this.fEditorViewClient.getEditorView().getBackingStore().isPersistenceLocationSet();
    }

    public boolean isDirty() {
        return this.fEditorViewClient.getEditorView().isDirty();
    }

    public void setDirtyUntilSave() {
        this.fEditorViewClient.getEditorView().getSyntaxTextPane().setUndoDirtyMarker();
    }

    public void setClean() {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane().setUndoCleanMarker();
            }
        });
    }

    public boolean isMCode() {
        return this.getLanguage() instanceof MLanguage;
    }

    public boolean isOpen() {
        return this.fEditorViewClient.getEditorView() != null && EditorGroup.getInstance().getOpenEditorViewClients().contains((Object)this.fEditorViewClient);
    }

    public void goToFunction(final String string, final String string2) {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabPluginUtils.goToFunction(MatlabEditor.this, string, string2);
            }
        });
    }

    public void refreshMenus() {
        this.fEditorViewClient.refreshMenuBar();
    }

    public void setStatusText(String string) {
        this.fEditorViewClient.setStatusText(string);
    }

    public void reload() {
        this.reload(true);
    }

    public boolean negotiateSave() {
        return (Boolean)EditorUtils.invokeAndWait(new AWTUtilities.InvocationRunnable(){

            public Object runWithOutput() {
                return MatlabEditor.this.fEditorViewClient.getEditorView().negotiateSave();
            }
        });
    }

    public void save() throws Exception {
        this.executeRunnableWithDeclaredException(new Runnable(){

            @Override
            public void run() {
                try {
                    MatlabEditor.this.fEditorViewClient.getEditorView().save();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    public void saveAs(final String string) throws Exception {
        this.executeRunnableWithDeclaredException(new Runnable(){

            @Override
            public void run() {
                try {
                    MatlabEditor.this.fEditorViewClient.getEditorView().saveAs(string);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
        });
    }

    private void executeRunnableWithDeclaredException(Runnable runnable) throws Exception {
        try {
            AWTUtilities.invokeAndWait((Runnable)runnable);
        }
        catch (Throwable throwable) {
            throw new Exception(throwable);
        }
    }

    public Document getDocument() {
        return this.fEditorViewClient.getEditorView().getSyntaxTextPane().getDocument();
    }

    public void smartIndentContents() {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                if (MatlabEditor.this.fEditorViewClient.getEditorView() != null) {
                    EditorViewUtils.smartIndent(MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane());
                }
            }
        });
    }

    public void setEditable(final boolean bl) {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.getEditorView().getSyntaxTextPane().setEditable(bl);
            }
        });
    }

    public boolean isEditable() {
        return this.fEditorViewClient.getEditorView().getSyntaxTextPane().isEditable();
    }

    public void fireEditorEvent(EditorEvent editorEvent) {
        EditorEventListener[] editorEventListenerArray;
        for (EditorEventListener editorEventListener : editorEventListenerArray = this.fEventListeners.toArray(new EditorEventListener[this.fEventListeners.size()])) {
            editorEventListener.eventOccurred(editorEvent);
        }
    }

    public void addEventListener(EditorEventListener editorEventListener) {
        if (this.fEventListeners.contains(editorEventListener)) {
            throw new IllegalArgumentException("Already registered listener " + editorEventListener);
        }
        this.fEventListeners.add(editorEventListener);
    }

    public void removeEventListener(EditorEventListener editorEventListener) {
        this.fEventListeners.remove(editorEventListener);
    }

    public Object getProperty(Object object) {
        this.validateEditorHasNotBeenDisposed();
        return this.fPropertyMap.get(object);
    }

    public void putProperty(String string, Object object) {
        this.fPropertyMap.put(string, object);
    }

    public EditorLanguage getLanguage() {
        Object object = this.getProperty(LANGUAGE_PROPERTY);
        assert (object instanceof EditorLanguage) : "The language property must be of type EditorLanguage but was " + object + " .";
        return (EditorLanguage)object;
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.getPropertyChangeSupport().firePropertyChange(string, object, object2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(string, propertyChangeListener);
    }

    public int[] positionToLineAndColumn(int n) {
        int n2 = EditorViewUtils.boundPosition(this.fEditorViewClient.getEditorView().getSyntaxTextPane(), n);
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        int n3 = DocumentUtils.getLineNumberFromPosition((BaseDocument)baseDocument, (int)n2);
        int n4 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n3);
        return new int[]{n3 + 1, n2 - n4 + 1};
    }

    public int lineAndColumnToPosition(int n, int n2) {
        int n3;
        int n4 = EditorViewUtils.boundAndShiftLineNumber(this.fEditorViewClient.getEditorView().getSyntaxTextPane(), n);
        int n5 = Math.max(1, n2) - 1;
        BaseDocument baseDocument = (BaseDocument)this.getDocument();
        int n6 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n4);
        try {
            n3 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n6);
        }
        catch (BadLocationException badLocationException) {
            n3 = n6;
        }
        return n6 + Math.min(n3 - n6, n5);
    }

    public String saveAndReturnError() {
        try {
            this.save();
        }
        catch (Exception exception) {
            return exception.getLocalizedMessage();
        }
        return "";
    }

    public String saveAsAndReturnError(String string) {
        try {
            this.saveAs(string);
        }
        catch (Exception exception) {
            return exception.getLocalizedMessage();
        }
        return "";
    }

    public String reloadAndReturnError() {
        try {
            this.reload(false);
        }
        catch (Exception exception) {
            return exception.getLocalizedMessage();
        }
        return "";
    }

    private void validateEditorHasNotBeenDisposed() {
        if (this.fHasBeenDisposed) {
            throw new IllegalStateException("This buffer is closed.");
        }
    }

    private void validateEditability() {
        if (!this.isEditable()) {
            throw new IllegalStateException("The Editor is currently uneditable.");
        }
    }

    private void reload(final boolean bl) {
        EditorUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MatlabEditor.this.fEditorViewClient.reload(bl);
            }
        });
    }
}

