/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.dataview.UiInfoProvider;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.mde.autosave.AutoSaveImplementor;
import com.mathworks.mde.autosave.AutoSaveUtils;
import com.mathworks.widgets.datamodel.TextFileBackingStore;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.swing.text.Document;
import org.apache.commons.io.FileUtils;

public class TextFileBackingStoreAutoSaveImplementor
implements AutoSaveImplementor {
    public static final String AUTO_SAVE_FILE_CLIENT_PROPERTY = "autoSaveFile";
    private final Editor fEditor;
    private final TextFileBackingStore fBackingStore;
    private final UiInfoProvider fUiInfoProvider;
    private File fAutoSaveFile;

    public TextFileBackingStoreAutoSaveImplementor(Editor editor, TextFileBackingStore textFileBackingStore, UiInfoProvider uiInfoProvider) {
        if (editor == null) {
            throw new IllegalArgumentException("The given Editor cannot be null.");
        }
        if (textFileBackingStore == null) {
            throw new IllegalArgumentException("The given TextFileBackingStore cannot be null.");
        }
        if (uiInfoProvider == null) {
            throw new IllegalArgumentException("The given UiInfoProvider cannot be null.");
        }
        this.fEditor = editor;
        this.fBackingStore = textFileBackingStore;
        this.fUiInfoProvider = uiInfoProvider;
        this.updateAndCreateAutoSaveFile();
        this.fBackingStore.addPropertyChangeListener("backingData", this.createBackingDataPropertyChangeListener());
    }

    private PropertyChangeListener createBackingDataPropertyChangeListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextFileBackingStoreAutoSaveImplementor.this.updateAndCreateAutoSaveFile();
            }
        };
    }

    public File getAutoSaveFile() {
        return this.fAutoSaveFile;
    }

    private void updateAndCreateAutoSaveFile() {
        File file;
        this.fAutoSaveFile = this.fBackingStore.isPersistenceLocationSet() ? AutoSaveUtils.translateToAutoSaveFile(this.fBackingStore.getFile().getName(), this.fBackingStore.getFile().getParent()) : AutoSaveUtils.translateBufferToAutoSaveFile(this.fUiInfoProvider.getShortName(), this.fBackingStore.getDefaultDirectoryLocationAtTimeOfCreation().getAbsolutePath());
        File file2 = file = this.fAutoSaveFile == null ? null : this.fAutoSaveFile.getParentFile();
        if (file != null && !file.exists()) {
            try {
                FileUtils.forceMkdir((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.fEditor.putProperty(AUTO_SAVE_FILE_CLIENT_PROPERTY, (Object)this.fAutoSaveFile);
        this.fEditor.fireEditorEvent(EditorEvent.AUTOSAVE_OPTIONS_CHANGED);
    }

    @Override
    public File autoSave() {
        try {
            if (this.fAutoSaveFile != null && this.fEditor.isDirty()) {
                com.mathworks.util.FileUtils.write((Document)this.fEditor.getDocument(), (File)this.fAutoSaveFile, (Charset)this.fBackingStore.getFileEncoding());
                this.fEditor.fireEditorEvent(EditorEvent.AUTOSAVED);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.fAutoSaveFile;
    }

    @Override
    public void setStatusText(String string) {
        this.fEditor.setStatusText(string);
    }

    @Override
    public void autoSaveOptionsChanged() {
        this.updateAndCreateAutoSaveFile();
    }
}

