/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mde.help.HelpBrowserPrefs;
import com.mathworks.mde.help.HelpOnSelectionPanel;
import com.mathworks.mde.help.HelpPrefsComponentPanel;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.LanguagePrefsPanel;
import com.mathworks.mde.help.ProductFilterPanel;
import com.mathworks.mde.help.SearchHistoryPrefsPanel;
import com.mathworks.mlwidgets.help.HelpPopup;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

class ClassicHelpPrefsPanel
implements HelpPrefsComponentPanel {
    private final MJPanel fPanel;
    private final ProductFilterPanel fProductFilterPanel;
    private final SearchHistoryPrefsPanel fSearchHistoryPrefsPanel;
    private final HelpOnSelectionPanel fHelpOnSelectionPanel;
    private MJTextField fPdfInputField;
    private LanguagePrefsPanel fLanguagePrefsPanel;

    ClassicHelpPrefsPanel() {
        boolean bl = HelpUtils.canOverrideDocLocale();
        int n = bl ? 4 : 10;
        this.fPanel = new MJPanel();
        this.fPanel.putClientProperty((Object)"mwjavaguitest.instance", (Object)this);
        this.fPanel.setName("ClassicHelpPrefsPanel");
        this.fPanel.setLayout((LayoutManager)new MGridLayout(0, 1, 4, 4, 131072));
        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(HelpUtils.getLocalizedString((String)"prefs.product_filter_text"));
        mJMultilineLabel.getAccessibleContext().setAccessibleName(HelpUtils.getLocalizedString((String)"prefs.product_filter_text"));
        this.fProductFilterPanel = new ProductFilterPanel(n);
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("2dlu, pref:grow", "2dlu, pref, 3dlu, pref, 2dlu"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJMultilineLabel, cellConstraints.xy(2, 2));
        panelBuilder.add((Component)((Object)this.fProductFilterPanel), cellConstraints.xy(2, 4));
        panelBuilder.getPanel().setName("Product Filter Panel");
        panelBuilder.getPanel().getAccessibleContext().setAccessibleName(HelpUtils.getLocalizedString((String)"search.menu.filter_by_product"));
        panelBuilder.setBorder((Border)BorderFactory.createTitledBorder(HelpUtils.getLocalizedString((String)"search.menu.filter_by_product")));
        this.fPanel.add((Component)panelBuilder.getPanel());
        if (PlatformInfo.isXWindows()) {
            String string = ClassicHelpPrefsPanel.getPdfReader();
            this.fPdfInputField = new MJTextField();
            this.fPdfInputField.setText(string);
            MJButton mJButton = new MJButton("...");
            mJButton.setMargin(new Insets(0, 0, 0, 0));
            mJButton.addActionListener(new PDFBrowseActionListener());
            PanelBuilder panelBuilder2 = new PanelBuilder(new FormLayout("2dlu, pref:grow, 2dlu, pref, 2dlu", "2dlu, pref, 2dlu"));
            panelBuilder2.add((Component)this.fPdfInputField, cellConstraints.xy(2, 2));
            panelBuilder2.add((Component)mJButton, cellConstraints.xy(4, 2));
            panelBuilder2.getPanel().getAccessibleContext().setAccessibleName(HelpUtils.getLocalizedString((String)"prefs.pdf_reader"));
            panelBuilder2.setBorder((Border)BorderFactory.createTitledBorder(HelpUtils.getLocalizedString((String)"prefs.pdf_reader")));
            this.fPanel.add((Component)panelBuilder2.getPanel());
        }
        this.fHelpOnSelectionPanel = new HelpOnSelectionPanel();
        this.fPanel.add((Component)this.fHelpOnSelectionPanel.getComponent());
        this.fSearchHistoryPrefsPanel = new SearchHistoryPrefsPanel();
        this.fPanel.add((Component)this.fSearchHistoryPrefsPanel.getComponent());
        if (bl) {
            this.fLanguagePrefsPanel = new LanguagePrefsPanel();
            this.fPanel.add((Component)this.fLanguagePrefsPanel.getComponent());
        }
    }

    @Override
    public boolean validateOptions() {
        boolean bl = true;
        if (this.fProductFilterPanel.isProductFilterEnabled() && this.fProductFilterPanel.getSelectedProducts().length() == 0) {
            MJOptionPane.showMessageDialog((Component)this.fPanel, (Object)HelpUtils.getLocalizedString((String)"filter.selection_error"));
            bl = false;
        }
        return bl;
    }

    private static String getPdfReader() {
        if (PlatformInfo.isWindows()) {
            return NativeJava.getAcrobatPath();
        }
        return HelpBrowserPrefs.getPdfReader();
    }

    @Override
    public void savePrefs() {
        int n;
        if (PlatformInfo.isXWindows()) {
            String string = this.fPdfInputField.getText();
            HelpBrowserPrefs.setPdfReader(string);
        }
        boolean bl = this.fProductFilterPanel.isProductFilterEnabled();
        HelpPrefs.setProductFilterEnabled((boolean)bl);
        if (bl) {
            this.fProductFilterPanel.saveSelectedProducts();
        }
        if ((n = this.fSearchHistoryPrefsPanel.getHistorySize()) != HelpBrowserPrefs.getSearchHistoryMaximumSize()) {
            HelpBrowserPrefs.setSearchHistoryMaximumSize(n);
        }
        HelpPopup.setShowHelpBrowserPreference((boolean)this.fHelpOnSelectionPanel.usingHelpBrowser());
        if (this.fLanguagePrefsPanel != null) {
            Locale locale = this.fLanguagePrefsPanel.getSelectedLocale();
            HelpPrefs.setDocLocale((Locale)locale);
        }
    }

    @Override
    public void resetPrefs() {
        this.getProductFilterPanel().resetSelectedProducts();
    }

    private ProductFilterPanel getProductFilterPanel() {
        return this.fProductFilterPanel;
    }

    @Override
    public void dispose() {
        SearchHistoryPrefsPanel.removeListeners();
    }

    public JComponent getComponent() {
        return this.fPanel;
    }

    private class PDFBrowseActionListener
    implements ActionListener {
        private PDFBrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FileDialog fileDialog = new FileDialog((Frame)SwingUtilities.windowForComponent((Component)ClassicHelpPrefsPanel.this.fPanel), HelpUtils.getLocalizedString((String)"prefs.pdf_browse_title"), 0);
            fileDialog.setVisible(true);
            String string = fileDialog.getFile();
            if (string != null) {
                File file = new File(fileDialog.getDirectory(), string);
                ClassicHelpPrefsPanel.this.fPdfInputField.setText(file.getAbsolutePath());
            }
        }
    }
}

