/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.help.helpui.ComponentHelper;
import com.mathworks.help.helpui.DocSearchPageChangedListener;
import com.mathworks.help.helpui.HelpBrowserComponent;
import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.help.helpui.suggestions.DocSuggestionProtocolHandler;
import com.mathworks.html.HtmlComponent;
import com.mathworks.html.HtmlContextMenuBuilder;
import com.mathworks.html.PageChangedEvent;
import com.mathworks.html.PageChangedListener;
import com.mathworks.html.RequestHandler;
import com.mathworks.html.StandardHtmlActionId;
import com.mathworks.html.StatusTextChangedEvent;
import com.mathworks.html.StatusTextListener;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.help.HelpInfoBarComponent;
import com.mathworks.mde.help.HelpLocator;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.InstalledLinkClickedHandler;
import com.mathworks.mde.help.MLHelpBrowserActiveTab;
import com.mathworks.mde.help.MLHelpBrowserGroup;
import com.mathworks.mde.help.NewFavoriteAction;
import com.mathworks.mde.help.OrganizeFavoritesAction;
import com.mathworks.mde.help.ProductFilterRequestHandler;
import com.mathworks.mde.help.UrlDisplayBehavior;
import com.mathworks.mde.help.UserFavoriteAction;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import com.mathworks.mlwidgets.help.DocCenterUtils;
import com.mathworks.mlwidgets.help.HelpComponentHelper;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpToolBar;
import com.mathworks.mlwidgets.html.DocSearchRequestHandler;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HtmlComponentFactory;
import com.mathworks.mlwidgets.html.HtmlConversionUtils;
import com.mathworks.mlwidgets.html.LinkClickedHandler;
import com.mathworks.mlwidgets.html.MJHtmlPanel;
import com.mathworks.mlwidgets.html.MatlabContextMenuBuilder;
import com.mathworks.mlwidgets.html.MatlabHtmlActions;
import com.mathworks.mlwidgets.html.OpenUrlInBrowser;
import com.mathworks.mlwidgets.shortcuts.Shortcut;
import com.mathworks.mlwidgets.shortcuts.ShortcutUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJStatusBar;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.CloseableMessageBar;
import com.mathworks.widgets.DropdownButton;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTGroupPropertyProvider;
import com.mathworks.widgets.desk.DTLocation;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class MLHelpBrowser
extends DTClientBase {
    private static final ResourceBundle sPrefRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private static final ResourceBundle sHtmlBundle = ResourceBundle.getBundle("com.mathworks.mlwidgets.html.resources.RES_HTMLRenderer");
    private static final ResourceBundle sResDocCenterNoTranslation = ResourceBundle.getBundle("com.mathworks.mlwidgets.help.resources.RES_DocCenterInfo_notranslation");
    private final HelpBrowserComponent fHelpBrowserComponent;
    private final MJPanel fInfoBarArea;
    private final MJStatusBar fStatusBar;
    private final Map<HelpInfoBarComponent, HelpBrowserMessageBar> fInfoBars = new HashMap<HelpInfoBarComponent, HelpBrowserMessageBar>();
    private final MJPopupMenu fPopupMenu;
    private final MJAbstractAction fNewFavoriteAction;
    private final MJAbstractAction fOrganizeFavoritesAction;
    private final ActionListener fShortCutsListener;
    private final boolean fViewingInstalledDoc;
    private String fClientTitle;
    private PageChangedListener fHelpPageChangedListener;
    private StatusTextListener fHelpStatusTextListener;
    private PageChangedListener fDocSearchPageChangedListener;
    private LinkClickedHandler fInstalledLinkClickedHandler;

    public MLHelpBrowser() {
        assert (SwingUtilities.isEventDispatchThread()) : "MLHelpBrowser must be created on the EDT.";
        String string = HelpPrefs.getDocCenterRoot();
        this.fViewingInstalledDoc = !HelpBrowserUtils.isWebAddress((String)string);
        this.setLayout(new BorderLayout());
        this.setName(this.getUniqueClientName());
        this.setClientName(this.getName());
        this.getAccessibleContext().setAccessibleName(this.getName());
        HtmlComponent<MatlabHtmlActions> htmlComponent = this.createHtmlComponent();
        this.fHelpBrowserComponent = new HelpBrowserComponent(htmlComponent, null);
        this.add(this.fHelpBrowserComponent.getComponent());
        this.setDontMergeMenu(true);
        this.setDontReopen(true);
        this.setGroup((DTGroupPropertyProvider)MLHelpBrowserGroup.getInstance());
        this.setMultipleInstances(true);
        this.setPermitUserUndock(false);
        HelpToolBar helpToolBar = new HelpToolBar(this.getActions(htmlComponent), (ComponentHelper)new HelpComponentHelper(), this.getDocCenterToolBarButtons());
        this.setToolBar((JToolBar)helpToolBar.getComponent());
        this.setContextActions(this.getContextActions(htmlComponent));
        this.fStatusBar = new MJStatusBar();
        this.fStatusBar.setName("Doc Center Status Bar");
        this.fStatusBar.getAccessibleContext().setAccessibleName("Doc Center Status Bar");
        this.setStatusBar(this.fStatusBar);
        this.fInfoBarArea = new MJPanel();
        this.fInfoBarArea.setLayout((LayoutManager)new BoxLayout((Container)this.fInfoBarArea, 1));
        this.addToActiveTab();
        this.addClientToDesktop();
        this.fPopupMenu = new MJPopupMenu();
        this.fNewFavoriteAction = new NewFavoriteAction(this);
        this.fOrganizeFavoritesAction = new OrganizeFavoritesAction(this);
        this.addActionsToFavoritesMenu();
        this.fShortCutsListener = new HelpShortcutsListener();
        ShortcutUtils.addFavoritesListener((ActionListener)this.fShortCutsListener);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                MLHelpBrowser.this.requestFocusInBrowser();
            }
        });
    }

    private Action[] getContextActions(HtmlComponent<MatlabHtmlActions> htmlComponent) {
        ArrayList<Action> arrayList = new ArrayList<Action>();
        Map map = ((MatlabHtmlActions)htmlComponent.getActions()).getBasicActions();
        Action action = (Action)map.get(StandardHtmlActionId.COPY);
        ContextTargetingManager.setToolName((Action)action, (String)DTMenuMergeTag.COPY.toString());
        arrayList.add(action);
        Action action2 = (Action)map.get(StandardHtmlActionId.PRINT);
        ContextTargetingManager.setToolName((Action)action2, (String)DTMenuMergeTag.PRINT.toString());
        arrayList.add(action2);
        Action action3 = (Action)map.get(StandardHtmlActionId.FIND);
        ContextTargetingManager.setToolName((Action)action3, (String)DTMenuMergeTag.FIND.toString());
        arrayList.add(action3);
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    private Map<StandardHtmlActionId, ? extends Action> getActions(HtmlComponent<MatlabHtmlActions> htmlComponent) {
        Map map = ((MatlabHtmlActions)htmlComponent.getActions()).getBasicActions();
        HashMap hashMap = new HashMap();
        hashMap.put(StandardHtmlActionId.GO_BACK, map.get(StandardHtmlActionId.GO_BACK));
        hashMap.put(StandardHtmlActionId.GO_FORWARD, map.get(StandardHtmlActionId.GO_FORWARD));
        hashMap.put(StandardHtmlActionId.PRINT, map.get(StandardHtmlActionId.PRINT));
        return hashMap;
    }

    private Collection<MJButton> getDocCenterToolBarButtons() {
        LinkedHashSet<MJButton> linkedHashSet = new LinkedHashSet<MJButton>();
        DropdownButton dropdownButton = this.getFavoritesButton();
        MJButton mJButton = new MJButton();
        mJButton.setName("SettingsButton");
        mJButton.getAccessibleContext().setAccessibleName("SettingsButton");
        mJButton.setToolTipText(HelpUtils.getLocalizedString((String)"doccenter.toolbar.settings"));
        mJButton.setIcon((Icon)DocumentIcon.ACTIONS.getIcon());
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLPrefsDialogServices.showPrefsDialog((String)sPrefRes.getString("area.help"));
            }
        });
        linkedHashSet.add((MJButton)dropdownButton);
        linkedHashSet.add(mJButton);
        return linkedHashSet;
    }

    private DropdownButton getFavoritesButton() {
        ImageIcon imageIcon;
        DropdownButton dropdownButton = new DropdownButton();
        if (PlatformInfo.isMacintosh()) {
            dropdownButton.setMargin(new Insets(5, 6, 6, 6));
        }
        dropdownButton.setName("FavoritesButton");
        dropdownButton.getAccessibleContext().setAccessibleName("FavoritesButton");
        dropdownButton.setToolTipText(HelpUtils.getLocalizedString((String)"doccenter.toolbar.favorites"));
        String string = HelpUtils.getLocalizedString((String)"doccenter.toolbar.button.favorites.alttext");
        URL uRL = HelpBrowserUtils.getImageURL((String)sResDocCenterNoTranslation.getString("toolbar.resource.directory.path"), (String)sResDocCenterNoTranslation.getString("toolbar.image.favorites"));
        ImageIcon imageIcon2 = imageIcon = uRL != null ? new ImageIcon(uRL, string) : null;
        if (imageIcon != null) {
            dropdownButton.setIcon((Icon)imageIcon);
        } else {
            dropdownButton.setText(string);
        }
        dropdownButton.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!PlatformInfo.isMacintosh()) {
                    MLHelpBrowser.this.fPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (PlatformInfo.isMacintosh()) {
                    MLHelpBrowser.this.fPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return dropdownButton;
    }

    private List<MJAbstractAction> getUserFavoriteActions() {
        Vector<MJAbstractAction> vector = new Vector<MJAbstractAction>();
        Vector vector2 = ShortcutUtils.getShortcutsByCategory((String)ShortcutUtils.getDefaultHelpCategoryName());
        if (vector2 != null) {
            for (int i = 0; i < vector2.size(); ++i) {
                Shortcut shortcut = (Shortcut)vector2.elementAt(i);
                vector.add(new UserFavoriteAction(shortcut.getLabel(), shortcut.getCallback(), shortcut.getIcon()));
            }
        }
        return vector;
    }

    private String getUniqueClientName() {
        int n = MLHelpBrowserGroup.getNextClientNum();
        String string = "New Help Browser " + String.valueOf(n);
        return string;
    }

    private void addToActiveTab() {
        MLHelpBrowserActiveTab.addHelpBrowserTab(this);
    }

    private void addClientToDesktop() {
        MLDesktop mLDesktop = MLDesktop.getInstance();
        DTLocation dTLocation = mLDesktop.hasMainFrame() ? null : DTLocation.createExternal((int)10, (int)10, (int)800, (int)600);
        mLDesktop.addClient((Component)((Object)this), "Doc Center", false, dTLocation, true, null);
    }

    public void dispose() {
        ShortcutUtils.removeFavoritesListener((ActionListener)this.fShortCutsListener);
        HelpBrowserDisposeVisitor helpBrowserDisposeVisitor = new HelpBrowserDisposeVisitor();
        HtmlConversionUtils.visitBrowser((HtmlComponent)this.fHelpBrowserComponent.getHtmlComponent(), (HtmlConversionUtils.BrowserVisitor)helpBrowserDisposeVisitor);
        this.fHelpBrowserComponent.dispose();
    }

    private synchronized void setClientTitle(String string) {
        this.fClientTitle = string;
        this.setDTClientTitle(string);
    }

    private synchronized void setDTClientTitle(String string) {
        this.setTitle(string);
    }

    synchronized String getClientTitle() {
        return this.fClientTitle;
    }

    private HtmlComponent<MatlabHtmlActions> createHtmlComponent() {
        HtmlComponent htmlComponent = HtmlComponentFactory.buildHtmlComponent((HtmlComponentFactory.HtmlComponentType[])new HtmlComponentFactory.HtmlComponentType[]{HtmlComponentFactory.HtmlComponentType.FOLLOW_PREFERENCE, HtmlComponentFactory.HtmlComponentType.HTMLPANEL, HtmlComponentFactory.HtmlComponentType.HTMLRENDERER});
        HelpBrowserVisitor helpBrowserVisitor = new HelpBrowserVisitor();
        HtmlConversionUtils.visitBrowser((HtmlComponent)htmlComponent, (HtmlConversionUtils.BrowserVisitor)helpBrowserVisitor);
        return htmlComponent;
    }

    private void addHandlersForInstalledDoc(MJHtmlPanel mJHtmlPanel) {
        DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
        this.fDocSearchPageChangedListener = new DocSearchPageChangedListener((HtmlComponent)mJHtmlPanel, (SearchHelper)docCenterSearchHelper, HelpPrefs.DEFAULT_DOC_RELEASE);
        mJHtmlPanel.addPageChangedListener(this.fDocSearchPageChangedListener);
        mJHtmlPanel.addRequestHandler((RequestHandler)new DocSuggestionProtocolHandler((HtmlComponent)mJHtmlPanel, (SearchHelper)docCenterSearchHelper, HelpPrefs.getDocCenterRoot()));
        mJHtmlPanel.addRequestHandler((RequestHandler)new ProductFilterRequestHandler((HtmlComponent)mJHtmlPanel, docCenterSearchHelper.getDocumentationSet()));
        mJHtmlPanel.addRequestHandler((RequestHandler)new InstalledLinkClickedHandler(this));
    }

    void showClient() {
        this.showClient(DocCenterUtils.buildDocCenterUrl());
    }

    void showClient(String string) {
        MLDesktop.getInstance().showClient((Component)((Object)this), null, true);
        this.setCurrentLocation(string);
    }

    void setCurrentLocation(String string) {
        UrlDisplayBehavior urlDisplayBehavior = new UrlDisplayBehavior(string, this.fViewingInstalledDoc);
        switch (urlDisplayBehavior.getDisplayBehavior()) {
            case OPEN_URL_IN_SYSTEM_BROWSER: {
                this.openInSystemBrowser(urlDisplayBehavior.getUrl());
                return;
            }
            case OPEN_URL_IN_HELP_BROWSER: 
            case OPEN_CHANGED_URL_IN_HELP_BROWSER: {
                String string2 = urlDisplayBehavior.getUrl().replace('\\', '/');
                this.fHelpBrowserComponent.setCurrentLocation(string2);
                this.requestFocusInBrowser();
                return;
            }
        }
    }

    void openInSystemBrowser(String string) {
        final String string2 = "web('" + string + "','-browser')";
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                MLHelpBrowser.this.doMatlabEval(string2);
            }
        });
    }

    private synchronized void doMatlabEval(String string) {
        new Matlab().evalConsoleOutput(string);
    }

    String getCurrentLocation() {
        return this.fHelpBrowserComponent.getCurrentLocation();
    }

    void addInfoMessageBar(HelpInfoBarComponent helpInfoBarComponent) {
        for (HelpInfoBarComponent helpInfoBarComponent2 : this.fInfoBars.keySet()) {
            if (!helpInfoBarComponent2.getClass().equals(helpInfoBarComponent.getClass())) continue;
            this.removeInfoMessageBar(helpInfoBarComponent2);
        }
        Object object = new HelpBrowserMessageBar(helpInfoBarComponent);
        object.getComponent().setName(helpInfoBarComponent.getMessageBarName());
        this.fInfoBars.put(helpInfoBarComponent, (HelpBrowserMessageBar)((Object)object));
        this.fInfoBarArea.add((Component)object.getComponent());
        if (this.fInfoBars.size() == 1) {
            this.add((Component)this.fInfoBarArea, "North");
        }
        this.revalidate();
        this.repaint();
    }

    void removeInfoMessageBar(HelpInfoBarComponent helpInfoBarComponent) {
        HelpBrowserMessageBar helpBrowserMessageBar = this.fInfoBars.get(helpInfoBarComponent);
        if (helpBrowserMessageBar != null) {
            this.fInfoBarArea.remove((Component)helpBrowserMessageBar.getComponent());
            helpInfoBarComponent.infoBarRemoved();
            if (this.fInfoBars.isEmpty()) {
                this.remove((Component)this.fInfoBarArea);
            }
            this.revalidate();
            this.repaint();
        }
    }

    private void requestFocusInBrowser() {
        MLDesktop.getInstance().setClientSelected((Component)((Object)this), true);
        this.fHelpBrowserComponent.getHtmlComponent().getComponent().requestFocusInWindow();
    }

    void addPageChangedListener(PageChangedListener pageChangedListener) {
        this.fHelpBrowserComponent.getHtmlComponent().addPageChangedListener(pageChangedListener);
    }

    void removePageChangedListener(PageChangedListener pageChangedListener) {
        this.fHelpBrowserComponent.getHtmlComponent().removePageChangedListener(pageChangedListener);
    }

    private void addActionsToFavoritesMenu() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MLHelpBrowser.this.fPopupMenu.removeAll();
                MLHelpBrowser.this.fPopupMenu.add((Action)MLHelpBrowser.this.fNewFavoriteAction);
                MLHelpBrowser.this.fPopupMenu.add((Action)MLHelpBrowser.this.fOrganizeFavoritesAction);
                List list = MLHelpBrowser.this.getUserFavoriteActions();
                if (list != null && !list.isEmpty()) {
                    MLHelpBrowser.this.fPopupMenu.addSeparator();
                    for (MJAbstractAction mJAbstractAction : list) {
                        MLHelpBrowser.this.fPopupMenu.add((Action)mJAbstractAction);
                    }
                }
            }
        });
    }

    private class HelpShortcutsListener
    implements ActionListener {
        private HelpShortcutsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MLHelpBrowser.this.addActionsToFavoritesMenu();
        }
    }

    private class HelpBrowserMessageBar
    extends CloseableMessageBar {
        private HelpBrowserMessageBar(final HelpInfoBarComponent helpInfoBarComponent) {
            super(helpInfoBarComponent.getComponent(), (Icon)CommonIcon.INFO.getIcon(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MLHelpBrowser.this.removeInfoMessageBar(helpInfoBarComponent);
                }
            });
        }
    }

    private class InvokeHelpLocatorAction
    extends MJAbstractAction {
        private InvokeHelpLocatorAction() {
            super(sHtmlBundle.getString("Action.get-page-address"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpLocator.invokeFromDocCenter((MJFrame)SwingUtilities.windowForComponent((Component)((Object)MLHelpBrowser.this)));
        }
    }

    private class DocCenterOpenUrlInBrowser
    implements OpenUrlInBrowser {
        private DocCenterOpenUrlInBrowser() {
        }

        public void openInCurrentTab(String string) {
            MLHelpServices.setCurrentLocation((String)string);
        }

        public void openInNewTab(String string) {
            MLHelpServices.openInNewBrowser((String)string);
        }
    }

    private class HelpBrowserStatusTextListener
    implements StatusTextListener {
        private HelpBrowserStatusTextListener() {
        }

        public void statusChanged(final StatusTextChangedEvent statusTextChangedEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MLHelpBrowser.this.fStatusBar.setText(statusTextChangedEvent.getStatusText());
                }
            });
        }
    }

    private class HelpBrowserDisposeVisitor
    implements HtmlConversionUtils.BrowserVisitor {
        private HelpBrowserDisposeVisitor() {
        }

        public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            if (MLHelpBrowser.this.fHelpPageChangedListener != null) {
                mJHtmlPanel.removePageChangedListener(MLHelpBrowser.this.fHelpPageChangedListener);
                MLHelpBrowser.this.fHelpPageChangedListener = null;
            }
            if (MLHelpBrowser.this.fHelpStatusTextListener != null) {
                mJHtmlPanel.removeStatusTextListener(MLHelpBrowser.this.fHelpStatusTextListener);
                MLHelpBrowser.this.fHelpStatusTextListener = null;
            }
            if (MLHelpBrowser.this.fViewingInstalledDoc && MLHelpBrowser.this.fDocSearchPageChangedListener != null) {
                mJHtmlPanel.removePageChangedListener(MLHelpBrowser.this.fDocSearchPageChangedListener);
                MLHelpBrowser.this.fDocSearchPageChangedListener = null;
            }
        }

        public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
            if (MLHelpBrowser.this.fInstalledLinkClickedHandler != null) {
                hTMLRenderer.removeLinkClickedHandler(MLHelpBrowser.this.fInstalledLinkClickedHandler);
                MLHelpBrowser.this.fInstalledLinkClickedHandler = null;
            }
        }
    }

    private class HelpBrowserVisitor
    implements HtmlConversionUtils.BrowserVisitor {
        private HelpBrowserVisitor() {
        }

        public void visitMJHtmlPanel(MJHtmlPanel mJHtmlPanel) {
            mJHtmlPanel.setHtmlContextMenuBuilder((HtmlContextMenuBuilder)new MatlabContextMenuBuilder(mJHtmlPanel, (OpenUrlInBrowser)new DocCenterOpenUrlInBrowser(), (MJAbstractAction)new InvokeHelpLocatorAction()));
            mJHtmlPanel.getComponent().setName("MJHtmlPanel");
            MLHelpBrowser.this.fHelpPageChangedListener = new HelpPageChangedListener();
            mJHtmlPanel.addPageChangedListener(MLHelpBrowser.this.fHelpPageChangedListener);
            MLHelpBrowser.this.fHelpStatusTextListener = new HelpBrowserStatusTextListener();
            mJHtmlPanel.addStatusTextListener(MLHelpBrowser.this.fHelpStatusTextListener);
            if (MLHelpBrowser.this.fViewingInstalledDoc) {
                MLHelpBrowser.this.addHandlersForInstalledDoc(mJHtmlPanel);
            }
        }

        public void visitHTMLRenderer(HTMLRenderer hTMLRenderer) {
            hTMLRenderer.addRequestHandler((RequestHandler)new DocSearchRequestHandler(hTMLRenderer, (SearchHelper)DocCenterSearchHelper.getInstance(), HelpPrefs.DEFAULT_DOC_RELEASE));
            if (MLHelpBrowser.this.fViewingInstalledDoc) {
                MLHelpBrowser.this.fInstalledLinkClickedHandler = new InstalledLinkClickedHandler(MLHelpBrowser.this);
                hTMLRenderer.setLinkClickedHandler(MLHelpBrowser.this.fInstalledLinkClickedHandler);
            }
        }
    }

    private class HelpPageChangedListener
    implements PageChangedListener {
        private HelpPageChangedListener() {
        }

        public void pageChanged(PageChangedEvent pageChangedEvent) {
            String string = pageChangedEvent.getTitle();
            MLHelpBrowser.this.setClientTitle(string);
            String string2 = pageChangedEvent.getFullUrl();
            MLHelpBrowser.this.fNewFavoriteAction.setEnabled(string2 != null && !string2.startsWith("text://"));
        }
    }
}

