/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mde.help.HelpBrowserPrefs;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.SearchHistoryEventDispatcher;
import com.mathworks.mde.help.SearchHistoryListener;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSpinner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;

class SearchHistoryPrefsPanel {
    private static PrefsPanelSearchHistoryListener sPrefsPanelSearchHistoryListener;
    private MJPanel fSearchHistoryPrefsPanel = new MJPanel();
    private MJSpinner fHistorySizeField;
    private MJButton fClearButton;

    SearchHistoryPrefsPanel() {
        this.fSearchHistoryPrefsPanel.setLayout((LayoutManager)new BorderLayout());
        MJLabel mJLabel = new MJLabel(HelpUtils.getLocalizedString((String)"prefs.history.label"));
        mJLabel.setName("HistorySizeLabel");
        this.fHistorySizeField = new MJSpinner((SpinnerModel)new SpinnerNumberModel(HelpBrowserPrefs.getSearchHistoryMaximumSize(), 0, 10000, 1));
        this.fHistorySizeField.setName("HistorySizeField");
        this.fHistorySizeField.setDefaultEditorAccessibleName(HelpUtils.getLocalizedString((String)"prefs.history.label"));
        this.fClearButton = new MJButton(HelpUtils.getLocalizedString((String)"prefs.history.clear"));
        this.fClearButton.setName("HistoryClearButton");
        this.fClearButton.getAccessibleContext().setAccessibleName(HelpUtils.getLocalizedString((String)"prefs.history.clear"));
        this.fClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchHistoryEventDispatcher.getInstance().searchHistoryCleared();
            }
        });
        this.fClearButton.setEnabled(!SearchHistoryEventDispatcher.getInstance().isHistoryEmpty());
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("2dlu, left:pref, 2dlu, pref, 2dlu, right:pref:grow, 2dlu", "2dlu, pref, 2dlu"));
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJLabel, cellConstraints.xy(2, 2));
        panelBuilder.add((Component)this.fHistorySizeField, cellConstraints.xy(4, 2));
        panelBuilder.add((Component)this.fClearButton, cellConstraints.xy(6, 2, "r, b"));
        panelBuilder.getPanel().getAccessibleContext().setAccessibleName(HelpUtils.getLocalizedString((String)"prefs.history.title"));
        panelBuilder.setBorder((Border)BorderFactory.createTitledBorder(HelpUtils.getLocalizedString((String)"prefs.history.title")));
        this.fSearchHistoryPrefsPanel.add((Component)panelBuilder.getPanel());
        sPrefsPanelSearchHistoryListener = new PrefsPanelSearchHistoryListener();
        SearchHistoryEventDispatcher.getInstance().addSearchHistoryListener(sPrefsPanelSearchHistoryListener);
    }

    JComponent getComponent() {
        return this.fSearchHistoryPrefsPanel;
    }

    int getHistorySize() {
        return this.fHistorySizeField != null ? (Integer)this.fHistorySizeField.getValue() : 500;
    }

    static void removeListeners() {
        SearchHistoryEventDispatcher.getInstance().removeSearchHistoryListener(sPrefsPanelSearchHistoryListener);
    }

    private void setClearButtonEnablement(boolean bl) {
        if (this.fClearButton.isEnabled() != bl) {
            this.fClearButton.setEnabled(bl);
        }
    }

    private class PrefsPanelSearchHistoryListener
    implements SearchHistoryListener {
        private PrefsPanelSearchHistoryListener() {
        }

        @Override
        public void searchHistoryChanged(SearchHistoryEventDispatcher.SearchHistoryEvent searchHistoryEvent) {
            if (searchHistoryEvent == null) {
                return;
            }
            switch (searchHistoryEvent) {
                case SEARCH_HISTORY_ADDED: {
                    SearchHistoryPrefsPanel.this.setClearButtonEnablement(true);
                    break;
                }
                case SEARCH_HISTORY_CLEARED: {
                    SearchHistoryPrefsPanel.this.setClearButtonEnablement(false);
                    break;
                }
                case SEARCH_HISTORY_SIZE_CHANGED: {
                    SearchHistoryPrefsPanel.this.fHistorySizeField.setValue((Object)HelpBrowserPrefs.getSearchHistoryMaximumSize());
                }
            }
        }
    }
}

