/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help.search;

import com.mathworks.mde.help.search.HelpPageDisplayHandler;
import com.mathworks.mde.help.search.HighlightProvider;
import com.mathworks.mde.help.search.SearchHighlight;
import com.mathworks.mlwidgets.help.DemoInfoItem;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.search.DemoSearchResult;
import com.mathworks.mlwidgets.help.search.DocSearchResult;
import com.mathworks.mlwidgets.help.search.RankedSearchResult;
import com.mathworks.mlwidgets.help.search.ResultType;
import java.util.Collection;
import java.util.Collections;

public class HelpBrowserSearchResult
implements Comparable<HelpBrowserSearchResult> {
    private RankedSearchResult fUnderlyingResult;
    private ResultType fType;
    private String fSummaryLine;
    private Collection<SearchHighlight> fHighlights;
    private HighlightProvider fHighlightProvider;
    private String fProduct;
    private String fSection;
    private ResultDisplayHandler fHandler;

    public HelpBrowserSearchResult(RankedSearchResult rankedSearchResult, HighlightProvider highlightProvider) {
        this.fUnderlyingResult = rankedSearchResult;
        this.fHighlightProvider = highlightProvider;
        if (rankedSearchResult instanceof DocSearchResult) {
            this.populate((DocSearchResult)rankedSearchResult);
        } else if (rankedSearchResult instanceof DemoSearchResult) {
            this.populate((DemoSearchResult)rankedSearchResult);
        }
    }

    public ResultType getType() {
        return this.fType;
    }

    public String getTitle() {
        return this.fUnderlyingResult.getTitle();
    }

    public String getSummaryLine() {
        return this.fSummaryLine;
    }

    public Collection<SearchHighlight> getHighlights() {
        if (this.fHighlights == null) {
            try {
                this.fHighlights = this.fHighlightProvider.getHighlights(this.fHandler.getTextToHighlight());
            }
            catch (Exception exception) {
                this.fHighlights = Collections.emptyList();
            }
        }
        return Collections.unmodifiableCollection(this.fHighlights);
    }

    public String getProductName() {
        return this.fProduct;
    }

    public String getSection() {
        return this.fSection;
    }

    void displayResult(String[] stringArray, HelpPageDisplayHandler helpPageDisplayHandler) {
        this.fHandler.showResultInHelpBrowser(this, stringArray, helpPageDisplayHandler);
    }

    private float getScore() {
        return this.fUnderlyingResult.getScore();
    }

    @Override
    public int compareTo(HelpBrowserSearchResult helpBrowserSearchResult) {
        int n = new Float(helpBrowserSearchResult.getScore()).compareTo(Float.valueOf(this.getScore()));
        if (n != 0) {
            return n;
        }
        int n2 = this.getType().compareTo((Enum)helpBrowserSearchResult.getType());
        if (n2 != 0) {
            return n2;
        }
        int n3 = this.getProductName().compareTo(helpBrowserSearchResult.getProductName());
        if (n3 != 0) {
            return n3;
        }
        int n4 = this.getTitle().compareTo(helpBrowserSearchResult.getTitle());
        if (n4 != 0) {
            return n4;
        }
        if (this.getSection() == null) {
            if (helpBrowserSearchResult.getSection() == null) {
                return 0;
            }
            return 1;
        }
        if (helpBrowserSearchResult.getSection() == null) {
            return -1;
        }
        return this.getSection().compareTo(helpBrowserSearchResult.getSection());
    }

    public boolean equals(Object object) {
        if (object instanceof HelpBrowserSearchResult) {
            HelpBrowserSearchResult helpBrowserSearchResult = (HelpBrowserSearchResult)object;
            return this.compareTo(helpBrowserSearchResult) == 0;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.getScore() + this.getTitle().hashCode();
    }

    private void populate(DocSearchResult docSearchResult) {
        ResultType resultType = docSearchResult.getResultType();
        if (resultType == null) {
            resultType = ResultType.USER_GUIDE;
        }
        this.fType = resultType;
        this.fSummaryLine = docSearchResult.getRefPageSummary();
        this.fProduct = docSearchResult.getProduct();
        this.fSection = docSearchResult.getSection();
        this.fHandler = new DocResultDisplayHandler(docSearchResult);
    }

    private void populate(DemoSearchResult demoSearchResult) {
        this.fType = ResultType.DEMO;
        this.fHandler = new DemoResultDisplayHandler(demoSearchResult);
        this.fProduct = DemoInfoUtils.getDemoProductFullName((DemoInfoItem)demoSearchResult);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getTitle());
        if (this.fSummaryLine != null) {
            stringBuilder.append(" - ").append(this.fSummaryLine);
        }
        if (this.fHighlights != null) {
            for (SearchHighlight searchHighlight : this.fHighlights) {
                stringBuilder.append('\n').append(searchHighlight.toString());
            }
        }
        return stringBuilder.toString();
    }

    private static class DemoResultDisplayHandler
    implements ResultDisplayHandler {
        private DemoSearchResult iResult;

        private DemoResultDisplayHandler(DemoSearchResult demoSearchResult) {
            this.iResult = demoSearchResult;
        }

        @Override
        public void showResultInHelpBrowser(HelpBrowserSearchResult helpBrowserSearchResult, String[] stringArray, HelpPageDisplayHandler helpPageDisplayHandler) {
            helpPageDisplayHandler.displayDemo((DemoInfoItem)this.iResult, stringArray);
        }

        @Override
        public String getTextToHighlight() {
            return this.iResult.getTitle() + "\n" + this.iResult.getBody();
        }
    }

    private class DocResultDisplayHandler
    implements ResultDisplayHandler {
        private DocSearchResult iResult;

        private DocResultDisplayHandler(DocSearchResult docSearchResult) {
            this.iResult = docSearchResult;
        }

        @Override
        public void showResultInHelpBrowser(HelpBrowserSearchResult helpBrowserSearchResult, String[] stringArray, HelpPageDisplayHandler helpPageDisplayHandler) {
            String string = HelpBrowserSearchResult.this.getProductName();
            if (string != null && string.length() > 0) {
                String string2 = this.iResult.getFullUrl();
                String string3 = this.iResult.getFileEncoding();
                helpPageDisplayHandler.setCurrentLocationAndHighlightKeywords(string2, string3, stringArray);
            }
        }

        @Override
        public String getTextToHighlight() {
            return this.iResult.getBody();
        }
    }

    private static interface ResultDisplayHandler {
        public void showResultInHelpBrowser(HelpBrowserSearchResult var1, String[] var2, HelpPageDisplayHandler var3);

        public String getTextToHighlight();
    }
}

