/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.datamgr.brushing;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.array.ArrayEditorProvider;
import com.mathworks.mlwidgets.array.ArrayTable;
import com.mathworks.mlwidgets.array.ValuePanel;
import com.mathworks.mlwidgets.array.brushing.SpreadsheetTableBrushManager;
import com.mathworks.page.datamgr.brushing.BrushCellTableModel;
import com.mathworks.page.datamgr.brushing.BrushTableModel;
import com.mathworks.page.datamgr.utils.DMUtils;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.spreadsheet.color.ColorTableModel;
import com.mathworks.widgets.spreadsheet.color.CompositeColorArrayTableModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ArrayEditorManager {
    private ArrayEditorManager() {
    }

    public static ArrayTable getArrayTable(String string) {
        Desktop desktop = MatlabDesktopServices.getDesktop();
        DTClientBase dTClientBase = (DTClientBase)desktop.getClient(string, "Array Editor");
        return ArrayEditorManager.getArrayTable(dTClientBase);
    }

    public static ArrayTable getArrayTable(DTClientBase dTClientBase) {
        if (dTClientBase == null) {
            return null;
        }
        ValuePanel valuePanel = (ValuePanel)DMUtils.getPropertyValue(dTClientBase, "fValuePanel");
        if (valuePanel == null) {
            return null;
        }
        Object object = DMUtils.getPropertyValue(valuePanel, "fAggregatedComponents");
        if (object == null) {
            return null;
        }
        Object object2 = DMUtils.getPropertyValue(object, "fProvider");
        if (object2 == null || !(object2 instanceof ArrayEditorProvider)) {
            return null;
        }
        Object object3 = DMUtils.getPropertyValue(object2, "fTable");
        if (object3 instanceof ArrayTable) {
            return (ArrayTable)object3;
        }
        return null;
    }

    public static void refreshAll() {
        if (SwingUtilities.isEventDispatchThread()) {
            ArrayEditorManager.utRefreshAll();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayEditorManager.utRefreshAll();
                }
            });
        }
    }

    private static void utRefreshAll() {
        Component[] componentArray;
        Desktop desktop = MatlabDesktopServices.getDesktop();
        for (Component component : componentArray = desktop.getGroupMembers("Array Editor")) {
            ArrayEditorManager.setSelection((DTClientBase)component, desktop.getShortTitle(component));
        }
    }

    public static void addArrayEditorListener() {
        SpreadsheetTableBrushManager.setTrackBrushingState((boolean)true);
        Desktop desktop = MatlabDesktopServices.getDesktop();
        Component[] componentArray = desktop.getGroupMembers("Array Editor");
        if (componentArray != null) {
            for (Component component : componentArray) {
                BrushManagerUpdater brushManagerUpdater = new BrushManagerUpdater(desktop.getShortTitle(component));
                brushManagerUpdater.start();
            }
        }
        desktop.addClientListener("Array Editor", (DTClientListener)new DTClientAdapter(){

            public void clientOpened(DTClientEvent dTClientEvent) {
                String string = MatlabDesktopServices.getDesktop().getShortTitle(dTClientEvent.getClient());
                BrushManagerUpdater brushManagerUpdater = new BrushManagerUpdater(string);
                PollingTimer pollingTimer = new PollingTimer(string, brushManagerUpdater, 10);
                pollingTimer.start();
            }

            public void clientClosing(DTClientEvent dTClientEvent) {
                String string = MatlabDesktopServices.getDesktop().getShortTitle(dTClientEvent.getClient());
                new Matlab().feval("datamanager.rmArrayEditorVariable", new Object[]{string}, 0, (MatlabListener)null);
            }
        });
    }

    public static void setSelection(String string) {
        DTClientBase dTClientBase = (DTClientBase)MatlabDesktopServices.getDesktop().getClient(string, "Array Editor");
        ArrayEditorManager.setSelection(dTClientBase, string);
    }

    public static void setSelection(DTClientBase dTClientBase, final String string) {
        final ArrayTable arrayTable = ArrayEditorManager.getArrayTable(dTClientBase);
        if (SwingUtilities.isEventDispatchThread()) {
            ArrayEditorManager.setSelection(arrayTable, string);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ArrayEditorManager.setSelection(arrayTable, string);
                }
            });
        }
    }

    private static void setSelection(ArrayTable arrayTable, String string) {
        if (arrayTable == null) {
            return;
        }
        CompositeColorArrayTableModel compositeColorArrayTableModel = arrayTable.getBorderColorArrayTableModel();
        if (compositeColorArrayTableModel == null) {
            return;
        }
        BrushTableModel brushTableModel = (BrushTableModel)arrayTable.getClientProperty((Object)"colormodel");
        if (brushTableModel == null) {
            brushTableModel = new BrushTableModel(string);
            BrushCellTableModel brushCellTableModel = new BrushCellTableModel(brushTableModel);
            arrayTable.putClientProperty((Object)"colormodel", (Object)brushTableModel);
            compositeColorArrayTableModel.addColorTableModel((ColorTableModel)brushTableModel);
            arrayTable.getCellColorArrayTableModel().addColorTableModel((ColorTableModel)brushCellTableModel);
        }
        brushTableModel.clearCache();
        brushTableModel.fireColorChangeListeners();
        arrayTable.repaint();
    }

    private static class PollingTimer
    extends Timer
    implements ActionListener {
        private int fCount = 0;
        private int fMaxCount = 1;
        private String fVarName;
        private MatlabWorker fCallback;

        private PollingTimer(String string, MatlabWorker matlabWorker, int n) {
            super(500, null);
            this.fMaxCount = n;
            this.fVarName = string;
            this.fCallback = matlabWorker;
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ++this.fCount;
            if (this.fCount >= this.fMaxCount) {
                this.stop();
                return;
            }
            if (ArrayEditorManager.getArrayTable(this.fVarName) != null) {
                this.fCallback.start();
                this.stop();
            }
        }
    }

    private static class BrushManagerUpdater
    extends MatlabWorker {
        private String fVarName;

        private BrushManagerUpdater(String string) {
            this.fVarName = string;
        }

        public void setVarName(String string) {
            this.fVarName = string;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            ArrayEditorManager.setSelection(this.fVarName);
        }

        public Object runOnMatlabThread() {
            try {
                Matlab.mtFeval((String)"datamanager.addArrayEditorVariable", (Object[])new Object[]{this.fVarName}, (int)0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }
    }
}

