/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.fixedpoint;

import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.toolbox.fixedpoint.FixedPointFunctionAbstractPanel;
import com.mathworks.toolbox.fixedpoint.FixedPointMenuAction;
import com.mathworks.toolbox.fixedpoint.TextWidget;
import com.mathworks.toolbox.fixedpoint.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

public class FimathPanel
extends FixedPointFunctionAbstractPanel {
    public static final String PRODUCT_MODE_COMBOBOX_NAME = "productModeComboBox";
    public static final String PRODUCT_WORD_LENGTH_FIELD = "productWordLengthField";
    public static final String PRODUCT_FRACTION_LENGTH_FIELD = "productFractionLengthField";
    public static final String SUM_MODE_COMBOBOX_NAME = "sumModeComboBox";
    public static final String SUM_WORD_LENGTH_FIELD = "sumWordLengthField";
    public static final String SUM_FRACTION_LENGTH_FIELD = "sumFractionLengthField";
    public static final String CAST_BEFORE_SUM_CHECKBOX = "castBeforeSumCheckBox";
    public static final RoundingMethod ROUNDING_ENUM_DEFAULT = RoundingMethod.NEAREST;
    public static final OverflowAction OVERFLOW_ENUM_DEFAULT = OverflowAction.SATURATE;
    public static final PrecisionMode PRECISION_ENUM_DEFAULT = PrecisionMode.FULL_PRECISION;
    public static final String WORD_LENGTH_DEFAULT = "32";
    public static final String FRACTION_LENGTH_DEFAULT = "30";
    public static final boolean CAST_BEFORE_SUM_DEFAULT = true;
    private MJComboBox fOverflowActionComboBox;
    private MJComboBox fProductModeComboBox;
    private MJComboBox fRoundingMethodComboBox;
    private MJComboBox fSumModeComboBox;
    private MJCheckBox fCastBeforeSumCheckBox;
    private TextWidget fProductFractionLengthTextField;
    private TextWidget fProductWordLengthTextField;
    private TextWidget fSumFractionLengthTextField;
    private TextWidget fSumWordLengthTextField;
    private MJLabel fProductFractionLengthLabel;
    private MJLabel fProductWordLengthLabel;
    private MJLabel fSumFractionLengthLabel;
    private MJLabel fSumWordLengthLabel;

    public FimathPanel() {
        this.initComponents();
    }

    @Override
    public String getFunctionName() {
        return "fimath";
    }

    @Override
    public Map<String, String> getParameterMap() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("RoundingMethod", Utilities.quoteSelection(this.fRoundingMethodComboBox));
        linkedHashMap.put("OverflowAction", Utilities.quoteSelection(this.fOverflowActionComboBox));
        linkedHashMap.put("ProductMode", Utilities.quoteSelection(this.fProductModeComboBox));
        if (!this.fProductModeComboBox.getSelectedItem().equals((Object)PrecisionMode.FULL_PRECISION)) {
            linkedHashMap.put("ProductWordLength", this.fProductWordLengthTextField.getText());
            if (this.fProductModeComboBox.getSelectedItem().equals((Object)PrecisionMode.SPECIFY_PRECISION)) {
                linkedHashMap.put("ProductFractionLength", this.fProductFractionLengthTextField.getText());
            }
        }
        linkedHashMap.put("SumMode", Utilities.quoteSelection(this.fSumModeComboBox));
        if (!this.fSumModeComboBox.getSelectedItem().equals((Object)PrecisionMode.FULL_PRECISION)) {
            linkedHashMap.put("SumWordLength", this.fSumWordLengthTextField.getText());
            if (this.fSumModeComboBox.getSelectedItem().equals((Object)PrecisionMode.SPECIFY_PRECISION)) {
                linkedHashMap.put("SumFractionLength", this.fSumFractionLengthTextField.getText());
            }
            linkedHashMap.put("CastBeforeSum", this.fCastBeforeSumCheckBox.isSelected() ? "true" : "false");
        }
        return linkedHashMap;
    }

    @Override
    public String getHelpFunction() {
        return "ref/fimath.html";
    }

    @Override
    protected void updateComponents() {
        this.updateProductMode();
        this.updateSumMode();
        this.updateCastBeforeSum();
    }

    private void updateProductMode() {
        FimathPanel.updatePrecisionComponents(this.fProductModeComboBox, this.fProductWordLengthLabel, this.fProductWordLengthTextField, this.fProductFractionLengthLabel, this.fProductFractionLengthTextField);
    }

    private void updateSumMode() {
        FimathPanel.updatePrecisionComponents(this.fSumModeComboBox, this.fSumWordLengthLabel, this.fSumWordLengthTextField, this.fSumFractionLengthLabel, this.fSumFractionLengthTextField);
    }

    private void updateCastBeforeSum() {
        boolean bl = !this.fSumModeComboBox.getSelectedItem().equals((Object)PrecisionMode.FULL_PRECISION);
        this.fCastBeforeSumCheckBox.setVisible(bl);
    }

    private static void updatePrecisionComponents(MJComboBox mJComboBox, MJLabel mJLabel, TextWidget textWidget, MJLabel mJLabel2, TextWidget textWidget2) {
        PrecisionMode precisionMode = (PrecisionMode)((Object)mJComboBox.getSelectedItem());
        boolean bl = precisionMode != PrecisionMode.FULL_PRECISION;
        mJLabel.setVisible(bl);
        textWidget.setVisible(bl);
        boolean bl2 = precisionMode == PrecisionMode.SPECIFY_PRECISION;
        mJLabel2.setVisible(bl2);
        textWidget2.setVisible(bl2);
    }

    private void initComponents() {
        MJLabel mJLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("RoundingMethodPromptStr"));
        this.fRoundingMethodComboBox = new MJComboBox(new DefaultComboBoxModel<RoundingMethod>(RoundingMethod.values()));
        this.fRoundingMethodComboBox.setSelectedItem((Object)ROUNDING_ENUM_DEFAULT);
        MJLabel mJLabel2 = new MJLabel(FixedPointMenuAction.BUNDLE.getString("OverflowActionPromptStr"));
        this.fOverflowActionComboBox = new MJComboBox(new DefaultComboBoxModel<OverflowAction>(OverflowAction.values()));
        this.fOverflowActionComboBox.setSelectedItem((Object)OVERFLOW_ENUM_DEFAULT);
        MJLabel mJLabel3 = new MJLabel(FixedPointMenuAction.BUNDLE.getString("ProductModePromptStr"));
        this.fProductModeComboBox = new MJComboBox(new DefaultComboBoxModel<PrecisionMode>(PrecisionMode.values()));
        this.fProductModeComboBox.setSelectedItem((Object)PRECISION_ENUM_DEFAULT);
        this.fProductModeComboBox.setName(PRODUCT_MODE_COMBOBOX_NAME);
        this.fProductWordLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("ProductWordLengthPromptStr"));
        this.fProductWordLengthTextField = new TextWidget(WORD_LENGTH_DEFAULT, PRODUCT_WORD_LENGTH_FIELD);
        this.fProductFractionLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("ProductFractionLengthPromptStr"));
        this.fProductFractionLengthTextField = new TextWidget(FRACTION_LENGTH_DEFAULT, PRODUCT_FRACTION_LENGTH_FIELD);
        MJLabel mJLabel4 = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SumModePromptStr"));
        this.fSumModeComboBox = new MJComboBox(new DefaultComboBoxModel<PrecisionMode>(PrecisionMode.values()));
        this.fSumModeComboBox.setName(SUM_MODE_COMBOBOX_NAME);
        this.fSumModeComboBox.setSelectedItem((Object)PRECISION_ENUM_DEFAULT);
        this.fSumWordLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SumWordLengthPromptStr"));
        this.fSumWordLengthTextField = new TextWidget(WORD_LENGTH_DEFAULT, SUM_WORD_LENGTH_FIELD);
        this.fSumFractionLengthLabel = new MJLabel(FixedPointMenuAction.BUNDLE.getString("SumFractionLengthPromptStr"));
        this.fSumFractionLengthTextField = new TextWidget(FRACTION_LENGTH_DEFAULT, SUM_FRACTION_LENGTH_FIELD);
        this.fCastBeforeSumCheckBox = new MJCheckBox(FixedPointMenuAction.BUNDLE.getString("CastBeforeSumPromptStr"));
        this.fCastBeforeSumCheckBox.setName(CAST_BEFORE_SUM_CHECKBOX);
        this.fCastBeforeSumCheckBox.setSelected(true);
        this.fProductModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FimathPanel.this.updatePanel();
            }
        });
        this.fSumModeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FimathPanel.this.updatePanel();
            }
        });
        this.addComponentPair((Component)mJLabel, (Component)this.fRoundingMethodComboBox);
        this.addComponentPair((Component)mJLabel2, (Component)this.fOverflowActionComboBox);
        this.addComponentPair((Component)mJLabel3, (Component)this.fProductModeComboBox);
        this.addComponentPair((Component)this.fProductWordLengthLabel, this.fProductWordLengthTextField.getComponent());
        this.addComponentPair((Component)this.fProductFractionLengthLabel, this.fProductFractionLengthTextField.getComponent());
        this.addComponentPair((Component)mJLabel4, (Component)this.fSumModeComboBox);
        this.addComponentPair((Component)this.fSumWordLengthLabel, this.fSumWordLengthTextField.getComponent());
        this.addComponentPair((Component)this.fSumFractionLengthLabel, this.fSumFractionLengthTextField.getComponent());
        this.addComponent((Component)this.fCastBeforeSumCheckBox);
    }

    public static enum PrecisionMode {
        FULL_PRECISION("FullPrecision"),
        KEEP_LSB("KeepLSB"),
        KEEP_MSB("KeepMSB"),
        SPECIFY_PRECISION("SpecifyPrecision");

        private String fName;

        public String toString() {
            return this.fName;
        }

        private PrecisionMode(String string2) {
            this.fName = string2;
        }
    }

    public static enum OverflowAction {
        SATURATE("Saturate"),
        WRAP("Wrap");

        private String fName;

        public String toString() {
            return this.fName;
        }

        private OverflowAction(String string2) {
            this.fName = string2;
        }
    }

    public static enum RoundingMethod {
        CEIL("Ceiling"),
        CONVERGENT("Convergent"),
        FLOOR("Floor"),
        NEAREST("Nearest"),
        ROUND("Round"),
        ZERO("Zero");

        private String fName;

        public String toString() {
            return this.fName;
        }

        private RoundingMethod(String string2) {
            this.fName = string2;
        }
    }
}

