/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.AbstractSortableTable;
import com.mathworks.mwswing.table.PresortedTableModel;
import com.mathworks.mwswing.table.RestrictedSortTableModel;
import com.mathworks.util.ArrayUtils;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DefaultSortableTable
extends AbstractSortableTable {
    private int fSortColumn = 0;
    private int fSortDirection = 0;

    public DefaultSortableTable() {
        this.setModel(new TableSorter());
    }

    public DefaultSortableTable(int n, int n2) {
        super(n, n2);
        this.setModel(new TableSorter(new DefaultTableModel(n, n2)));
    }

    public DefaultSortableTable(Object[][] objectArray, Object[] objectArray2) {
        super(objectArray, objectArray2);
        this.setModel(new TableSorter(new DefaultTableModel(objectArray, objectArray2)));
    }

    public DefaultSortableTable(TableModel tableModel) {
        super(tableModel);
        this.setModel(new TableSorter(tableModel));
    }

    public DefaultSortableTable(TableModel tableModel, TableColumnModel tableColumnModel) {
        super(tableModel, tableColumnModel);
        this.setModel(new TableSorter(tableModel));
    }

    public DefaultSortableTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        super(tableModel, tableColumnModel, listSelectionModel);
        this.setModel(new TableSorter(tableModel));
    }

    public DefaultSortableTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.setModel(new TableSorter(new DefaultTableModel(vector, vector2)));
    }

    @Override
    public int getSortColumn() {
        return this.fSortColumn;
    }

    @Override
    public int getSortDirection() {
        return this.fSortDirection;
    }

    @Override
    public void setModel(TableModel tableModel) {
        if (tableModel instanceof TableSorter) {
            super.setModel(tableModel);
        } else {
            super.setModel(new TableSorter(tableModel));
        }
    }

    @Override
    public void sortByColumn(int n, int n2) {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableSorter) {
            ((TableSorter)tableModel).sortByColumn(n, n2 == 0);
        }
        this.fSortColumn = n;
        this.fSortDirection = n2;
        this.fireSortingChangeEvent();
    }

    public void setColumnComparator(int n, Comparator<?> comparator) {
        ((TableSorter)this.getModel()).setColumnComparator(n, comparator);
    }

    public Comparator<?> getColumnComparator(int n) {
        return ((TableSorter)this.getModel()).getColumnComparator(n);
    }

    protected int convertRowIndexToUnderlyingModel(int n) {
        int[] nArray;
        int n2 = n;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof TableSorter && (nArray = ((TableSorter)tableModel).iIndexes).length > n) {
            n2 = nArray[n];
        }
        return n2;
    }

    private static class TableMap
    extends AbstractTableModel
    implements TableModelListener {
        protected TableModel iModel;

        private TableMap() {
        }

        public TableModel getModel() {
            return this.iModel;
        }

        public void setModel(TableModel tableModel) {
            this.iModel = tableModel;
            tableModel.addTableModelListener(this);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.iModel.getValueAt(n, n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.iModel.setValueAt(object, n, n2);
        }

        @Override
        public int getRowCount() {
            return this.iModel == null ? 0 : this.iModel.getRowCount();
        }

        @Override
        public int getColumnCount() {
            return this.iModel == null ? 0 : this.iModel.getColumnCount();
        }

        @Override
        public String getColumnName(int n) {
            return this.iModel.getColumnName(n);
        }

        public Class getColumnClass(int n) {
            return this.iModel.getColumnClass(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return this.iModel.isCellEditable(n, n2);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.fireTableChanged(tableModelEvent);
        }
    }

    private static class TableSorter
    extends TableMap
    implements RestrictedSortTableModel {
        private int[] iIndexes;
        private Vector<Integer> iSortingColumns = new Vector();
        private boolean iIsAscending = true;
        private int fPresortColumn = -1;
        private int fPresortDirection = 0;
        private int[] fUnsortableColumns = ArrayUtils.EmptyPrimitives.INT;
        private Comparator[] fComparators;

        TableSorter() {
            this.iIndexes = ArrayUtils.EmptyPrimitives.INT;
            this.fComparators = new Comparator[0];
        }

        TableSorter(TableModel tableModel) {
            this.setModel(tableModel);
        }

        @Override
        public void setModel(TableModel tableModel) {
            super.setModel(tableModel);
            if (tableModel instanceof PresortedTableModel) {
                PresortedTableModel presortedTableModel = (PresortedTableModel)tableModel;
                this.fPresortColumn = presortedTableModel.getPresortedColumn();
                this.fPresortDirection = presortedTableModel.getPresortedDirection();
            }
            if (tableModel instanceof RestrictedSortTableModel) {
                this.fUnsortableColumns = ((RestrictedSortTableModel)tableModel).getUnsortableColumns();
            }
            this.fComparators = new Comparator[tableModel.getColumnCount()];
            this.reallocateIndexes();
        }

        @Override
        public int[] getUnsortableColumns() {
            return this.fUnsortableColumns;
        }

        public void setColumnComparator(int n, Comparator<?> comparator) {
            this.fComparators[n] = comparator;
        }

        public Comparator<?> getColumnComparator(int n) {
            return this.fComparators[n];
        }

        public int compareRowsByColumn(int n, int n2, int n3) {
            Object object;
            String string;
            if (n3 != -1 && n3 == this.fPresortColumn) {
                if (n == n2) {
                    return 0;
                }
                if (n < n2) {
                    return this.fPresortDirection == 0 ? -1 : 1;
                }
                return this.fPresortDirection == 0 ? 1 : -1;
            }
            TableModel tableModel = this.iModel;
            Object object2 = tableModel.getValueAt(n, n3);
            Object object3 = tableModel.getValueAt(n2, n3);
            if (object2 == null && object3 == null) {
                return 0;
            }
            if (object2 == null) {
                return -1;
            }
            if (object3 == null) {
                return 1;
            }
            if (this.fComparators[n3] != null) {
                return this.fComparators[n3].compare(object2, object3);
            }
            if (Comparable.class.isAssignableFrom(this.iModel.getColumnClass(n3))) {
                return ((Comparable)tableModel.getValueAt(n, n3)).compareTo(tableModel.getValueAt(n2, n3));
            }
            Object object4 = tableModel.getValueAt(n, n3);
            String string2 = object4.toString();
            int n4 = string2.compareTo(string = (object = tableModel.getValueAt(n2, n3)).toString());
            if (n4 < 0) {
                return -1;
            }
            if (n4 > 0) {
                return 1;
            }
            return 0;
        }

        public int compare(int n, int n2) {
            for (int i = 0; i < this.iSortingColumns.size(); ++i) {
                Integer n3 = this.iSortingColumns.elementAt(i);
                int n4 = this.compareRowsByColumn(n, n2, n3);
                if (n4 == 0) continue;
                return this.iIsAscending ? n4 : -n4;
            }
            return 0;
        }

        public void reallocateIndexes() {
            int n = this.iModel.getRowCount();
            this.iIndexes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.iIndexes[i] = i;
            }
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            this.reallocateIndexes();
            if (!this.iSortingColumns.isEmpty()) {
                this.sortByColumn(this.iSortingColumns.elementAt(0), this.iIsAscending);
            }
            super.tableChanged(tableModelEvent);
        }

        public void checkModel() {
            if (this.iIndexes.length != this.iModel.getRowCount()) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    System.err.println("Sorter not informed of a change to the model.");
                    Thread.dumpStack();
                }
                this.sort();
            }
        }

        public void sort() {
            this.reallocateIndexes();
            this.shuttlesort((int[])this.iIndexes.clone(), this.iIndexes, 0, this.iIndexes.length);
        }

        public void shuttlesort(int[] nArray, int[] nArray2, int n, int n2) {
            if (n2 - n < 2) {
                return;
            }
            int n3 = (n + n2) / 2;
            this.shuttlesort(nArray2, nArray, n, n3);
            this.shuttlesort(nArray2, nArray, n3, n2);
            int n4 = n;
            int n5 = n3;
            if (n2 - n >= 4 && this.compare(nArray[n3 - 1], nArray[n3]) <= 0) {
                System.arraycopy(nArray, n, nArray2, n, n2 - n);
                return;
            }
            for (int i = n; i < n2; ++i) {
                nArray2[i] = n5 >= n2 || n4 < n3 && this.compare(nArray[n4], nArray[n5]) <= 0 ? nArray[n4++] : nArray[n5++];
            }
        }

        public void swap(int n, int n2) {
            int n3 = this.iIndexes[n];
            this.iIndexes[n] = this.iIndexes[n2];
            this.iIndexes[n2] = n3;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            this.checkModel();
            return this.iModel.getValueAt(this.iIndexes[n], n2);
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.checkModel();
            this.iModel.setValueAt(object, this.iIndexes[n], n2);
        }

        public void sortByColumn(int n, boolean bl) {
            this.iIsAscending = bl;
            this.iSortingColumns.removeAllElements();
            this.iSortingColumns.addElement(n);
            this.sort();
            super.tableChanged(new TableModelEvent(this));
        }
    }
}

