/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.logger.Log;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.Method;

public class GraphicsUtils {
    private static final Log LOG = Log.getInstance((String)"com.mathworks.mwswing.GraphicsUtils");

    private GraphicsUtils() {
    }

    public static RenderingHints getAntialiasingRenderingHints() {
        return (RenderingHints)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
    }

    public static boolean setWindowShape(Window window, Shape shape) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowShape", Window.class, Shape.class);
            method.invoke(null, window, shape);
            return true;
        }
        catch (Exception exception) {
            LOG.debug((Throwable)exception);
            return false;
        }
    }

    public static boolean setWindowOpaque(Window window, boolean bl) {
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("setWindowOpaque", Window.class, Boolean.TYPE);
            method.invoke(null, window, bl);
            return true;
        }
        catch (Exception exception) {
            LOG.debug((Throwable)exception);
            return false;
        }
    }

    public static boolean isTranslucencySupported() {
        if (PlatformInfo.getVersion() < 7) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Method method = clazz.getMethod("isTranslucencyCapable", GraphicsConfiguration.class);
            return (Boolean)method.invoke(null, MJUtilities.getGraphicsConfiguration());
        }
        catch (Exception exception) {
            LOG.debug((Throwable)exception);
            return false;
        }
    }

    public static boolean isTransparencySupported() {
        if (PlatformInfo.getVersion() < 7) {
            return false;
        }
        try {
            Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
            Class<?> clazz2 = Class.forName("com.sun.awt.AWTUtilities$Translucency");
            Object obj = Enum.valueOf(clazz2, "PERPIXEL_TRANSPARENT");
            Method method = clazz.getMethod("isTranslucencySupported", clazz2);
            return (Boolean)method.invoke(null, obj);
        }
        catch (Exception exception) {
            LOG.debug((Throwable)exception);
            return false;
        }
    }
}

