/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing;

import com.mathworks.mwswing.BareSwingDetector;
import com.mathworks.mwswing.FileExtensionFilter;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.RestrictedFileSystemView;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.sun.java.swing.plaf.windows.WindowsFileChooserUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class MJFileChooser
extends JFileChooser {
    private boolean fShowOverwriteDialog = false;
    private ApproveListener fApproveListener = null;
    private static final String sMacUIClassName;
    private static boolean sUseAWTDialog;
    private boolean fIncludeFilterExtension = false;
    private FilterChangedListener fPropChangeListener;

    public MJFileChooser() {
    }

    public MJFileChooser(File file) {
        super(file);
    }

    public MJFileChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
    }

    public MJFileChooser(FileSystemView fileSystemView) {
        super(fileSystemView);
    }

    public MJFileChooser(String string) {
        super(string);
    }

    public MJFileChooser(String string, FileSystemView fileSystemView) {
        super(string, fileSystemView);
    }

    public void setIncludeFilterExtension(boolean bl) {
        this.fIncludeFilterExtension = bl;
    }

    private String getFileName() {
        String string = "";
        if (PlatformInfo.isMacintosh()) {
            try {
                Class<?> clazz = Class.forName(sMacUIClassName);
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.getName().equals("getFileName")) continue;
                    string = (String)method.invoke((Object)this.getUI(), new Object[0]);
                }
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        } else {
            string = ((BasicFileChooserUI)this.getUI()).getFileName();
        }
        return string;
    }

    private void setFileName(String string) {
        if (PlatformInfo.isMacintosh()) {
            try {
                Class<?> clazz = Class.forName(sMacUIClassName);
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.getName().equals("setFileName")) continue;
                    method.invoke((Object)this.getUI(), string);
                }
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        } else {
            ((BasicFileChooserUI)this.getUI()).setFileName(string);
        }
    }

    private String getCurrentFilterExtension() {
        MJFileChooserPerPlatform.PatternBasedFilter patternBasedFilter;
        FileExtensionFilter fileExtensionFilter = null;
        if (this.getFileFilter() instanceof FileExtensionFilter) {
            fileExtensionFilter = (FileExtensionFilter)this.getFileFilter();
        } else if (this.getFileFilter() instanceof MJFileChooserPerPlatform.PatternBasedFilter && (patternBasedFilter = (MJFileChooserPerPlatform.PatternBasedFilter)this.getFileFilter()).getOriginalFilter() instanceof FileExtensionFilter) {
            fileExtensionFilter = (FileExtensionFilter)patternBasedFilter.getOriginalFilter();
        }
        return fileExtensionFilter == null ? "" : fileExtensionFilter.getSimpleFilterExtension();
    }

    private boolean doesFileCombinedWithFilterExist(String string, boolean bl) {
        if (this.fIncludeFilterExtension && string.indexOf(".") == -1) {
            string = string + this.getCurrentFilterExtension();
            bl = FileUtils.fileExists((String)string);
        }
        return bl;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.fIncludeFilterExtension) {
            this.fPropChangeListener = new FilterChangedListener();
            this.addPropertyChangeListener(this.fPropChangeListener);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.fPropChangeListener != null) {
            this.removePropertyChangeListener(this.fPropChangeListener);
        }
    }

    @Override
    public void updateUI() {
        BareSwingDetector.exempt();
        super.updateUI();
        BareSwingDetector.reinstate();
    }

    public static void setUseAWTFileDialog(boolean bl) {
        sUseAWTDialog = bl;
    }

    @Override
    public int showDialog(Component component, String string) throws HeadlessException {
        if (!sUseAWTDialog) {
            return super.showDialog(component, string);
        }
        if (component == null || MJFrame.getFrame(component) == null) {
            component = new MJFrame();
        }
        FileDialog fileDialog = new FileDialog((Frame)MJFrame.getFrame(component), this.getUI().getDialogTitle(this), this.getDialogType() == 1 ? 1 : 0);
        fileDialog.setModal(true);
        if (this.getCurrentDirectory() != null) {
            fileDialog.setDirectory(this.getCurrentDirectory().getAbsolutePath());
        }
        if (this.getSelectedFile() != null) {
            fileDialog.setFile(this.getSelectedFile().getName());
        }
        fileDialog.show();
        if (fileDialog.getFile() != null && fileDialog.getDirectory() != null) {
            this.setCurrentDirectory(new File(fileDialog.getDirectory()));
            this.setSelectedFile(new File(fileDialog.getDirectory(), fileDialog.getFile()));
            return 0;
        }
        return 1;
    }

    @Override
    protected JDialog createDialog(Component component) throws HeadlessException {
        boolean bl;
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, component);
        String string = this.getUI().getDialogTitle(this);
        this.getAccessibleContext().setAccessibleDescription(string);
        MJDialog mJDialog = new MJDialog(frame, string, true);
        Container container = mJDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this, "Center");
        if (JDialog.isDefaultLookAndFeelDecorated() && (bl = UIManager.getLookAndFeel().getSupportsWindowDecorations())) {
            mJDialog.getRootPane().setWindowDecorationStyle(6);
        }
        mJDialog.pack();
        ((Window)mJDialog).setLocationRelativeTo(component);
        return mJDialog;
    }

    public void setShowOverwriteDialog(boolean bl) {
        this.fShowOverwriteDialog = bl;
    }

    public void setApproveListener(ApproveListener approveListener) {
        this.fApproveListener = approveListener;
    }

    @Override
    public void approveSelection() {
        String string;
        File file;
        if (!(this.isMultiSelectionEnabled() && this.getSelectedFiles().length != 1 || (file = this.getSelectedFile()) == null)) {
            string = file.getName();
            if (string.length() >= 2 && string.indexOf("\"") == 0 && string.indexOf("\"", 1) == string.length() - 1) {
                string = string.substring(1, string.length() - 1);
            }
            this.setSelectedFile(new File(file.getParent(), string));
        }
        if (this.fApproveListener != null && !this.fApproveListener.approveSelection()) {
            return;
        }
        if (this.fShowOverwriteDialog && (file = this.getSelectedFile()) != null) {
            string = file.getAbsolutePath();
            boolean bl = file.exists();
            if (bl = this.doesFileCombinedWithFilterExist(string, bl)) {
                String string2 = this.getDialogTitle();
                Object[] objectArray = new Object[]{string};
                String string3 = MessageFormat.format(MJUtilities.intlString("mjfilechooser.overwriteFile"), objectArray);
                int n = MJOptionPane.showOptionDialog(this, string3, string2, 0, 2, null, new Object[]{MJOptionPane.YES_STRING, MJOptionPane.NO_STRING}, MJOptionPane.NO_STRING);
                if (n != 0) {
                    return;
                }
            }
        }
        super.approveSelection();
    }

    static {
        if (PlatformInfo.isWindows()) {
            UIManager.put("FileChooserUI", FixedWindowsFileChooserUI.class.getName());
        }
        sMacUIClassName = new MJFileChooser().getUI().getClass().getCanonicalName();
        sUseAWTDialog = false;
    }

    public static interface ApproveListener {
        public boolean approveSelection();
    }

    public static class FixedWindowsFileChooserUI
    extends WindowsFileChooserUI {
        public static ComponentUI createUI(JComponent jComponent) {
            return new FixedWindowsFileChooserUI((JFileChooser)jComponent);
        }

        FixedWindowsFileChooserUI(JFileChooser jFileChooser) {
            super(jFileChooser);
        }

        public void installComponents(JFileChooser jFileChooser) {
            try {
                super.installComponents(jFileChooser);
            }
            catch (Exception exception) {
                jFileChooser.setFileSystemView(new RestrictedFileSystemView());
                super.installComponents(jFileChooser);
            }
        }
    }

    private class FilterChangedListener
    implements PropertyChangeListener {
        private FilterChangedListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("fileFilterChanged")) {
                this.updateSelectedFileName();
            }
        }

        private void updateSelectedFileName() {
            String string = MJFileChooser.this.getFileName();
            assert (string != null) : "expected at least an empty string";
            if (string.indexOf("?") != -1 || string.indexOf("*") != -1 || string.indexOf(".") == 0) {
                return;
            }
            String string2 = string.indexOf(".") == -1 ? string : string.substring(0, string.lastIndexOf("."));
            String string3 = string2 + MJFileChooser.this.getCurrentFilterExtension();
            MJFileChooser.this.setFileName(string3);
        }
    }
}

