/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistry;
import com.mathworks.mwswing.binding.KeyBindingReaderUtils;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.ReadWriteException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;

public final class ActionDataReader {
    private final List<ActionData> fActions = new LinkedList<ActionData>();
    private static final String ACTIONS_TAG = "Actions";
    private static final String ICON_TAG = "Icon";
    private static final String ALT_ID_TAG = "AltID";
    private static final String HIDDEN_ATTRIBUTE = "hidden";
    private static final String ICON_PACKAGE_ATTRIBUTE = "package";
    private static final String CATEGORY_RES = "Category";
    private static final String DESCRIPTION_RES = "Description";
    private static final String TOOLTIP_RES = "Tooltip";
    private static final String PREF_PANEL_NAME_RES = "PreferenceLabel";
    private final ResourceBundle fResBundle;

    public ActionDataReader(InputStream inputStream, KeyBindingManagerRegistry keyBindingManagerRegistry) throws ReadWriteException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        if (keyBindingManagerRegistry == null) {
            throw new IllegalArgumentException("KeyBindingManagerRegistry cannot be null");
        }
        SimpleElement simpleElement = KeyBindingReaderUtils.getTopElement(inputStream, ACTIONS_TAG);
        this.fResBundle = KeyBindingReaderUtils.getResourceBundle(simpleElement);
        SimpleNodeList simpleNodeList = simpleElement.getElementsByTagName("Action");
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            this.fActions.add(this.createAction((SimpleElement)simpleNodeList.item(i), keyBindingManagerRegistry));
        }
    }

    private ActionData createAction(SimpleElement simpleElement, KeyBindingManagerRegistry keyBindingManagerRegistry) throws ReadWriteException {
        String string = simpleElement.getAttribute("id");
        String[] stringArray = KeyBindingReaderUtils.getNodeValue(simpleElement, ICON_TAG, ICON_PACKAGE_ATTRIBUTE);
        String string2 = stringArray != null ? stringArray[0] : null;
        String string3 = stringArray != null ? stringArray[1] : null;
        String string4 = simpleElement.getAttribute(HIDDEN_ATTRIBUTE);
        boolean bl = string4 == null ? false : Boolean.valueOf(string4);
        ActionData actionData = new ActionData(string, this.getFromRes(string, "Label", true), this.getFromRes(string, CATEGORY_RES, true), this.getFromRes(string, DESCRIPTION_RES, true), this.getFromRes(string, TOOLTIP_RES, false), string2, string3, this.getFromRes(string, PREF_PANEL_NAME_RES, false), bl);
        SimpleNodeList simpleNodeList = simpleElement.getChildNodes();
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            String string5;
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            if (simpleElement2 != null && simpleElement2.getNodeName().equals("KeySet")) {
                string5 = simpleElement2.getAttribute("id");
                List<KeyStrokeList> list = KeyBindingReaderUtils.createKeyBindings(simpleElement2, true);
                if (list.isEmpty() && !string5.equals("Unspecified")) {
                    actionData.setNoBindingsForDefaultSet(keyBindingManagerRegistry.getDefaultKeyBindingSet(string5));
                    continue;
                }
                for (KeyStrokeList keyStrokeList : list) {
                    if (string5.equals("Unspecified")) {
                        actionData.addUnspecifiedBinding(keyStrokeList);
                        continue;
                    }
                    actionData.addDefaultSetBinding(keyBindingManagerRegistry.getDefaultKeyBindingSet(string5), keyStrokeList);
                }
                continue;
            }
            if (simpleElement2 == null || !simpleElement2.getNodeName().equals(ALT_ID_TAG)) continue;
            string5 = simpleElement2.getAttribute("id");
            actionData.addAlternateID(string5);
        }
        actionData.initializationFinished();
        return actionData;
    }

    public Collection<ActionData> getActions() {
        return Collections.unmodifiableList(this.fActions);
    }

    private String getFromRes(String string, String string2, boolean bl) throws ReadWriteException {
        return KeyBindingReaderUtils.getFromRes(this.fResBundle, "Action", string, string2, bl);
    }
}

