/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.binding;

import com.mathworks.mwswing.SimpleElement;
import com.mathworks.mwswing.SimpleNodeList;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.Context;
import com.mathworks.mwswing.binding.ContextActionData;
import com.mathworks.mwswing.binding.KeyBindingManagerRegistry;
import com.mathworks.mwswing.binding.KeyBindingReaderUtils;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.ReadWriteException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ContextReader {
    private final Context fContext;
    private static final String TAG_ATTRIBUTE = "tag";
    private final SimpleElement fTopElement;
    private final KeyBindingManagerRegistry fRegistry;

    public ContextReader(InputStream inputStream, KeyBindingManagerRegistry keyBindingManagerRegistry) throws ReadWriteException {
        if (inputStream == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        if (keyBindingManagerRegistry == null) {
            throw new IllegalArgumentException("KeyBindingManagerRegistry cannot be null");
        }
        this.fTopElement = KeyBindingReaderUtils.getTopElement(inputStream, "Context");
        this.fRegistry = keyBindingManagerRegistry;
        String string = this.fTopElement.getAttribute("id");
        SimpleNodeList simpleNodeList = this.fTopElement.getElementsByTagName("Action");
        LinkedList<ContextActionData> linkedList = new LinkedList<ContextActionData>();
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            linkedList.add(this.createContextAction((SimpleElement)simpleNodeList.item(i), string));
        }
        this.fContext = new Context(string, KeyBindingReaderUtils.getFromRes(KeyBindingReaderUtils.getResourceBundle(this.fTopElement), "Context", string, "Label"), linkedList);
    }

    public Collection<String> getActionsWithTag(String string) {
        SimpleNodeList simpleNodeList = this.fTopElement.getElementsByTagName("Action");
        LinkedList<String> linkedList = new LinkedList<String>();
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            ContextReader.addIfTagMatches(string, (SimpleElement)simpleNodeList.item(i), linkedList);
        }
        return Collections.unmodifiableList(linkedList);
    }

    private static void addIfTagMatches(String string, SimpleElement simpleElement, Collection<String> collection) {
        String string2 = simpleElement.getAttribute(TAG_ATTRIBUTE);
        if (string2 != null && string2.equals(string)) {
            String string3 = simpleElement.getAttribute("id");
            collection.add(string3);
        }
    }

    private ContextActionData createContextAction(SimpleElement simpleElement, String string) {
        String string2 = simpleElement.getAttribute("id");
        this.verifyActionExists(string, string2);
        ActionData actionData = this.fRegistry.getActionData(string2);
        ContextActionData contextActionData = new ContextActionData(actionData);
        this.addFollowsInfo(simpleElement, contextActionData, string);
        this.addCustomBindings(simpleElement, contextActionData);
        contextActionData.initializationFinished();
        return contextActionData;
    }

    private void addFollowsInfo(SimpleElement simpleElement, ContextActionData contextActionData, String string) {
        String string2 = simpleElement.getAttribute("follows");
        if (string2 == null) {
            SimpleNodeList simpleNodeList = simpleElement.getChildNodes();
            for (int i = 0; i < simpleNodeList.getLength(); ++i) {
                SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
                if (simpleElement2 == null || !simpleElement2.getNodeName().equals("KeySet")) continue;
                String string3 = simpleElement2.getAttribute("id");
                if (string3.equals("Unspecified")) {
                    string2 = simpleElement2.getAttribute("follows");
                    continue;
                }
                String string4 = simpleElement2.getAttribute("follows");
                if (string4 == null) continue;
                this.verifyContextSupportsAction(string, string4, contextActionData.getAction());
                contextActionData.setFollowsContext(this.fRegistry.getDefaultKeyBindingSet(string3), this.fRegistry.getContext(string4));
            }
        }
        if (string2 != null) {
            this.verifyContextSupportsAction(string, string2, contextActionData.getAction());
            contextActionData.setUnspecifiedFollowsContext(this.fRegistry.getContext(string2));
        }
    }

    private void verifyActionExists(String string, String string2) {
        if (!this.fRegistry.containsAction(string2)) {
            throw new IllegalStateException("Context '" + string + "' is referencing action '" + string2 + "', which is not registered with the keybinding manager.");
        }
    }

    private void verifyContextSupportsAction(String string, String string2, ActionData actionData) {
        if (!this.fRegistry.containsContext(string2)) {
            throw new IllegalStateException("Context '" + string + "' is attempting to follow context '" + string2 + "', which is not registered with the keybinding manager.");
        }
        if (this.fRegistry.getContext(string2).supportsActions() && !this.fRegistry.getContext(string2).isSupportedAction(actionData)) {
            throw new IllegalStateException("Context '" + string + "' is attempting to follow context '" + string2 + "' for action '" + actionData.getName() + "', but '" + string2 + "' does not support that action.");
        }
    }

    private void addCustomBindings(SimpleElement simpleElement, ContextActionData contextActionData) {
        SimpleNodeList simpleNodeList = simpleElement.getChildNodes();
        for (int i = 0; i < simpleNodeList.getLength(); ++i) {
            SimpleElement simpleElement2 = (SimpleElement)simpleNodeList.item(i);
            if (simpleElement2 == null || !simpleElement2.getNodeName().equals("KeySet")) continue;
            String string = simpleElement2.getAttribute("id");
            List<KeyStrokeList> list = KeyBindingReaderUtils.createKeyBindings(simpleElement2);
            if (list == null) continue;
            if (string.equals("Unspecified")) {
                for (KeyStrokeList keyStrokeList : list) {
                    contextActionData.addUnspecifiedBindings(keyStrokeList);
                }
                continue;
            }
            for (KeyStrokeList keyStrokeList : list) {
                contextActionData.addKeyBinding(this.fRegistry.getDefaultKeyBindingSet(string), keyStrokeList);
            }
        }
    }

    public Context getContext() {
        return this.fContext;
    }
}

