/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.dialog;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class MJGotoDialog
extends MJDialog
implements ActionListener {
    public static final int NO_LINE = -1;
    private int fLineNumber = 1;
    private JTextField fText;
    private Frame fFrame;
    private int fWidth;

    public MJGotoDialog(Frame frame) {
        this(frame, 1, null);
    }

    public MJGotoDialog(Frame frame, int n) {
        this(frame, n, null);
    }

    public MJGotoDialog(Frame frame, int n, Component component) {
        super(frame, MJUtilities.intlString("labelGoto"), true);
        this.fFrame = frame;
        this.fLineNumber = n;
        MJPanel mJPanel = new MJPanel();
        mJPanel.setOpaque(false);
        ((JComponent)mJPanel).setBorder(BorderFactory.createEmptyBorder(7, 3, 3, 3));
        mJPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        MJLabel mJLabel = new MJLabel(MJUtilities.intlString("labelLineNumber"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mJPanel.add((Component)mJLabel, gridBagConstraints);
        this.fText = new MJTextField(new PositiveNumberDocument(), String.valueOf(this.fLineNumber), 10);
        this.fText.selectAll();
        this.fText.addActionListener(this);
        this.fText.getAccessibleContext().setAccessibleName(MJUtilities.intlString("goto.text.acc"));
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        mJPanel.add((Component)this.fText, gridBagConstraints);
        MJButton mJButton = new MJButton(MJUtilities.intlString("labelOK"));
        mJButton.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        mJPanel.add((Component)mJButton, gridBagConstraints);
        MJButton mJButton2 = new MJButton(MJUtilities.intlString("labelCancel"));
        mJButton2.addActionListener(this);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        mJPanel.add((Component)mJButton2, gridBagConstraints);
        this.setFocusTarget(this.fText);
        this.catchPrematureKeyEvents(component);
        this.getRootPane().setDefaultButton(mJButton);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)mJPanel, "Center");
        this.pack();
        Rectangle rectangle = frame.getBounds();
        rectangle.x += rectangle.width / 2 - this.getSize().width / 2;
        rectangle.y += rectangle.height / 3 - this.getSize().height / 2;
        this.setLocation(rectangle.x, rectangle.y);
        this.setResizable(false);
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            String string = this.fText.getText();
            try {
                this.fLineNumber = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                MJOptionPane.showMessageDialog(this.fFrame, MJUtilities.intlString("labelError1"), MJUtilities.intlString("labelEditor"), 2);
                return;
            }
            this.setVisible(false);
        } else {
            String string = actionEvent.getActionCommand();
            if (string.equals(MJUtilities.intlString("labelOK"))) {
                String string2 = this.fText.getText();
                try {
                    this.fLineNumber = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    MJOptionPane.showMessageDialog(this.fFrame, MJUtilities.intlString("labelError1"), MJUtilities.intlString("labelEditor"), 2);
                    return;
                }
                this.setVisible(false);
            } else if (string.equals(MJUtilities.intlString("labelCancel"))) {
                this.fLineNumber = -1;
                this.setVisible(false);
            }
        }
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("MATLAB Editor");
        frame.setVisible(true);
        frame.setBounds(500, 500, 500, 500);
        new MJGotoDialog(frame);
    }

    class PositiveNumberDocument
    extends PlainDocument {
        PositiveNumberDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            for (int i = 0; i < string.length(); ++i) {
                if (Character.isDigit(string.charAt(i))) continue;
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

