/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwswing.text;

import java.io.IOException;
import java.io.Reader;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Segment;

public class DocumentReader
extends Reader {
    private Document fDocument;
    private int fPosition = 0;
    private int fMarkPos = 0;
    private boolean fIsClosed = false;
    private Segment fSegment = new Segment();

    public DocumentReader() {
    }

    public DocumentReader(Document document) {
        this.fDocument = document;
    }

    public void setDocument(Document document) {
        this.fDocument = document;
        this.fPosition = 0;
        this.fMarkPos = 0;
        this.fIsClosed = false;
    }

    public void setPosition(int n) {
        this.fPosition = n;
    }

    public int getPosition() {
        return this.fPosition;
    }

    @Override
    public int read() throws IOException {
        this.checkIfClosed();
        if (this.fPosition >= this.fDocument.getLength()) {
            return -1;
        }
        try {
            this.fDocument.getText(this.fPosition, 1, this.fSegment);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException();
        }
        ++this.fPosition;
        return this.fSegment.array[this.fSegment.offset];
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        this.checkIfClosed();
        int n3 = this.fDocument.getLength();
        if (this.fPosition >= n3) {
            return -1;
        }
        if (this.fPosition + n2 > n3) {
            n2 = n3 - this.fPosition;
        }
        try {
            this.fDocument.getText(this.fPosition, n2, this.fSegment);
            System.arraycopy(this.fSegment.array, this.fSegment.offset, cArray, n, n2);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException();
        }
        this.fPosition += n2;
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        this.checkIfClosed();
        this.fPosition = (int)((long)this.fPosition + l);
        int n = this.fDocument.getLength();
        if (this.fPosition > n) {
            l -= (long)(this.fPosition - n);
            this.fPosition = n;
        }
        return l;
    }

    @Override
    public boolean ready() throws IOException {
        return !this.fIsClosed;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) throws IOException {
        this.checkIfClosed();
        this.fMarkPos = this.fPosition;
    }

    @Override
    public void reset() throws IOException {
        this.checkIfClosed();
        this.fPosition = this.fMarkPos;
        this.fMarkPos = 0;
    }

    @Override
    public void close() throws IOException {
        this.fIsClosed = true;
    }

    private void checkIfClosed() throws IOException {
        if (this.fIsClosed) {
            throw new IOException("using reader after close");
        }
    }
}

