/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.collection.WeakIdentityMap;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Map;
import java.util.WeakHashMap;
import net.jini.security.SecurityContext;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.PolicyInitializationException;
import net.jini.security.policy.SecurityContextSource;

public class AggregatePolicyProvider
extends Policy
implements DynamicPolicy,
SecurityContextSource {
    private static final String mainPolicyClassProperty = "com.sun.jini.start.AggregatePolicyProvider.mainPolicyClass";
    private static final String defaultMainPolicyClass = "net.jini.security.policy.DynamicPolicyProvider";
    private static final Map trustGetCCL;
    private static final ProtectionDomain myDomain;
    private WeakIdentityMap subPolicies = new WeakIdentityMap();
    private WeakIdentityMap subPolicyCache = new WeakIdentityMap();
    private Policy mainPolicy;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AggregatePolicyProvider() throws PolicyInitializationException {
        String string = Security.getProperty(mainPolicyClassProperty);
        if (string == null) {
            string = defaultMainPolicyClass;
        }
        try {
            this.mainPolicy = (Policy)Class.forName(string).newInstance();
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            throw new PolicyInitializationException("unable to construct main policy", exception);
        }
        this.ensureDependenciesResolved();
    }

    public AggregatePolicyProvider(Policy policy) {
        if (policy == null) {
            throw new NullPointerException();
        }
        this.mainPolicy = policy;
        this.ensureDependenciesResolved();
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.getCurrentSubPolicy().getPermissions(codeSource);
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        if (protectionDomain == myDomain) {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new AllPermission());
            return permissions;
        }
        return this.getCurrentSubPolicy().getPermissions(protectionDomain);
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        return protectionDomain == myDomain || this.getCurrentSubPolicy().implies(protectionDomain, permission);
    }

    public void refresh() {
        this.getCurrentSubPolicy().refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolicy(ClassLoader classLoader, Policy policy) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        WeakIdentityMap weakIdentityMap = this.subPolicies;
        synchronized (weakIdentityMap) {
            this.subPolicyCache.clear();
            if (classLoader != null) {
                if (policy != null) {
                    this.subPolicies.put(classLoader, policy);
                    this.subPolicyCache.put(classLoader, policy);
                } else {
                    this.subPolicies.remove(classLoader);
                }
            } else {
                if (policy == null) {
                    throw new NullPointerException();
                }
                this.mainPolicy = policy;
            }
        }
    }

    public boolean grantSupported() {
        Policy policy = this.getCurrentSubPolicy();
        return policy instanceof DynamicPolicy && ((DynamicPolicy)((Object)policy)).grantSupported();
    }

    public void grant(Class clazz, Principal[] principalArray, Permission[] permissionArray) {
        Policy policy = this.getCurrentSubPolicy();
        if (!(policy instanceof DynamicPolicy)) {
            throw new UnsupportedOperationException("grants not supported");
        }
        ((DynamicPolicy)((Object)policy)).grant(clazz, principalArray, permissionArray);
    }

    public Permission[] getGrants(Class clazz, Principal[] principalArray) {
        Policy policy = this.getCurrentSubPolicy();
        if (policy instanceof DynamicPolicy) {
            return ((DynamicPolicy)((Object)policy)).getGrants(clazz, principalArray);
        }
        throw new UnsupportedOperationException("grants not supported");
    }

    public SecurityContext getContext() {
        Policy policy = this.getCurrentSubPolicy();
        SecurityContext securityContext = policy instanceof SecurityContextSource ? ((SecurityContextSource)((Object)policy)).getContext() : new DefaultSecurityContext();
        return new AggregateSecurityContext(securityContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureDependenciesResolved() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        AggregatePolicyProvider.trustGetContextClassLoader0(Thread.class);
        AggregatePolicyProvider.getContextClassLoader();
        WeakIdentityMap weakIdentityMap = this.subPolicies;
        synchronized (weakIdentityMap) {
            this.lookupSubPolicy(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Policy getCurrentSubPolicy() {
        Thread thread = Thread.currentThread();
        if (!AggregatePolicyProvider.trustGetContextClassLoader(thread)) {
            return this.mainPolicy;
        }
        ClassLoader classLoader = AggregatePolicyProvider.getContextClassLoader();
        WeakIdentityMap weakIdentityMap = this.subPolicies;
        synchronized (weakIdentityMap) {
            Policy policy = (Policy)this.subPolicyCache.get(classLoader);
            if (policy == null) {
                policy = this.lookupSubPolicy(classLoader);
                this.subPolicyCache.put(classLoader, policy);
            }
            return policy;
        }
    }

    private Policy lookupSubPolicy(final ClassLoader classLoader) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.subPolicies)) {
            throw new AssertionError();
        }
        return (Policy)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (ClassLoader classLoader2 = classLoader; classLoader2 != null; classLoader2 = classLoader2.getParent()) {
                    Policy policy = (Policy)AggregatePolicyProvider.this.subPolicies.get(classLoader2);
                    if (policy == null) continue;
                    return policy;
                }
                return AggregatePolicyProvider.this.mainPolicy;
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean trustGetContextClassLoader(Thread thread) {
        Boolean bl;
        Class<?> clazz = thread.getClass();
        if (clazz == Thread.class) {
            return true;
        }
        Map map = trustGetCCL;
        synchronized (map) {
            bl = (Boolean)trustGetCCL.get(clazz);
        }
        if (bl == null) {
            bl = AggregatePolicyProvider.trustGetContextClassLoader0(clazz);
            map = trustGetCCL;
            synchronized (map) {
                trustGetCCL.put(clazz, bl);
            }
        }
        return bl;
    }

    private static Boolean trustGetContextClassLoader0(final Class clazz) {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Method method = clazz.getMethod("getContextClassLoader", new Class[0]);
                    return new Boolean(method.getDeclaringClass() == (class$java$lang$Thread == null ? (class$java$lang$Thread = AggregatePolicyProvider.class$("java.lang.Thread")) : class$java$lang$Thread));
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new InternalError("Thread.getContextClassLoader() not found");
                }
            }
        });
    }

    static {
        $assertionsDisabled = !AggregatePolicyProvider.class.desiredAssertionStatus();
        trustGetCCL = new WeakHashMap();
        myDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return (class$com$sun$jini$start$AggregatePolicyProvider == null ? (class$com$sun$jini$start$AggregatePolicyProvider = AggregatePolicyProvider.class$("com.sun.jini.start.AggregatePolicyProvider")) : class$com$sun$jini$start$AggregatePolicyProvider).getProtectionDomain();
            }
        });
    }

    private static class AggregateSecurityContext
    implements SecurityContext {
        private final ClassLoader ccl = AggregatePolicyProvider.getContextClassLoader();
        private final SecurityContext sc;

        AggregateSecurityContext(SecurityContext securityContext) {
            if (securityContext == null) {
                throw new NullPointerException();
            }
            this.sc = securityContext;
        }

        public PrivilegedAction wrap(PrivilegedAction privilegedAction) {
            final PrivilegedAction privilegedAction2 = this.sc.wrap(privilegedAction);
            return new PrivilegedAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() {
                    Object t;
                    ClassLoader classLoader = AggregateSecurityContext.this.setCCL(AggregateSecurityContext.this.ccl, true);
                    try {
                        t = privilegedAction2.run();
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        AggregateSecurityContext.this.setCCL(classLoader, false);
                        throw throwable;
                    }
                    AggregateSecurityContext.this.setCCL(classLoader, false);
                    return t;
                }
            };
        }

        public PrivilegedExceptionAction wrap(PrivilegedExceptionAction privilegedExceptionAction) {
            final PrivilegedExceptionAction privilegedExceptionAction2 = this.sc.wrap(privilegedExceptionAction);
            return new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    Object t;
                    ClassLoader classLoader = AggregateSecurityContext.this.setCCL(AggregateSecurityContext.this.ccl, true);
                    try {
                        t = privilegedExceptionAction2.run();
                        Object var4_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        AggregateSecurityContext.this.setCCL(classLoader, false);
                        throw throwable;
                    }
                    AggregateSecurityContext.this.setCCL(classLoader, false);
                    return t;
                }
            };
        }

        public AccessControlContext getAccessControlContext() {
            return this.sc.getAccessControlContext();
        }

        private ClassLoader setCCL(final ClassLoader classLoader, final boolean bl) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Thread thread = Thread.currentThread();
                    ClassLoader classLoader2 = bl ? thread.getContextClassLoader() : null;
                    thread.setContextClassLoader(classLoader);
                    return classLoader2;
                }
            });
        }
    }

    private static class DefaultSecurityContext
    implements SecurityContext {
        private final AccessControlContext acc = AccessController.getContext();

        private DefaultSecurityContext() {
        }

        public PrivilegedAction wrap(PrivilegedAction privilegedAction) {
            if (privilegedAction == null) {
                throw new NullPointerException();
            }
            return privilegedAction;
        }

        public PrivilegedExceptionAction wrap(PrivilegedExceptionAction privilegedExceptionAction) {
            if (privilegedExceptionAction == null) {
                throw new NullPointerException();
            }
            return privilegedExceptionAction;
        }

        public AccessControlContext getAccessControlContext() {
            return this.acc;
        }
    }
}

