/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MacAppearanceUtils;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.apache.commons.lang.Validate;

public class ButtonFactory {
    private static final Color MAC_GRADIENT_BUTTON_BORDER_COLOR = new Color(0x979797);

    private ButtonFactory() {
    }

    public static JComponent makeComponentUtilityButtonGroup(AbstractButton ... abstractButtonArray) {
        Validate.notNull((Object)abstractButtonArray, (String)"'buttons' cannot be null");
        MJPanel mJPanel = new MJPanel((LayoutManager)new FlowLayout(0, 0, 0));
        for (AbstractButton abstractButton : abstractButtonArray) {
            ButtonFactory.makeSegmentedComponentUtilityButton(abstractButton);
            mJPanel.add((Component)abstractButton);
        }
        if (PlatformInfo.isMacintosh()) {
            MacAppearanceUtils.createMacSegmentedButtonGroup((MacAppearanceUtils.ButtonType)MacAppearanceUtils.ButtonType.SEGMENTED_GRADIENT, (AbstractButton[])abstractButtonArray);
            mJPanel.setBorder(abstractButtonArray.length > 1 ? BorderFactory.createMatteBorder(1, 0, 1, 0, MAC_GRADIENT_BUTTON_BORDER_COLOR) : BorderFactory.createLineBorder(MAC_GRADIENT_BUTTON_BORDER_COLOR));
        }
        return mJPanel;
    }

    private static void makeSegmentedComponentUtilityButton(AbstractButton abstractButton) {
        if (PlatformInfo.isMacintosh()) {
            ButtonFactory.setupMacSegmentedComponentUtilityButton(abstractButton);
        } else if (PlatformInfo.isWindowsClassicAppearance()) {
            ButtonFactory.setupWindowsClassicUtilityButton(abstractButton);
        } else {
            ButtonFactory.setupDefaultUtilityButton(abstractButton);
        }
    }

    public static Component createTextFieldEmbeddedEllipsisButton(ActionListener actionListener) {
        MJButton mJButton = new MJButton("...");
        mJButton.setHorizontalAlignment(0);
        mJButton.addActionListener(actionListener);
        if (PlatformInfo.isMacintosh()) {
            ButtonFactory.setupMacEmbeddedButton((AbstractButton)mJButton);
        } else {
            ButtonFactory.setupDefaultEmbeddedButton((AbstractButton)mJButton);
        }
        return mJButton;
    }

    private static void setupMacSegmentedComponentUtilityButton(AbstractButton abstractButton) {
        abstractButton.setFocusable(false);
    }

    private static void setupWindowsClassicUtilityButton(AbstractButton abstractButton) {
        abstractButton.setMargin(new Insets(1, 1, 1, 1));
        abstractButton.setFocusPainted(false);
    }

    private static void setupDefaultUtilityButton(AbstractButton abstractButton) {
        abstractButton.setMargin(new Insets(3, 3, 3, 3));
        abstractButton.setFocusPainted(false);
    }

    private static void setupMacEmbeddedButton(AbstractButton abstractButton) {
        MacAppearanceUtils.ButtonType.SQUARE.apply(abstractButton);
        MacAppearanceUtils.SizeVariant.MINI.apply((JComponent)abstractButton);
        abstractButton.setFocusPainted(false);
    }

    private static void setupDefaultEmbeddedButton(AbstractButton abstractButton) {
        abstractButton.setMargin(new Insets(0, 3, 0, 3));
        abstractButton.setFocusPainted(false);
        abstractButton.setOpaque(false);
    }
}

