/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class HyperlinkLabel
extends MJPanel {
    private String fCumulativeText = "";
    private boolean fBold;
    private boolean fDisabled;
    private boolean fPaintFocusBorder = true;
    private static final SpacerBasicLabelUI sSpacerUI = new SpacerBasicLabelUI();

    public HyperlinkLabel() {
        this(0);
    }

    public HyperlinkLabel(int n) {
        this.setLayout(new FlowLayout(n, 0, 0));
    }

    public HyperlinkLabel(String string, HyperlinkItem[] hyperlinkItemArray) {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.formatLabel(string, hyperlinkItemArray);
    }

    public HyperlinkLabel(String string, HyperlinkItem[] hyperlinkItemArray, int n) {
        this.setLayout(new FlowLayout(n, 0, 0));
        this.formatLabel(string, hyperlinkItemArray);
    }

    public HyperlinkLabel(String string, int n, ActionListener actionListener, String string2, String string3, boolean bl) {
        this(string, n, actionListener, string2, string3, bl, false);
    }

    public HyperlinkLabel(String string, int n, ActionListener actionListener, String string2, String string3, boolean bl, boolean bl2) {
        this(string, n, actionListener, string2, string3, bl, bl2, false);
    }

    public HyperlinkLabel(String string, int n, ActionListener actionListener, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        this.fBold = bl2;
        this.fDisabled = bl3;
        this.setLayout(new FlowLayout(n, 0, 0));
        this.appendLinkedText(string, actionListener, bl, string3, string2);
    }

    public HyperlinkLabel(String string, ActionListener actionListener, String string2, String string3) {
        this(string, 0, actionListener, string2, string3, false);
    }

    private void formatLabel(String string, HyperlinkItem[] hyperlinkItemArray) {
        int n = 0;
        while (true) {
            int[] nArray;
            if ((nArray = HyperlinkLabel.findNextArg(n, string))[0] == -1) {
                if (string.length() <= n) break;
                this.appendUnlinkedText(string.substring(n));
                break;
            }
            if (nArray[0] - n > 0) {
                this.appendUnlinkedText(string.substring(n, nArray[0]));
            }
            int n2 = Integer.parseInt(string.substring(nArray[0] + 1, nArray[1] - 1));
            this.appendLinkedText(hyperlinkItemArray[n2].getLabel(), hyperlinkItemArray[n2].getAction(), hyperlinkItemArray[n2].isCentered(), hyperlinkItemArray[n2].getAccName(), hyperlinkItemArray[n2].getQeName());
            n = nArray[1];
        }
    }

    private static int[] findNextArg(int n, CharSequence charSequence) {
        int[] nArray = new int[]{-1, -1};
        try {
            Pattern pattern = Pattern.compile("\\{\\d+\\}");
            Matcher matcher = pattern.matcher(charSequence);
            boolean bl = matcher.find(n);
            if (bl) {
                nArray[0] = matcher.start();
                nArray[1] = matcher.end();
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Log.printLn((String)("Illegal starting index: " + n));
            Log.logException((Exception)indexOutOfBoundsException);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
        return nArray;
    }

    public MJLabel appendUnlinkedText(String string) {
        MJLabel mJLabel = new MJLabel(string);
        if (PlatformInfo.isLinux()) {
            mJLabel.setUI((LabelUI)sSpacerUI);
        }
        this.add((Component)mJLabel);
        this.fCumulativeText = this.fCumulativeText.concat(string);
        return mJLabel;
    }

    public MJLabel appendLinkedText(String string, ActionListener actionListener, String string2, String string3) {
        return this.appendLinkedText(string, actionListener, false, string2, string3);
    }

    public MJLabel appendLinkedText(String string, ActionListener actionListener, boolean bl, String string2, String string3) {
        Hyperlink hyperlink = new Hyperlink(string, actionListener, bl);
        hyperlink.getAccessibleContext().setAccessibleName(string2);
        hyperlink.setName(string3);
        if (PlatformInfo.isLinux()) {
            hyperlink.setUI(sSpacerUI);
        }
        this.add((Component)((Object)hyperlink));
        this.fCumulativeText = this.fCumulativeText.concat(string);
        return hyperlink;
    }

    public String getText() {
        return this.fCumulativeText;
    }

    public void setFont(Font font) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            componentArray[i].setFont(font);
        }
    }

    public void removeListeners() {
        for (Component component : this.getComponents()) {
            if (!(component instanceof Hyperlink)) continue;
            ((Hyperlink)((Object)component)).removeListener();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        Component[] componentArray = this.getComponents();
        for (int i = 0; i != this.getComponentCount(); ++i) {
            if (!(componentArray[i] instanceof JLabel) || componentArray[i] instanceof Hyperlink) continue;
            componentArray[i].setForeground(color);
        }
    }

    public boolean isPaintingFocusBorder() {
        return this.fPaintFocusBorder;
    }

    public void setPaintFocusBorder(boolean bl) {
        this.fPaintFocusBorder = bl;
    }

    private static class SpacerBasicLabelUI
    extends BasicLabelUI {
        private SpacerBasicLabelUI() {
        }

        @Override
        public Dimension getPreferredSize(JComponent jComponent) {
            Dimension dimension = super.getPreferredSize(jComponent);
            ++dimension.width;
            return dimension;
        }
    }

    public class Hyperlink
    extends MJLabel {
        private static final String HTML_PRE = "<html><a href=\"\">";
        private static final String HTML_POST = "</a></html>";
        private static final String HTML_CENTER_PRE = "<html><p align=\"center\"><a href=\"\">";
        private static final String HTML_CENTER_POST = "</a></p></html>";
        private ActionListener fAction;
        private String fText;
        private final String fHyperHoverColor = "red";
        private final boolean fCenter;

        public Hyperlink(String string, ActionListener actionListener, boolean bl) {
            super(HTML_PRE + string + HTML_POST);
            this.fHyperHoverColor = "red";
            this.fAction = actionListener;
            this.fText = string;
            this.fCenter = bl;
            if (HyperlinkLabel.this.fBold) {
                this.setFont(this.getFont().deriveFont(1));
            }
            if (HyperlinkLabel.this.fDisabled) {
                this.setForeground(Color.gray);
            }
            if (this.fCenter) {
                super.setText(HTML_CENTER_PRE + string + HTML_CENTER_POST);
            } else if (HyperlinkLabel.this.fDisabled) {
                super.setText("<html><u>" + string + "</u></html>");
            }
            this.setFocusable(true);
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    Hyperlink.this.repaint();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Hyperlink.this.repaint();
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyChar() == '\n') {
                        Hyperlink.this.performAction();
                        keyEvent.consume();
                    }
                }
            });
            this.addMouseListener(new HyperMouseListener());
        }

        public void removeListener() {
            this.fAction = null;
        }

        public void setText(String string) {
            this.fText = string;
            if (this.fCenter) {
                super.setText(HTML_CENTER_PRE + this.fText + HTML_CENTER_POST);
            } else {
                super.setText(HTML_PRE + this.fText + HTML_POST);
            }
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.hasFocus() && HyperlinkLabel.this.fPaintFocusBorder) {
                graphics.setColor(UIManager.getColor("RadioButton.focus"));
                if (PlatformInfo.isXWindows()) {
                    graphics.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                } else {
                    BasicGraphicsUtils.drawDashedRect(graphics, 0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }

        private void performAction() {
            this.fAction.actionPerformed(new ActionEvent((Object)this, 1001, "LinkClicked"));
        }

        private void reformatLink(boolean bl) {
            if (bl) {
                if (this.fCenter) {
                    super.setText("<html><p align=\"center\"><a href=\"\"><font color=\"red\">" + this.fText + "</font>" + HTML_CENTER_POST);
                } else {
                    super.setText("<html><a href=\"\"><font color=\"red\">" + this.fText + "</font>" + HTML_POST);
                }
            } else {
                this.setText(this.fText);
            }
        }

        private class HyperMouseListener
        extends MouseAdapter {
            private HyperMouseListener() {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                Hyperlink.this.reformatLink(true);
                Hyperlink.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                Hyperlink.this.reformatLink(false);
                Hyperlink.this.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                Hyperlink.this.performAction();
            }
        }
    }

    public static class HyperlinkItem {
        private final String iLabel;
        private final String iQeName;
        private final String iAccName;
        private final ActionListener iAction;
        private final boolean iCentered;

        public HyperlinkItem(String string, ActionListener actionListener, String string2, String string3) {
            this(string, actionListener, string2, string3, false);
        }

        public HyperlinkItem(String string, ActionListener actionListener, String string2, String string3, boolean bl) {
            this.iLabel = string;
            this.iQeName = string2;
            this.iAccName = string3;
            this.iAction = actionListener;
            this.iCentered = bl;
        }

        public String getLabel() {
            return this.iLabel;
        }

        public String getQeName() {
            return this.iQeName;
        }

        public String getAccName() {
            return this.iAccName;
        }

        public ActionListener getAction() {
            return this.iAction;
        }

        public boolean isCentered() {
            return this.iCentered;
        }
    }
}

