/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJToggleButton;
import com.mathworks.widgets.PopupMenuCustomizer;
import com.mathworks.widgets.WidgetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WindowsWidgetFactory {
    private WindowsWidgetFactory() {
    }

    public static AbstractButton createSearchAndClearButton(JTextField jTextField, ActionListener actionListener) {
        return new SearchAndClearButton(jTextField, actionListener);
    }

    public static AbstractButton createOptionsButton(JPopupMenu jPopupMenu, PopupMenuCustomizer popupMenuCustomizer) {
        return new OptionsButton(jPopupMenu, popupMenuCustomizer);
    }

    public static Component createSearchWidgetButtonSet(JTextField jTextField, ActionListener actionListener, JPopupMenu jPopupMenu, PopupMenuCustomizer popupMenuCustomizer) {
        SearchAndClearButton searchAndClearButton = (SearchAndClearButton)((Object)WindowsWidgetFactory.createSearchAndClearButton(jTextField, actionListener));
        OptionsButton optionsButton = (OptionsButton)((Object)WindowsWidgetFactory.createOptionsButton(jPopupMenu, popupMenuCustomizer));
        jTextField.getDocument().addDocumentListener(WindowsWidgetFactory.createDocumentListener(searchAndClearButton, optionsButton));
        MJPanel mJPanel = new MJPanel();
        mJPanel.setOpaque(false);
        FormLayout formLayout = new FormLayout("p, p", "p:grow");
        CellConstraints cellConstraints = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(formLayout, (JPanel)mJPanel);
        panelBuilder.add((Component)((Object)searchAndClearButton), cellConstraints.xy(1, 1, "fill, fill"));
        panelBuilder.add((Component)((Object)optionsButton), cellConstraints.xy(2, 1, "fill, fill"));
        return mJPanel;
    }

    private static DocumentListener createDocumentListener(final SearchAndClearButton searchAndClearButton, final OptionsButton optionsButton) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                optionsButton.setAlwaysDrawBackground(searchAndClearButton.anyText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                optionsButton.setAlwaysDrawBackground(searchAndClearButton.anyText());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                optionsButton.setAlwaysDrawBackground(searchAndClearButton.anyText());
            }
        };
    }

    private static class ButtonBackgroundPainter {
        private static final Color TOP_COLOR = new Color(243, 243, 243);
        private static final Color BOTTOM_COLOR = new Color(218, 218, 218);
        private static final Color PRESSED_BACKGROUND = new Color(240, 242, 248);
        private static final Color PRESSED_SHADOW_1 = new Color(183, 188, 202);
        private static final Color PRESSED_SHADOW_2 = new Color(211, 215, 225);
        private static final Color PRESSED_SHADOW_3 = new Color(230, 233, 240);
        private static final Color DISABLED_COLOR = UIManager.getColor("TextField.disabledBackground");

        private ButtonBackgroundPainter() {
        }

        public static Color getBorderColor() {
            Color color = Color.LIGHT_GRAY;
            Border border = (Border)UIManager.get("TextField.border");
            if (border instanceof LineBorder) {
                color = ((LineBorder)border).getLineColor();
            }
            return color;
        }

        public static void paintSimpleBackground(Graphics graphics, Component component) {
            graphics.setColor(DISABLED_COLOR);
            graphics.fillRect(0, 0, component.getWidth(), component.getHeight());
        }

        public static void paintShinyBackground(Graphics graphics, Component component) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            int n = component.getHeight() / 2;
            graphics.setColor(TOP_COLOR);
            graphics.fillRect(0, 0, component.getWidth(), n);
            graphics.setColor(BOTTOM_COLOR);
            graphics.fillRect(0, n, component.getWidth(), component.getHeight());
            graphics2D.dispose();
        }

        public static void paintPressedBackground(Graphics graphics, Component component) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics.setColor(PRESSED_BACKGROUND);
            graphics.fillRect(0, 0, component.getWidth(), component.getHeight());
            graphics.setColor(PRESSED_SHADOW_1);
            graphics.drawLine(0, 0, component.getWidth(), 0);
            graphics.drawLine(0, 0, 0, component.getHeight());
            graphics.setColor(PRESSED_SHADOW_2);
            graphics.drawLine(1, 1, component.getWidth() - 1, 1);
            graphics.drawLine(1, 1, 1, component.getHeight() - 1);
            graphics.setColor(PRESSED_SHADOW_3);
            graphics.drawLine(2, 2, component.getWidth() - 2, 2);
            graphics.drawLine(2, 2, 2, component.getHeight() - 2);
            graphics2D.dispose();
        }

        public static void paintBorder(Graphics graphics, Component component) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics.setColor(ButtonBackgroundPainter.getBorderColor());
            graphics.drawLine(0, 0, 0, component.getHeight());
            graphics2D.dispose();
        }
    }

    private static class OptionsButton
    extends MJToggleButton {
        private JPopupMenu fOptionsPopupMenu;
        private PopupMenuCustomizer fPopupMenuCustomizer;
        private boolean fAlwaysDrawBackground = false;

        OptionsButton(JPopupMenu jPopupMenu, PopupMenuCustomizer popupMenuCustomizer) {
            this.fOptionsPopupMenu = jPopupMenu;
            this.fPopupMenuCustomizer = popupMenuCustomizer;
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 2));
            this.initIcons();
            JComboBox jComboBox = new JComboBox();
            Object object = jComboBox.getClientProperty("doNotCancelPopup");
            this.putClientProperty("doNotCancelPopup", object);
            this.addActionListener(this.createOptionsButtonActionListener());
            this.fOptionsPopupMenu.addPopupMenuListener(this.createPopupMenuListener());
            this.setName("WindowsWidget.OptionsButton");
            this.getAccessibleContext().setAccessibleName(WidgetUtils.lookup("windows.optionsButton.accessibleName"));
        }

        private void initIcons() {
            this.setDisabledIcon(MiscellaneousIcon.DROP_DOWN_ARROW_DISABLED_9x6.getIcon());
            this.setRolloverIcon(MiscellaneousIcon.DROP_DOWN_ARROW_HOVER_9x6.getIcon());
            this.setPressedIcon(MiscellaneousIcon.DROP_DOWN_ARROW_HOVER_9x6.getIcon());
        }

        public Icon getIcon() {
            return this.hasFocus() ? MiscellaneousIcon.DROP_DOWN_ARROW_HOVER_9x6.getIcon() : MiscellaneousIcon.DROP_DOWN_ARROW_9x6.getIcon();
        }

        private PopupMenuListener createPopupMenuListener() {
            return new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    OptionsButton.this.setSelected(false);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            };
        }

        private ActionListener createOptionsButtonActionListener() {
            return new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (OptionsButton.this.isSelected()) {
                        OptionsButton.this.fPopupMenuCustomizer.customize(OptionsButton.this.fOptionsPopupMenu);
                        int n = OptionsButton.this.getBounds().width - ((OptionsButton)OptionsButton.this).fOptionsPopupMenu.getPreferredSize().width + 1;
                        int n2 = OptionsButton.this.getBounds().height;
                        OptionsButton.this.fOptionsPopupMenu.show((Component)((Object)OptionsButton.this), n, n2);
                    } else {
                        OptionsButton.this.fOptionsPopupMenu.setVisible(false);
                    }
                }
            };
        }

        public void setAlwaysDrawBackground(boolean bl) {
            this.fAlwaysDrawBackground = bl;
            this.repaint();
        }

        public void paint(Graphics graphics) {
            if (this.getModel().isPressed() || this.isSelected()) {
                ButtonBackgroundPainter.paintPressedBackground(graphics, (Component)((Object)this));
                ButtonBackgroundPainter.paintBorder(graphics, (Component)((Object)this));
            } else if (this.isEnabled() && (this.getModel().isRollover() || this.hasFocus() || this.fAlwaysDrawBackground)) {
                ButtonBackgroundPainter.paintShinyBackground(graphics, (Component)((Object)this));
                ButtonBackgroundPainter.paintBorder(graphics, (Component)((Object)this));
            } else if (!this.isEnabled() && this.fAlwaysDrawBackground) {
                ButtonBackgroundPainter.paintSimpleBackground(graphics, (Component)((Object)this));
                ButtonBackgroundPainter.paintBorder(graphics, (Component)((Object)this));
            } else if (!this.isEnabled()) {
                ButtonBackgroundPainter.paintSimpleBackground(graphics, (Component)((Object)this));
            }
            super.paint(graphics);
        }
    }

    private static class SearchAndClearButton
    extends MJButton {
        private JTextField fTextField;

        SearchAndClearButton(JTextField jTextField) {
            this.fTextField = jTextField;
            this.initIcons();
            this.updatedEnablementAndBorder();
            this.setFocusPainted(false);
            this.setContentAreaFilled(false);
            this.fTextField.getDocument().addDocumentListener(this.createDocumentListener());
            this.setName("WindowsWidget.SearchAndClearButton");
        }

        SearchAndClearButton(JTextField jTextField, ActionListener actionListener) {
            this(jTextField);
            if (actionListener == null) {
                throw new IllegalArgumentException("The given button listenercannot be null.");
            }
            this.addActionListener(actionListener);
        }

        private void initIcons() {
            this.setRolloverIcon(MiscellaneousIcon.CANCEL_HOVER_15x15.getIcon());
            this.setPressedIcon(MiscellaneousIcon.CANCEL_HOVER_15x15.getIcon());
        }

        private boolean anyText() {
            return this.fTextField.getText().length() > 0;
        }

        public Icon getIcon() {
            ImageIcon imageIcon = !this.anyText() ? MiscellaneousIcon.MAGNIFYING_GLASS_BLUE.getIcon() : (this.hasFocus() ? MiscellaneousIcon.CANCEL_HOVER_15x15.getIcon() : MiscellaneousIcon.CANCEL_15x15.getIcon());
            return imageIcon;
        }

        public Icon getDisabledIcon() {
            ImageIcon imageIcon = this.anyText() ? MiscellaneousIcon.CANCEL_DISABLED_15x15.getIcon() : (this.fTextField.isEnabled() ? MiscellaneousIcon.MAGNIFYING_GLASS_BLUE.getIcon() : MiscellaneousIcon.MAGNIFYING_GLASS_BLUE_DISABLED.getIcon());
            return imageIcon;
        }

        public void setEnabled(boolean bl) {
            super.setEnabled(this.anyText() && bl);
        }

        private void updatedEnablementAndBorder() {
            this.setEnabled(this.anyText());
            int n = this.anyText() ? 1 : 0;
            int n2 = this.anyText() ? 0 : 1;
            Color color = this.anyText() ? ButtonBackgroundPainter.getBorderColor() : this.fTextField.getBackground();
            this.setBorder(BorderFactory.createMatteBorder(0, n, 0, n2, color));
            this.setToolTipText(this.isEnabled() ? WidgetUtils.lookup("windows.clearButton.tooltip") : null);
        }

        private DocumentListener createDocumentListener() {
            return new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SearchAndClearButton.this.updatedEnablementAndBorder();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SearchAndClearButton.this.updatedEnablementAndBorder();
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }
            };
        }

        public void paint(Graphics graphics) {
            if (!this.fTextField.isEnabled()) {
                ButtonBackgroundPainter.paintSimpleBackground(graphics, (Component)((Object)this));
            } else if (this.anyText()) {
                if (this.getModel().isPressed()) {
                    ButtonBackgroundPainter.paintPressedBackground(graphics, (Component)((Object)this));
                } else {
                    ButtonBackgroundPainter.paintShinyBackground(graphics, (Component)((Object)this));
                }
            }
            super.paint(graphics);
        }
    }
}

