/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;

class DTComponentResizer
extends MouseInputAdapter {
    Component fComponentToResize;
    int fCurrentCursor = 0;
    Point fInitialPoint;
    Rectangle fInitialBounds;
    int fXLimit;
    int fYLimit;
    int fXLower;
    int fYLower;
    boolean fButtonDown;
    boolean fChangedBounds;
    public static final int CORNER_THRESHOLD = 16;

    DTComponentResizer() {
    }

    DTComponentResizer(Component component) {
        this.fComponentToResize = component;
    }

    protected Component getComponentToResize() {
        return this.fComponentToResize;
    }

    protected Insets getResizeInsets() {
        if (this.getComponentToResize() instanceof JComponent) {
            return ((JComponent)this.getComponentToResize()).getInsets();
        }
        return null;
    }

    protected Dimension getMinimumSize() {
        return this.getComponentToResize().getMinimumSize();
    }

    protected Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fButtonDown = true;
        this.prepareForDrag(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.fButtonDown = false;
        this.fInitialPoint = null;
        this.fInitialBounds = null;
        if (this.fChangedBounds) {
            this.getComponentToResize().invalidate();
            this.getComponentToResize().validate();
            this.getComponentToResize().repaint();
            this.fChangedBounds = false;
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.fButtonDown && this.fCurrentCursor != 0) {
            this.getComponentToResize().setCursor(null);
            this.fCurrentCursor = 0;
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.fCurrentCursor == 0) {
            return;
        }
        if (this.fInitialPoint == null) {
            this.prepareForDrag(mouseEvent);
            return;
        }
        Rectangle rectangle = this.getComponentToResize().getBounds();
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.getComponentToResize().getParent());
        int n = point.x - this.fInitialPoint.x;
        int n2 = point.y - this.fInitialPoint.y;
        if (this.fCurrentCursor == 10 || this.fCurrentCursor == 6 || this.fCurrentCursor == 4) {
            rectangle.x = this.fInitialBounds.x + n;
            rectangle.width = this.fInitialBounds.width - n;
            if (rectangle.x > this.fXLimit) {
                rectangle.x = this.fXLimit;
            }
            if (rectangle.x < this.fXLower) {
                rectangle.x = this.fXLower;
            }
        }
        if (this.fCurrentCursor == 8 || this.fCurrentCursor == 6 || this.fCurrentCursor == 7) {
            rectangle.y = this.fInitialBounds.y + n2;
            rectangle.height = this.fInitialBounds.height - n2;
            if (rectangle.y > this.fYLimit) {
                rectangle.y = this.fYLimit;
            }
            if (rectangle.y < this.fYLower) {
                rectangle.y = this.fYLower;
            }
        }
        if (this.fCurrentCursor == 11 || this.fCurrentCursor == 7 || this.fCurrentCursor == 5) {
            rectangle.width = this.fInitialBounds.width + n;
        }
        if (this.fCurrentCursor == 9 || this.fCurrentCursor == 5 || this.fCurrentCursor == 4) {
            rectangle.height = this.fInitialBounds.height + n2;
        }
        Dimension dimension = this.getMinimumSize();
        if (rectangle.width < dimension.width) {
            rectangle.width = dimension.width;
        }
        if (rectangle.height < dimension.height) {
            rectangle.height = dimension.height;
        }
        Dimension dimension2 = this.getMaximumSize();
        if (rectangle.width > dimension2.width) {
            rectangle.width = dimension2.width;
        }
        if (rectangle.height > dimension2.height) {
            rectangle.height = dimension2.height;
        }
        this.getComponentToResize().setBounds(rectangle);
        this.getComponentToResize().invalidate();
        this.getComponentToResize().validate();
        this.getComponentToResize().repaint();
        this.fChangedBounds = true;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = this.getCursorType(mouseEvent.getPoint());
        if (n != this.fCurrentCursor) {
            this.fCurrentCursor = n;
            this.getComponentToResize().setCursor(n == 0 ? null : Cursor.getPredefinedCursor(n));
        }
    }

    private void prepareForDrag(MouseEvent mouseEvent) {
        this.fInitialPoint = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.getComponentToResize().getParent());
        this.fInitialBounds = this.getComponentToResize().getBounds();
        Dimension dimension = this.getMinimumSize();
        Dimension dimension2 = this.getMaximumSize();
        if (this.fCurrentCursor == 10 || this.fCurrentCursor == 6 || this.fCurrentCursor == 4) {
            this.fXLimit = this.fInitialBounds.x + this.fInitialBounds.width - dimension.width;
            this.fXLower = this.fInitialBounds.x + this.fInitialBounds.width - dimension2.width;
        }
        if (this.fCurrentCursor == 8 || this.fCurrentCursor == 6 || this.fCurrentCursor == 7) {
            this.fYLimit = this.fInitialBounds.y + this.fInitialBounds.height - dimension.height;
            this.fYLower = this.fInitialBounds.y + this.fInitialBounds.height - dimension2.height;
        }
    }

    int getCursorType(Point point) {
        Insets insets = this.getResizeInsets();
        Dimension dimension = this.getComponentToResize().getSize();
        if (point.x < insets.left) {
            if (point.y < 16) {
                return 6;
            }
            if (point.y + 16 > dimension.height) {
                return 4;
            }
            return 10;
        }
        if (point.y < insets.top) {
            if (point.x < 16) {
                return 6;
            }
            if (point.x + 16 > dimension.width) {
                return 7;
            }
            return 8;
        }
        if (point.x + insets.right >= dimension.width) {
            if (point.y < 16) {
                return 7;
            }
            if (point.y + 16 > dimension.height) {
                return 5;
            }
            return 11;
        }
        if (point.y + insets.bottom >= dimension.height) {
            if (point.x < 16) {
                return 4;
            }
            if (point.x + 16 > dimension.width) {
                return 5;
            }
            return 9;
        }
        return 0;
    }
}

