/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.common.icons.ProvisionalIcon;
import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.attr.BooleanAttribute;
import com.mathworks.desktop.client.Client;
import com.mathworks.mwswing.ChildAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.toolstrip.DefaultToolstrip;
import com.mathworks.toolstrip.DefaultToolstripTab;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSFactory;
import com.mathworks.toolstrip.sections.ToolstripSections;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.desk.DTDocumentContainer;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTWindowMenu;
import com.mathworks.widgets.desk.Desktop;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class DTToolstripFactory {
    protected Desktop fDesktop;
    public static final BooleanAttribute IS_GLOBAL_TAB = new BooleanAttribute("is-global-tab");
    static final Attribute<DTGroup> CONTEXTUAL_TAB_GROUP = new Attribute("contextual-tab-group");

    public DTToolstripFactory(Desktop desktop) {
        this.fDesktop = desktop;
    }

    public Toolstrip createToolstrip(DTFrame dTFrame) {
        return this.createToolstrip(dTFrame, "Home");
    }

    public Toolstrip createToolstrip(DTFrame dTFrame, String string) {
        DefaultToolstrip defaultToolstrip = new DefaultToolstrip();
        if (dTFrame.isMainFrame()) {
            DefaultToolstripTab defaultToolstripTab = new DefaultToolstripTab("home", string);
            defaultToolstripTab.setAttribute((Attribute)IS_GLOBAL_TAB, (Object)true);
            this.populateHomeTab((ToolstripTab)defaultToolstripTab, dTFrame);
            defaultToolstrip.getModel().add((Client)defaultToolstripTab);
            defaultToolstrip.setCurrentTab("home");
        }
        return defaultToolstrip;
    }

    public void populateHomeTab(ToolstripTab toolstripTab, DTFrame dTFrame) {
        toolstripTab.getModel().add((Client)this.createHomeViewSection(dTFrame));
    }

    public ToolstripSection createHomeViewSection(DTFrame dTFrame) {
        return this.createHomeViewSection(dTFrame, true);
    }

    public ToolstripSection createHomeViewSection(DTFrame dTFrame, boolean bl) {
        return ToolstripSections.newSectionBuilder((String)"view", (String)"View").add((JComponent)this.createViewButton(dTFrame, bl)).build();
    }

    public TSDropDownButton createViewButton(DTFrame dTFrame) {
        return this.createViewButton(dTFrame, true);
    }

    public TSDropDownButton createViewButton(DTFrame dTFrame, boolean bl) {
        return new TSDropDownButton((Action)((Object)new ViewAction(dTFrame, bl)));
    }

    public static TSDropDownButton createWindowButton(Desktop desktop, String string) {
        return new TSDropDownButton((Action)((Object)new WindowAction(desktop, string)));
    }

    public static Map<DocumentArrangement, Action> getDocumentArrangementActions(Desktop desktop, String string) {
        DTGroup dTGroup = desktop.getGroup(string);
        if (dTGroup == null) {
            throw new IllegalArgumentException("Group " + string + " not found");
        }
        return DTToolstripFactory.getDocumentArrangementActions(dTGroup);
    }

    static Map<DocumentArrangement, Action> getDocumentArrangementActions(DTGroup dTGroup) {
        DTDocumentContainer dTDocumentContainer = dTGroup.getDocumentContainer();
        EnumMap<DocumentArrangement, Action> enumMap = new EnumMap<DocumentArrangement, Action>(DocumentArrangement.class);
        enumMap.put(DocumentArrangement.SINGLE_TILE, (Action)new ChildAction((Action)dTDocumentContainer.getMaximizeAction()));
        enumMap.put(DocumentArrangement.TILE_LEFT_RIGHT, (Action)new ChildAction((Action)dTDocumentContainer.getSplitEastWestAction()));
        enumMap.put(DocumentArrangement.TILE_TOP_BOTTOM, (Action)new ChildAction((Action)dTDocumentContainer.getSplitNorthSouthAction()));
        enumMap.put(DocumentArrangement.TILE, (Action)new ChildAction((Action)((Object)dTDocumentContainer.getTileAction())));
        enumMap.put(DocumentArrangement.FLOAT, (Action)new ChildAction((Action)dTDocumentContainer.getFloatAction()));
        return enumMap;
    }

    public static class ToolstripButtonMenu
    extends MJMenu
    implements PopupListener {
        public ToolstripButtonMenu() {
        }

        public ToolstripButtonMenu(Action ... actionArray) {
            for (Action action : actionArray) {
                if (action == null) {
                    this.addSeparator();
                    continue;
                }
                this.add(action);
            }
        }

        public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
            popupCallback.show((JComponent)this.getPopupMenu());
        }
    }

    public static class MenuDisposer
    implements PopupMenuListener {
        private MJMenu iMenu;

        public MenuDisposer(MJMenu mJMenu) {
            this.iMenu = mJMenu;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MenuDisposer.this.iMenu.dispose();
                }
            });
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    public static class WindowAction
    extends MJAbstractAction {
        public WindowAction(final Desktop desktop, final String string) {
            super("Window", (Icon)new ImageIcon(DTToolstripFactory.class.getResource("resources/windows_16x16.png")));
            this.putValue("PopupListener", new PopupListener(){

                public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                    DefaultListModel<ListItem> defaultListModel = new DefaultListModel<ListItem>();
                    int n = 0;
                    for (Action action : desktop.getWindowRegistry().getActivationActions(string)) {
                        ListItem listItem = ListItem.newItem((String)("window " + n++), (String)((String)action.getValue("Name")));
                        listItem.getAttributes().setAttribute(TSFactory.ACTION_ATTRIBUTE, (Object)action);
                        defaultListModel.addElement(listItem);
                    }
                    PopupList popupList = new PopupList(defaultListModel);
                    popupList.setListStyle(ListStyle.TEXT_ONLY);
                    popupList.addListActionListener(new ListActionListener(){

                        public void listItemSelected(ListActionEvent listActionEvent) {
                            ListItem listItem = listActionEvent.getListItem();
                            Action action = (Action)listItem.getAttributes().getAttribute(TSFactory.ACTION_ATTRIBUTE);
                            if (action != null) {
                                action.actionPerformed((ActionEvent)listActionEvent);
                            }
                        }
                    });
                    popupCallback.show((JComponent)popupList);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class ViewAction
    extends MJAbstractAction {
        public ViewAction(final DTFrame dTFrame, final boolean bl) {
            super("View", (Icon)ProvisionalIcon.VIEW.getIcon());
            this.putValue("PopupListener", new PopupListener(){

                public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                    DTWindowMenu dTWindowMenu = new DTWindowMenu(dTFrame.getDesktop(), dTFrame, bl, !PlatformInfo.isMacintosh(), null);
                    dTWindowMenu.populate();
                    JPopupMenu jPopupMenu = dTWindowMenu.getPopupMenu();
                    jPopupMenu.addPopupMenuListener(new MenuDisposer(dTWindowMenu));
                    popupCallback.show((JComponent)jPopupMenu);
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static enum DocumentArrangement {
        SINGLE_TILE,
        TILE_LEFT_RIGHT,
        TILE_TOP_BOTTOM,
        TILE,
        FLOAT;

    }
}

