/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WeakPropertyChangeCoupler;
import com.mathworks.widgets.action.AbstractCopyAction;
import com.mathworks.widgets.action.AbstractCutAction;
import com.mathworks.widgets.action.AbstractFindAction;
import com.mathworks.widgets.action.AbstractPageSetupAction;
import com.mathworks.widgets.action.AbstractPasteAction;
import com.mathworks.widgets.action.AbstractPrintAction;
import com.mathworks.widgets.action.AbstractPrintSelectionAction;
import com.mathworks.widgets.action.AbstractRedoAction;
import com.mathworks.widgets.action.AbstractSaveAction;
import com.mathworks.widgets.action.AbstractUndoAction;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MacScreenMenuProxy {
    public static final String SAVE_NAME = DTMenuMergeTag.SAVE.toString();
    public static final String SAVE_AS_NAME = DTMenuMergeTag.SAVE_AS.toString();
    public static final String CLOSE = DTMenuMergeTag.CLOSE.toString();
    public static final String PRINT_NAME = DTMenuMergeTag.PRINT.toString();
    public static final String PRINT_SELECTION_NAME = DTMenuMergeTag.PRINT_SELECTION.toString();
    public static final String PAGE_SETUP_NAME = DTMenuMergeTag.PAGE_SETUP.toString();
    public static final String CUT_NAME = DTMenuMergeTag.CUT.toString();
    public static final String COPY_NAME = DTMenuMergeTag.COPY.toString();
    public static final String PASTE_NAME = DTMenuMergeTag.PASTE.toString();
    public static final String UNDO_NAME = DTMenuMergeTag.UNDO.toString();
    public static final String REDO_NAME = DTMenuMergeTag.REDO.toString();
    public static final String SELECT_ALL = DTMenuMergeTag.SELECT_ALL.toString();
    public static final String DELETE = DTMenuMergeTag.DELETE.toString();
    public static final String FIND = DTMenuMergeTag.FIND.toString();
    public static final String SEPARATOR_NAME = "separator";
    private DTFrame fFrame;
    protected Map<String, MenuItemProxy> fItemMap = new HashMap<String, MenuItemProxy>();

    public MacScreenMenuProxy(DTFrame dTFrame) {
        String[] stringArray;
        this.fFrame = dTFrame;
        for (String string : stringArray = new String[]{SAVE_NAME, SAVE_AS_NAME, CLOSE, PRINT_NAME, PRINT_SELECTION_NAME, PAGE_SETUP_NAME, CUT_NAME, COPY_NAME, PASTE_NAME, UNDO_NAME, REDO_NAME, SELECT_ALL, DELETE, FIND}) {
            MenuItemProxy menuItemProxy = new MenuItemProxy(string);
            dTFrame.getTargetingManager().register(string, (AbstractButton)menuItemProxy);
            this.fItemMap.put(string, menuItemProxy);
        }
    }

    public String getActionLabel(String string) {
        MenuItemProxy menuItemProxy = this.fItemMap.get(string);
        return menuItemProxy == null ? null : (String)menuItemProxy.fLabel.get();
    }

    public KeyStroke getActionShortcut(String string) {
        MenuItemProxy menuItemProxy = this.fItemMap.get(string);
        return menuItemProxy == null ? null : (KeyStroke)menuItemProxy.fShortcut.get();
    }

    public boolean isActionEnabled(String string) {
        MenuItemProxy menuItemProxy = this.fItemMap.get(string);
        return menuItemProxy != null && menuItemProxy.fIsEnabled.get();
    }

    public boolean isSeparator(String string) {
        return string.startsWith(SEPARATOR_NAME);
    }

    public String getSeparatorLabel(String string) {
        if (this.isSeparator(string)) {
            int n = SEPARATOR_NAME.length() + 1;
            return string.length() > n ? string.substring(n) : null;
        }
        return null;
    }

    public void performAction(final String string) {
        final MenuItemProxy menuItemProxy = this.fItemMap.get(string);
        if (menuItemProxy != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    menuItemProxy.getAction().actionPerformed(new ActionEvent(MacScreenMenuProxy.this.fFrame, 1001, string));
                }
            });
        }
    }

    public String[] getNewActionNames() {
        return new String[0];
    }

    public static MacScreenMenuProxy getActiveMenuProxy() {
        Frame[] frameArray;
        for (Frame frame : frameArray = Frame.getFrames()) {
            if (!frame.isActive()) continue;
            if (!(frame instanceof DTFrame)) break;
            return ((DTFrame)((Object)frame)).getMacScreenMenuProxy();
        }
        return null;
    }

    public static class MenuItemProxy
    extends JMenuItem
    implements PropertyChangeListener {
        private AtomicBoolean fIsEnabled = new AtomicBoolean(false);
        private AtomicReference<String> fLabel = new AtomicReference<Object>(null);
        private AtomicReference<KeyStroke> fShortcut = new AtomicReference();

        public MenuItemProxy(String string) {
            this.setAction(this.createAction(string));
        }

        public MenuItemProxy(Action action) {
            this.setAction(action);
        }

        private Action createAction(String string) {
            MJAbstractAction mJAbstractAction = SAVE_NAME.equals(string) ? new AbstractSaveAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (PRINT_NAME.equals(string) ? new AbstractPrintAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (PRINT_SELECTION_NAME.equals(string) ? new AbstractPrintSelectionAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (PAGE_SETUP_NAME.equals(string) ? new AbstractPageSetupAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (CUT_NAME.equals(string) ? new AbstractCutAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (COPY_NAME.equals(string) ? new AbstractCopyAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (PASTE_NAME.equals(string) ? new AbstractPasteAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (UNDO_NAME.equals(string) ? new AbstractUndoAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (REDO_NAME.equals(string) ? new AbstractRedoAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : (FIND.equals(string) ? new AbstractFindAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            } : new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            })))))))));
            mJAbstractAction.setEnabled(false);
            return mJAbstractAction;
        }

        @Override
        public void setAction(Action action) {
            Action action2 = this.getAction();
            if (action2 != null) {
                WeakPropertyChangeCoupler.detach((Action)action2, (PropertyChangeListener)this);
            }
            if (action instanceof ExtendedAction) {
                ExtendedAction extendedAction = (ExtendedAction)action;
                WeakPropertyChangeCoupler.attach((Action)action, (PropertyChangeListener)this);
                this.fIsEnabled.set(action.isEnabled());
                this.fLabel.set(MJUtilities.exciseMnemonic((String)extendedAction.getName()));
                this.fShortcut.set(extendedAction.getAccelerator());
            }
            super.setAction(action);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                this.fIsEnabled.set((Boolean)propertyChangeEvent.getNewValue());
            } else if ("Name".equals(propertyChangeEvent.getPropertyName())) {
                this.fLabel.set(MJUtilities.exciseMnemonic((String)((String)propertyChangeEvent.getNewValue())));
            } else if ("AcceleratorKey".equals(propertyChangeEvent.getPropertyName())) {
                this.fShortcut.set((KeyStroke)propertyChangeEvent.getNewValue());
            }
        }
    }
}

