/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.find;

import com.mathworks.services.Prefs;
import java.util.ArrayList;
import java.util.List;

public final class FindPrefs {
    private static final String PREF_MATCH_CASE = "ReplaceMatchCase";
    private static final String PREF_WRAP_AROUND = "ReplaceWordWrap";
    private static final String PREF_WHOLE_WORD = "ReplaceWholeWord";
    private static final String PREF_SEARCH_TEXT = "ReplaceSearchText";
    private static final String PREF_REPLACE_TEXT = "ReplaceText";
    private static final boolean MATCH_CASE_DEFAULT = false;
    private static final boolean WHOLE_WORD_DEFAULT = false;
    private static final boolean WRAP_AROUND_DEFAULT = true;

    private FindPrefs() {
    }

    static void save(int n, List<String> list, List<String> list2) {
        Prefs.setBooleanPref((String)PREF_MATCH_CASE, ((n & 1) != 0 ? 1 : 0) != 0);
        Prefs.setBooleanPref((String)PREF_WHOLE_WORD, ((n & 4) != 0 ? 1 : 0) != 0);
        Prefs.setBooleanPref((String)PREF_WRAP_AROUND, ((n & 2) != 0 ? 1 : 0) != 0);
        FindPrefs.writeHistoryList(PREF_SEARCH_TEXT, list);
        FindPrefs.writeHistoryList(PREF_REPLACE_TEXT, list2);
    }

    public static List<String> getSearchHistory() {
        return FindPrefs.readHistoryList(PREF_SEARCH_TEXT);
    }

    public static List<String> getReplaceHistory() {
        return FindPrefs.readHistoryList(PREF_REPLACE_TEXT);
    }

    private static List<String> readHistoryList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < 20; ++i) {
            String string2 = string + (i == 0 ? "" : Integer.valueOf(i + 1));
            String string3 = Prefs.getStringPref((String)string2, (String)"");
            if (string3.length() <= 0 && !arrayList.isEmpty()) continue;
            arrayList.add(string3);
        }
        if (arrayList.isEmpty()) {
            arrayList.add("");
        }
        return arrayList;
    }

    private static void writeHistoryList(String string, List<String> list) {
        for (int i = 0; i < 20; ++i) {
            String string2 = string + (i == 0 ? "" : Integer.valueOf(i + 1));
            Prefs.setStringPref((String)string2, (String)(i < list.size() ? list.get(i) : ""));
        }
    }

    public static int getOptions() {
        int n = 0;
        if (Prefs.getBooleanPref((String)PREF_MATCH_CASE, (boolean)false)) {
            ++n;
        }
        if (Prefs.getBooleanPref((String)PREF_WHOLE_WORD, (boolean)false)) {
            n += 4;
        }
        if (Prefs.getBooleanPref((String)PREF_WRAP_AROUND, (boolean)true)) {
            n += 2;
        }
        return n;
    }
}

