/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.mathworks.mwswing.MJUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class GroupingTableTransaction<T>
implements Iterable<Element<T>> {
    private final List<Element<T>> fElements;

    public GroupingTableTransaction() {
        this.fElements = new LinkedList<Element<T>>();
    }

    public GroupingTableTransaction(List<GroupingTableTransaction<T>> list) {
        int n = 0;
        for (GroupingTableTransaction<T> groupingTableTransaction : list) {
            n += groupingTableTransaction.fElements.size();
        }
        this.fElements = new ArrayList<Element<T>>(n);
        for (GroupingTableTransaction<T> groupingTableTransaction : list) {
            this.fElements.addAll(groupingTableTransaction.fElements);
        }
    }

    public void add(Type type) {
        this.fElements.add(new Element<Object>(type, null));
    }

    public void add(Type type, T t) {
        this.fElements.add(new Element<T>(type, t));
    }

    @Override
    public Iterator<Element<T>> iterator() {
        return new ArrayList<Element<T>>(this.fElements).iterator();
    }

    void apply(final Target<T> target) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                target.startTransaction();
                boolean bl = false;
                boolean bl2 = false;
                for (Element element : GroupingTableTransaction.this) {
                    switch (element.getType()) {
                        case ADD: {
                            if (!target.add(element.getData())) break;
                            bl = true;
                            bl2 = true;
                            break;
                        }
                        case CHANGE: {
                            UpdateResult updateResult = target.update(element.getData());
                            if (updateResult == UpdateResult.DOES_NOT_EXIST) {
                                if (!target.add(element.getData())) break;
                                bl = true;
                                bl2 = true;
                                break;
                            }
                            if (updateResult != UpdateResult.AFFECTS_SORTING_OR_GROUPING) break;
                            bl = true;
                            bl2 = true;
                            break;
                        }
                        case CLEAR: {
                            target.clear();
                            bl = false;
                            bl2 = true;
                            break;
                        }
                        case REMOVE: {
                            target.remove(element.getData());
                            bl2 = true;
                        }
                    }
                }
                target.finishTransaction(bl, bl2);
            }
        });
    }

    public static interface Target<T> {
        public void startTransaction();

        public UpdateResult update(T var1);

        public boolean add(T var1);

        public boolean remove(T var1);

        public void clear();

        public void finishTransaction(boolean var1, boolean var2);
    }

    public static enum UpdateResult {
        DOES_NOT_EXIST,
        AFFECTS_SORTING_OR_GROUPING,
        DOES_NOT_AFFECT_SORTING_OR_GROUPING;

    }

    public static final class Element<T> {
        private final Type fType;
        private final T fData;

        Element(Type type, T t) {
            this.fType = type;
            this.fData = t;
        }

        public Type getType() {
            return this.fType;
        }

        public T getData() {
            return this.fData;
        }
    }

    public static enum Type {
        ADD,
        REMOVE,
        CHANGE,
        CLEAR;

    }
}

