/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable.transfer;

import com.mathworks.mwswing.datatransfer.MJDataFlavor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public final class Transfer {
    private Transferable fTransferable;
    private final Clipboard fClipboard;

    Transfer(Transferable transferable) {
        this.fTransferable = transferable;
        this.fClipboard = null;
        assert (this.fTransferable != null);
    }

    Transfer(Clipboard clipboard) {
        this.fClipboard = clipboard;
        assert (this.fClipboard != null);
    }

    public Transferable getData() {
        if (this.fTransferable == null) {
            this.fTransferable = this.fClipboard.getContents(null);
        }
        return this.fTransferable;
    }

    public boolean isDataFlavorAvailable(DataFlavor dataFlavor) {
        if (this.fClipboard != null) {
            return this.fClipboard.isDataFlavorAvailable(dataFlavor);
        }
        return this.fTransferable.isDataFlavorSupported(dataFlavor);
    }

    public List getTransferList(DataFlavor dataFlavor) {
        try {
            return (List)this.getData().getTransferData(dataFlavor);
        }
        catch (Exception exception) {
            return new Vector(0);
        }
    }

    public Object getTransferData(DataFlavor dataFlavor) {
        try {
            return this.getData().getTransferData(dataFlavor);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public List<File> getFileTransferList() {
        try {
            return Arrays.asList(MJDataFlavor.decodeJavaFileListFlavor((Transferable)this.getData()));
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }
}

