/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.incSearch;

import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.widgets.incSearch.IncSearchData;
import com.mathworks.widgets.incSearch.IncSearchInterface;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.netbeans.editor.WeakTimerListener;

public class IncSearch
extends MouseAdapter
implements KeyListener,
ActionListener,
FocusListener {
    protected static final int MENU_SHORTCUT_KEY_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private boolean fSearchForward = true;
    private ResultObservable fObservable = new ResultObservable();
    private IncSearchData fLastGoodSearch = null;
    private IncSearchData fLastSearch = null;
    private static String sFIncSearchString;
    private static String sRIncSearchString;
    private static String sFailingSearchString;
    private IncSearchInterface fIncSearchIf;
    private static String sSearchString;
    private static String sLastSearchString;
    private static boolean sDeleteSearchString;
    protected Timer fIncSearchTimer;
    private static volatile boolean sSearchEnded;

    public IncSearch(IncSearchInterface incSearchInterface, boolean bl) {
        this.fIncSearchIf = incSearchInterface;
        this.fSearchForward = bl;
        int n = 200;
        this.fIncSearchTimer = new Timer(n, (ActionListener)new WeakTimerListener((ActionListener)this));
        this.fIncSearchTimer.setRepeats(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fIncSearchTimer) {
            if (!sSearchEnded) {
                this.fLastSearch = this.fIncSearchIf.incSearch(sSearchString, this.fSearchForward);
                if (this.fLastSearch.getFoundText()) {
                    this.fLastGoodSearch = this.fLastSearch;
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
                this.doNotifyObservers(sSearchString);
            }
        } else {
            this.startIncSearchRunnable();
        }
    }

    void changeFindWhat() {
        this.fIncSearchTimer.restart();
        this.fLastSearch = null;
        sSearchEnded = false;
        sDeleteSearchString = false;
        this.doNotifyObservers(sSearchString);
    }

    private void startIncSearchRunnable() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IncSearch.this.changeFindWhat();
            }
        });
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.analyzeKey(keyEvent)) {
            this.startIncSearchRunnable();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    private boolean analyzeKey(KeyEvent keyEvent) {
        int n = keyEvent.getModifiers();
        int n2 = keyEvent.getKeyCode();
        boolean bl = false;
        int n3 = 2;
        if (n2 == 17 || n2 == 157 || n2 == 18 || n2 == 16) {
            keyEvent.consume();
            return bl;
        }
        if (n == 0 || n == 1 || n == 32) {
            switch (n2) {
                case 10: {
                    this.searchDone(true);
                    keyEvent.consume();
                    break;
                }
                case 27: {
                    this.searchDone(false);
                    keyEvent.consume();
                    break;
                }
                case 8: {
                    keyEvent.consume();
                    if (sDeleteSearchString || sSearchString.length() <= 1) {
                        sSearchString = "";
                        sDeleteSearchString = false;
                        this.fIncSearchIf.clearSearch();
                        this.initIncSearch(this.fSearchForward);
                        bl = false;
                    } else {
                        sSearchString = sSearchString.substring(0, sSearchString.length() - 1);
                        bl = true;
                    }
                    this.fIncSearchIf.getLastActiveComponent().repaint();
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 127: 
                case 144: 
                case 145: 
                case 155: {
                    this.searchDone(true);
                    break;
                }
                default: {
                    bl = true;
                    if (n2 != 20) {
                        sSearchString = sSearchString + keyEvent.getKeyChar();
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (n == n3) {
            if (n2 == 83) {
                if (sSearchString.equals("") && !this.fSearchForward) {
                    this.fSearchForward = true;
                    this.initIncSearch(this.fSearchForward);
                } else {
                    if (sSearchString.equals("") && !sLastSearchString.equals("")) {
                        sSearchString = sLastSearchString;
                        sDeleteSearchString = true;
                    }
                    this.fSearchForward = true;
                    sSearchEnded = false;
                    this.fLastSearch = this.fIncSearchIf.find(sSearchString, this.fSearchForward);
                    this.doNotifyObservers(sSearchString);
                }
                keyEvent.consume();
            } else if (n2 == 82) {
                if (sSearchString.equals("") && this.fSearchForward) {
                    this.fSearchForward = false;
                    this.initIncSearch(this.fSearchForward);
                } else {
                    if (sSearchString.equals("") && !sLastSearchString.equals("")) {
                        sSearchString = sLastSearchString;
                        sDeleteSearchString = true;
                    }
                    sSearchEnded = false;
                    this.fSearchForward = false;
                    this.fLastSearch = this.fIncSearchIf.find(sSearchString, this.fSearchForward);
                    this.doNotifyObservers(sSearchString);
                }
                keyEvent.consume();
            } else if (n2 == 87) {
                sSearchString = this.fIncSearchIf.incSearchNextWord(sSearchString);
                this.startIncSearchRunnable();
                this.fIncSearchIf.getLastActiveComponent().repaint();
                keyEvent.consume();
            } else if (n2 == 71) {
                if (this.fLastGoodSearch != null && this.fLastSearch != null) {
                    if (this.fLastSearch.getFoundText()) {
                        this.searchDoneRestoreCaret();
                    } else {
                        sSearchString = this.fLastGoodSearch.getSearchString();
                        this.startIncSearchRunnable();
                    }
                    keyEvent.consume();
                }
            } else {
                this.searchDone(false);
            }
        } else if (n == 8 && n2 == 89) {
            try {
                Transferable transferable = MJClipboard.getMJClipboard().getContents((Object)this);
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    sSearchString = sSearchString + string;
                    this.startIncSearchRunnable();
                }
            }
            catch (Exception exception) {
                System.out.println(" Pasting text exception: " + exception);
            }
            keyEvent.consume();
        }
        return bl;
    }

    public void initIncSearch(boolean bl) {
        this.fSearchForward = bl;
        String string = sFIncSearchString;
        if (!this.fSearchForward) {
            string = sRIncSearchString;
        }
        this.fObservable.notifyRegisteredObservers(string);
    }

    public void searchDone(boolean bl) {
        if (bl) {
            this.fIncSearchIf.endIncSearchMoveCaret();
        } else {
            this.fIncSearchIf.endIncSearch();
        }
        if (!sSearchString.equals("")) {
            sLastSearchString = sSearchString;
        }
        sSearchEnded = true;
        sSearchString = "";
        this.doNotifyObservers(sSearchString);
    }

    private void searchDoneRestoreCaret() {
        this.fIncSearchIf.clearSearch();
        this.searchDone(false);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.searchDone(true);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.searchDone(false);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void addObserver(Observer observer) {
        this.fObservable.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.fObservable.deleteObserver(observer);
    }

    public void removeAllObservers() {
        this.fObservable.deleteObservers();
    }

    public void doNotifyObservers(String string) {
        if (!sSearchEnded && string != null) {
            string = this.fSearchForward ? sFIncSearchString + string : sRIncSearchString + string;
            if (this.fLastSearch != null && !this.fLastSearch.getFoundText()) {
                string = sFailingSearchString + string;
            }
        } else {
            string = "";
        }
        this.fObservable.notifyRegisteredObservers(string);
    }

    static {
        sSearchString = "";
        sLastSearchString = "";
        sDeleteSearchString = false;
        sSearchEnded = true;
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.mathworks.widgets.text.resources.RES_text");
        sFIncSearchString = resourceBundle.getString("inc-search-forward");
        sRIncSearchString = resourceBundle.getString("inc-search-backward");
        sFailingSearchString = resourceBundle.getString("inc-search-failing");
    }

    public class ResultObservable
    extends Observable {
        void notifyRegisteredObservers(Object object) {
            this.setChanged();
            this.notifyObservers(object);
            this.clearChanged();
        }
    }
}

