/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJTable;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.spreadsheet.HeaderBorder;
import com.mathworks.widgets.spreadsheet.IHeaderRenderer;
import com.mathworks.widgets.spreadsheet.SpreadsheetColor;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;

public class HeaderRenderer
implements TableCellRenderer,
IHeaderRenderer {
    public static final int TYPE_COLUMN_HEADER = 0;
    public static final int TYPE_ROW_HEADER = 1;
    public static final int TYPE_TOP_LEFT_HEADER = 2;
    public static final int SCHEME_MATLAB = 0;
    public static final int SCHEME_SPREADSHEET = 1;
    public static final int SCHEME_VALUE = 2;
    private Font fDerivedSelected;
    private Font fDerivedUnselected;
    private Font fLabelFont;
    private JLabel fLabel = null;
    private JTable fTable = null;
    private SpreadsheetColor fSpreadsheetColor = null;
    private int fType = -1;
    private int fScheme = -1;
    private Border BORDER_UNSELECTED;
    private Border BORDER_SELECTED;
    private Color TOP_COLUMN_HEADER_COLOR_SELECTED = new Color(230, 230, 230);
    private Color BOTTOM_COLUMNHEADER_COLOR_SELECTED = new Color(200, 200, 200);
    private Color ROW_HEADRER_COLOR_SELECTED = new Color(200, 200, 200);
    private Color TOP_COLUMN_HEADER_COLOR_UNSELECTED = new Color(255, 255, 255);
    private Color BOTTOM_COLUMNHEADER_COLOR_UNSELECTED = new Color(241, 242, 244);
    private Color ROW_HEADRER_COLOR_UNSELECTED = new Color(241, 242, 244);

    public HeaderRenderer(int n, int n2) {
        this(n, n2, 0, null);
    }

    public HeaderRenderer(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public HeaderRenderer(int n, int n2, JTable jTable) {
        this(n, n2, 0, jTable);
    }

    public HeaderRenderer(int n, int n2, int n3, JTable jTable) {
        this.fType = n;
        this.fScheme = n2;
        this.fTable = jTable;
        if (jTable == null) {
            jTable = new MJTable();
        }
        this.fSpreadsheetColor = new SpreadsheetColor(jTable);
        this.fSpreadsheetColor.registerColorInterests();
        if (this.fSpreadsheetColor.useHighContrast()) {
            this.fLabel = new MJLabel("", n3);
            this.fLabel.setOpaque(true);
        } else {
            this.fLabel = new HeaderLabel("", n3);
        }
        this.BORDER_UNSELECTED = n2 == 2 ? null : new HeaderBorder(this.fSpreadsheetColor.getHeaderUnselectedLine());
        this.BORDER_SELECTED = new HeaderBorder(this.fSpreadsheetColor.getHeaderSelectedLine());
    }

    public int getScheme() {
        return this.fScheme;
    }

    @Override
    public int getPreferredWidth(FontMetrics fontMetrics, Object object) {
        return fontMetrics.stringWidth(object.toString()) + (PlatformInfo.isWindows() ? 4 : 6);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JTable jTable2 = jTable;
        if (this.fTable != null) {
            jTable2 = this.fTable;
        }
        switch (this.fType) {
            case 0: {
                this.setLabelState(this.fLabel, jTable2.isColumnSelected(n2), 0);
                switch (this.fScheme) {
                    case 0: {
                        this.fLabel.setText(Integer.toString(n2 + 1));
                        break;
                    }
                    case 1: {
                        this.fLabel.setText(SpreadsheetUtils.getExcelSchemeHeaderLabel(n2));
                        break;
                    }
                    case 2: {
                        if (object == null) break;
                        this.fLabel.setText(object.toString());
                    }
                }
                break;
            }
            case 1: {
                this.setLabelState(this.fLabel, jTable2.isRowSelected(n), 1);
                switch (this.fScheme) {
                    case 0: {
                        this.fLabel.setText(Integer.toString(n + 1));
                        break;
                    }
                    case 1: {
                        this.fLabel.setText(SpreadsheetUtils.getExcelSchemeHeaderLabel(n));
                        break;
                    }
                    case 2: {
                        if (object == null) break;
                        this.fLabel.setText(object.toString());
                    }
                }
                break;
            }
            case 2: {
                this.setLabelState(this.fLabel, jTable2.getSelectedRows().length == jTable2.getRowCount() && jTable2.getSelectedColumns().length == jTable2.getColumnCount(), 2);
            }
        }
        return this.fLabel;
    }

    @Override
    public void setFont(Font font) {
        this.fLabel.setFont(font);
    }

    private void setLabelState(JLabel jLabel, boolean bl, int n) {
        Font font = this.fLabel.getFont();
        if (!font.equals(this.fLabelFont)) {
            this.fLabelFont = font;
            this.fDerivedSelected = null;
        }
        if (this.fDerivedSelected == null) {
            int n2 = font.getSize();
            this.fDerivedSelected = font.deriveFont(n2);
            this.fDerivedUnselected = font.deriveFont(n2);
        }
        jLabel.setBorder(this.BORDER_UNSELECTED);
        if (bl) {
            jLabel.setFont(this.fDerivedSelected);
            jLabel.setForeground(this.fSpreadsheetColor.getHeaderSelectedForeground());
            jLabel.setBackground(this.fSpreadsheetColor.getHeaderSelectedBackground());
            if (jLabel instanceof HeaderLabel) {
                switch (n) {
                    case 0: {
                        ((HeaderLabel)jLabel).setBackgroundColors(this.TOP_COLUMN_HEADER_COLOR_SELECTED, this.BOTTOM_COLUMNHEADER_COLOR_SELECTED);
                        break;
                    }
                    case 1: {
                        ((HeaderLabel)jLabel).setBackgroundColors(this.ROW_HEADRER_COLOR_SELECTED, this.ROW_HEADRER_COLOR_SELECTED);
                    }
                }
            } else {
                jLabel.setBorder(this.BORDER_SELECTED);
            }
        } else {
            jLabel.setFont(this.fDerivedUnselected);
            jLabel.setForeground(this.fSpreadsheetColor.getHeaderUnselectedForeground());
            jLabel.setBackground(this.fSpreadsheetColor.getHeaderUnselectedBackground());
            if (jLabel instanceof HeaderLabel) {
                switch (n) {
                    case 0: {
                        ((HeaderLabel)jLabel).setBackgroundColors(this.TOP_COLUMN_HEADER_COLOR_UNSELECTED, this.BOTTOM_COLUMNHEADER_COLOR_UNSELECTED);
                        break;
                    }
                    case 1: {
                        ((HeaderLabel)jLabel).setBackgroundColors(this.ROW_HEADRER_COLOR_UNSELECTED, this.ROW_HEADRER_COLOR_UNSELECTED);
                    }
                }
            } else {
                jLabel.setBorder(this.BORDER_UNSELECTED);
            }
        }
    }

    @Override
    public Color getPreferredGridColor() {
        return this.fSpreadsheetColor.getHeaderUnselectedLine();
    }

    @Override
    public void cleanup() {
        this.fSpreadsheetColor.setBaseTable(null);
        this.fSpreadsheetColor.unregisterColorInterests();
        this.fSpreadsheetColor = null;
    }

    private class HeaderLabel
    extends JLabel {
        private Color iEndColor;
        private Color iStartColor;

        HeaderLabel(String string, int n) {
            super(string, n);
            this.iEndColor = new Color(241, 242, 244);
            this.iStartColor = new Color(255, 255, 255);
            this.setOpaque(false);
        }

        void setBackgroundColors(Color color, Color color2) {
            this.iStartColor = color;
            this.iEndColor = color2;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            Paint paint = this.isPaintingForPrint() ? this.iStartColor : new GradientPaint(0.0f, 0.0f, this.iStartColor, 0.0f, n2, this.iEndColor, true);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint2 = graphics2D.getPaint();
            graphics2D.setPaint(paint);
            graphics2D.fillRect(0, 0, n, n2);
            graphics2D.setPaint(paint2);
            super.paintComponent(graphics2D);
        }
    }
}

