/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.widgets.spreadsheet.data.ComplexFloatingPointScalar;

public final class ComplexScalarFloat
extends ComplexFloatingPointScalar {
    private final float fR;
    private final float fI;
    private static final ComplexScalarFloat ZERO_REAL = new ComplexScalarFloat(0.0f);
    private static final ComplexScalarFloat NZERO_REAL = new ComplexScalarFloat(0.0f);
    private static final ComplexScalarFloat ONE_REAL = new ComplexScalarFloat(1.0f);
    private static final ComplexScalarFloat ZERO_COMPLEX = new ComplexScalarFloat(0.0f, 0.0f);
    private static final ComplexScalarFloat ONE_COMPLEX = new ComplexScalarFloat(1.0f, 0.0f);
    private static final ComplexScalarFloat I_COMPLEX = new ComplexScalarFloat(0.0f, 1.0f);

    public static ComplexScalarFloat valueOf(float f) {
        if (f == 0.0f) {
            if (1.0f / f == Float.POSITIVE_INFINITY) {
                return ZERO_REAL;
            }
            return NZERO_REAL;
        }
        if (f == 1.0f) {
            return ONE_REAL;
        }
        return new ComplexScalarFloat(f);
    }

    public static ComplexScalarFloat valueOf(float f, float f2) {
        if (f == 0.0f) {
            if (f2 == 1.0f) {
                return I_COMPLEX;
            }
            if (f2 == 0.0f) {
                return ZERO_COMPLEX;
            }
        }
        if (f == 1.0f && f2 == 0.0f) {
            return ONE_COMPLEX;
        }
        return new ComplexScalarFloat(f, f2);
    }

    private ComplexScalarFloat(float f) {
        super(true, true);
        this.fR = f;
        this.fI = 0.0f;
    }

    private ComplexScalarFloat(float f, float f2) {
        super(false, true);
        this.fR = f;
        this.fI = f2;
    }

    @Override
    public long longValueReal() {
        return (long)this.fR;
    }

    @Override
    public long longValueImaginary() {
        return (long)this.fI;
    }

    @Override
    public double doubleValueReal() {
        return this.fR;
    }

    @Override
    public double doubleValueImaginary() {
        return this.fI;
    }
}

