/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.mwswing.datatransfer.MJClipboard;
import com.mathworks.mwswing.datatransfer.MJTransferable;
import com.mathworks.mwswing.datatransfer.RTFStringUtils;
import com.mathworks.util.Log;
import com.mathworks.widgets.STPPrefsManager;
import com.mathworks.widgets.text.ComponentActivator;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.IndentingStyle;
import com.mathworks.widgets.text.MWCaret;
import com.mathworks.widgets.text.MWEditorUI;
import com.mathworks.widgets.text.MWSettingsInitializer;
import com.mathworks.widgets.text.MWToolTipSupport;
import com.mathworks.widgets.text.PrintableDocument;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.STPBaseModelInterface;
import com.mathworks.widgets.text.SmartFormatter;
import com.mathworks.widgets.text.layer.LayerActions;
import com.mathworks.widgets.text.layer.LayerUtils;
import com.mathworks.widgets.text.print.PrintableTextDocument;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.text.AttributedCharacterIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.TextAction;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.ImplementationProvider;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsAdapter;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.editor.ext.ExtUtilities;

public abstract class MWKit
extends ExtKit {
    public static final String killLineAction = "kill-line";
    public static final String clearSelectionAction = "unselect";
    public static final String incSearchForwardAction = "inc-search-forward";
    public static final String incSearchBackwardAction = "inc-search-backward";
    public static final String tabKeyAction = "insert-tab";
    public static final String enterKeyAction = "insert-break";
    public static final String shiftTabKeyAction = "shift-tab-pressed";
    public static final String wrapCommentsAction = "merge-comments";
    public static final String shiftInsertBreakAction = "shift-insert-break";
    private static int sBlockCopySize = 200;
    private static final Settings.Initializer[] sInitializers = new Settings.Initializer[]{new MWSettingsInitializer()};

    public static List<Settings.Initializer> getInitializers() {
        return Collections.unmodifiableList(Arrays.asList(sInitializers));
    }

    public abstract String getContentType();

    public boolean isModifiable() {
        return true;
    }

    public void prepareClone(BaseDocument baseDocument) {
    }

    public Document createDefaultDocument() {
        return new PrintableDocument(((Object)((Object)this)).getClass(), true);
    }

    public Caret createCaret() {
        return new MWCaret();
    }

    protected EditorUI createEditorUI() {
        return new MWEditorUI();
    }

    protected Action[] createActions() {
        Action[] actionArray = new Action[]{new MWBuildPopupMenuAction(), new MWFormatAction(), new KillLineAction(), new ClearSelectionAction(), new IncSearchForwardAction(), new IncSearchBackwardAction(), new MWDefaultKeyTypedAction(), new TabKeyAction(), new ShiftTabKeyAction(), new MWCutAction(), new MWCopyAction(), new MWPasteAction(), new MWShiftLineAction("shift-line-left", false), new MWShiftLineAction("shift-line-right", true), new MWShiftInsertBreakAction(), new MWCommentAction(null), new MWUncommentAction(null), new MWWrapCommentsAction(false), new MWForwardAction("caret-forward", false), new MWForwardAction("selection-forward", true), new MWBackwardAction("caret-backward", false), new MWBackwardAction("selection-backward", true), new MWEnterAction(), new MWUpAction("caret-up", false), new MWUpAction("selection-up", true), new MWDownAction("caret-down", false), new MWDownAction("selection-down", true), new MWPageDownAtion("page-down", false), new MWPageUpAction("page-up", false), new MWAdjustWindowAction("adjust-window-top", true), new MWAdjustWindowAction("adjust-window-bottom", false), new MWCollapseAllFoldsAction(), new MWExpandAllFoldsAction(), new MWBuildToolTipAction(), LayerActions.createOpenMessageAction(), LayerActions.createGoToNextAction(), LayerActions.createGoToPreviousAction()};
        return TextAction.augmentList(super.createActions(), actionArray);
    }

    public final boolean supportSmartIndent() {
        return Formatter.getFormatter(((Object)((Object)this)).getClass()) instanceof SmartFormatter;
    }

    private static void setBlockCopySize(int n) {
        sBlockCopySize = n;
    }

    public static int getBlockSize() {
        return sBlockCopySize;
    }

    private static void setClipboardContents(JTextComponent jTextComponent, Object object) {
        Transferable transferable = MWKit.getTransferable(jTextComponent, object);
        MJClipboard.getMJClipboard().setContents(transferable, null);
    }

    private static CopySelectionValues getSelectionValues(STPBaseInterface sTPBaseInterface) throws BadLocationException {
        int n;
        int n2 = sTPBaseInterface.getSelectionStart();
        int n3 = 0;
        int n4 = sTPBaseInterface.getSelectionEnd();
        int n5 = 0;
        int n6 = sTPBaseInterface.getNumLines() - 1;
        if (n2 != 0) {
            n5 = sTPBaseInterface.getLineFromPos(n2);
            n2 = sTPBaseInterface.getLineStart(n5);
            n3 = sTPBaseInterface.getColFromPos(sTPBaseInterface.getSelectionStart());
        }
        if (n4 != sTPBaseInterface.getLength()) {
            n6 = sTPBaseInterface.getLineFromPos(n4);
            n4 = sTPBaseInterface.getLineEndNoEOL(n6);
            n = sTPBaseInterface.getColFromPos(sTPBaseInterface.getSelectionEnd());
        } else {
            n = sTPBaseInterface.getLineLength(n6);
        }
        return new CopySelectionValues(n2, n4, n3, n, n6 - n5 + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Transferable getTransferable(JTextComponent jTextComponent, Object object) {
        Transferable transferable;
        if (jTextComponent.getDocument() instanceof PrintableTextDocument && jTextComponent instanceof STPBaseInterface) {
            boolean bl = EditorPrefsAccessor.isPrintLineNumbers();
            int n = EditorPrefsAccessor.getPrintOptions();
            try {
                int n2 = 0;
                n2 |= 0x800;
                SettingsAdapter.setValue((Object)object, MWKit.class, (String)"print-line-number-visible", (Object)false);
                STPPrefsManager.getInstance().updatePrintOptions(n2 |= 0x8000, "EditorPrintOptions", EditorPrefsAccessor.getFont());
                PrintableTextDocument printableTextDocument = (PrintableTextDocument)jTextComponent.getDocument();
                CopySelectionValues copySelectionValues = MWKit.getSelectionValues((STPBaseInterface)((Object)jTextComponent));
                printableTextDocument.startingPrinting(copySelectionValues.iStartPos, copySelectionValues.iEndPos);
                int n3 = Math.min(copySelectionValues.iNumLines, sBlockCopySize);
                int n4 = 0;
                LinkedList<AttributedCharacterIterator> linkedList = new LinkedList<AttributedCharacterIterator>();
                while (n3 > 0) {
                    linkedList.addAll(Arrays.asList(printableTextDocument.createPrintIterators(n3)));
                    n3 = Math.min(n3, copySelectionValues.iNumLines - (n4 += n3));
                }
                transferable = MJTransferable.getCombinedTransferable((Transferable[])new Transferable[]{new StringSelection(jTextComponent.getSelectedText()), RTFStringUtils.getTransferable((String)RTFStringUtils.convertCharsToRTF(linkedList, (int)copySelectionValues.iStartToSkip, (int)copySelectionValues.iEndStop, (int)copySelectionValues.iNumLines))});
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
                transferable = new StringSelection(jTextComponent.getSelectedText());
            }
            finally {
                STPPrefsManager.getInstance().updatePrintOptions(n, "EditorPrintOptions", EditorPrefsAccessor.getPrintingBodyFont());
                SettingsAdapter.setValue((Object)object, MWKit.class, (String)"print-line-number-visible", (Object)bl);
            }
        } else {
            transferable = new StringSelection(jTextComponent.getSelectedText());
        }
        return transferable;
    }

    private static void selectIfChanged(int n, int n2, JTextComponent jTextComponent) {
        if (n != jTextComponent.getCaret().getMark() || n2 != jTextComponent.getCaret().getDot()) {
            jTextComponent.setCaretPosition(n);
            jTextComponent.moveCaretPosition(n2);
        }
    }

    public static Action[] createSlashSlashCommentActions() {
        return new Action[]{new MWCommentAction("// "), new MWUncommentAction("// ", "//")};
    }

    private static void scrollToPostFoldActionCaretPosition(JTextComponent jTextComponent) {
        Rectangle rectangle = Utilities.getEditorUI((JTextComponent)jTextComponent).getExtentBounds();
        int n = jTextComponent.getCaret().getDot();
        try {
            Rectangle rectangle2 = jTextComponent.getUI().modelToView(jTextComponent, n, Position.Bias.Forward);
            if (rectangle != null && rectangle2 != null && !rectangle.contains(rectangle2)) {
                jTextComponent.setCaretPosition(n);
                Utilities.getEditorUI((JTextComponent)jTextComponent).adjustWindow(50);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private static void doBraceMatch(JTextComponent jTextComponent, boolean bl) {
        if (jTextComponent.getCaret() instanceof MWCaret) {
            int n;
            int n2 = n = bl ? jTextComponent.getCaret().getDot() + 1 : jTextComponent.getCaret().getDot();
            if (n <= jTextComponent.getDocument().getLength()) {
                ((MWCaret)((Object)jTextComponent.getCaret())).updateMatchBrace(false, n);
            }
        }
    }

    private static MWToolTipSupport getToolTipSupport(JTextComponent jTextComponent) {
        return (MWToolTipSupport)ExtUtilities.getExtEditorUI((JTextComponent)jTextComponent).getToolTipSupport();
    }

    private static boolean forwardStroke(ActionEvent actionEvent, JTextComponent jTextComponent, String string) {
        MWToolTipSupport mWToolTipSupport = MWKit.getToolTipSupport(jTextComponent);
        return mWToolTipSupport.shouldAcceptKeyStroke() && mWToolTipSupport.keyControlKeyPressed(actionEvent, string);
    }

    static {
        STPPrefsManager.getInstance();
        ImplementationProvider.registerDefault((ImplementationProvider)new ImplProvider());
    }

    public static class MWBuildToolTipAction
    extends ExtKit.BuildToolTipAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            List<? extends EditorMessage> list = LayerUtils.getMessagesUnderMouse(jTextComponent);
            if (!list.isEmpty()) {
                MWKit.getToolTipSupport(jTextComponent).makeTipAtMouse(list, jTextComponent);
            } else {
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }
    }

    public static class MWPageUpAction
    extends BaseKit.PageUpAction {
        private static final String ID = "page-up";

        public MWPageUpAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!MWKit.forwardStroke(actionEvent, jTextComponent, ID)) {
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }
    }

    public static class MWPageDownAtion
    extends BaseKit.PageDownAction {
        private static final String ID = "page-down";

        public MWPageDownAtion(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!MWKit.forwardStroke(actionEvent, jTextComponent, ID)) {
                super.actionPerformed(actionEvent, jTextComponent);
            }
        }
    }

    public static interface InstancesNotEqual {
        public boolean areIdentical(InstancesNotEqual var1);
    }

    public static class MWAdjustWindowAction
    extends BaseAction {
        private boolean iScrollToTop;

        public MWAdjustWindowAction(String string, boolean bl) {
            super(string);
            this.iScrollToTop = bl;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
                Rectangle rectangle = editorUI.getExtentBounds();
                rectangle.y = this.iScrollToTop ? 0 : jTextComponent.getHeight() - rectangle.height;
                jTextComponent.scrollRectToVisible(rectangle);
            }
        }
    }

    public static class MWDownAction
    extends BaseKit.DownAction {
        private static final String ID = "caret-down";

        public MWDownAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!MWKit.forwardStroke(actionEvent, jTextComponent, ID)) {
                super.actionPerformed(actionEvent, jTextComponent);
                MWKit.doBraceMatch(jTextComponent, false);
            }
        }
    }

    public static class MWEnterAction
    extends BaseKit.InsertBreakAction {
        public MWEnterAction() {
            this.putValue("Name", MWKit.enterKeyAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            super.actionPerformed(actionEvent, jTextComponent);
        }
    }

    public static class MWUpAction
    extends BaseKit.UpAction {
        private static final String ID = "caret-up";

        public MWUpAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (!MWKit.forwardStroke(actionEvent, jTextComponent, ID)) {
                super.actionPerformed(actionEvent, jTextComponent);
                MWKit.doBraceMatch(jTextComponent, false);
            }
        }
    }

    public static class MWBackwardAction
    extends BaseKit.BackwardAction {
        public MWBackwardAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            super.actionPerformed(actionEvent, jTextComponent);
            MWKit.doBraceMatch(jTextComponent, true);
        }
    }

    public static class MWForwardAction
    extends BaseKit.ForwardAction {
        public MWForwardAction(String string, boolean bl) {
            super(string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            super.actionPerformed(actionEvent, jTextComponent);
            MWKit.doBraceMatch(jTextComponent, false);
        }
    }

    public static class MWExpandAllFoldsAction
    extends ActionFactory.ExpandAllFolds {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                super.actionPerformed(actionEvent, jTextComponent);
                MWKit.scrollToPostFoldActionCaretPosition(jTextComponent);
            }
        }
    }

    public static class MWCollapseAllFoldsAction
    extends ActionFactory.CollapseAllFolds {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                super.actionPerformed(actionEvent, jTextComponent);
                MWKit.scrollToPostFoldActionCaretPosition(jTextComponent);
            }
        }
    }

    public static class MWWrapCommentsAction
    extends BaseAction {
        private final boolean fEnabled;

        public MWWrapCommentsAction(boolean bl) {
            super(MWKit.wrapCommentsAction);
            this.fEnabled = bl;
        }

        public boolean isEnabled() {
            return this.fEnabled;
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            assert (false) : "Shouldn't get here; if enabled, subclasses should provide implementation";
        }
    }

    public static class MWUncommentAction
    extends ExtKit.UncommentAction
    implements InstancesNotEqual {
        private final String fPreferredCommentString;
        private final String fAlternateCommentString;

        public MWUncommentAction(String string) {
            this(string, null);
        }

        public MWUncommentAction(String string, String string2) {
            super(string);
            this.fPreferredCommentString = string;
            this.fAlternateCommentString = string2;
        }

        public boolean isEnabled() {
            return this.fPreferredCommentString != null && super.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block24: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled() || this.fPreferredCommentString == null) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    int n = this.fPreferredCommentString.length();
                    int n2 = -1;
                    if (this.fAlternateCommentString != null) {
                        n2 = this.fAlternateCommentString.length();
                    }
                    try {
                        if (caret.isSelectionVisible()) {
                            int n3 = jTextComponent.getSelectionStart();
                            int n4 = jTextComponent.getSelectionEnd();
                            if (n4 > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n4) == n4) {
                                --n4;
                            }
                            int n5 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3);
                            int n6 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4);
                            if (baseDocument instanceof PrintableDocument) {
                                ((PrintableDocument)baseDocument).startEditGrouping();
                            } else {
                                baseDocument.atomicLock();
                            }
                            try {
                                for (int i = n5; i <= n6; ++i) {
                                    int n7;
                                    int n8 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                                    int n9 = Utilities.getFirstNonWhiteFwd((BaseDocument)baseDocument, (int)n8, (int)(n7 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n8)));
                                    if (n9 == -1) continue;
                                    if (n7 - n9 + 1 >= n && baseDocument.getText(n9, n).equals(this.fPreferredCommentString)) {
                                        baseDocument.remove(n9, n);
                                        continue;
                                    }
                                    if (n2 == -1 || n7 - n9 + 1 < n2 || !baseDocument.getText(n9, n2).equals(this.fAlternateCommentString)) continue;
                                    baseDocument.remove(n9, n2);
                                }
                                break block24;
                            }
                            finally {
                                if (baseDocument instanceof PrintableDocument) {
                                    ((PrintableDocument)baseDocument).endEditGrouping();
                                } else {
                                    baseDocument.atomicUnlock();
                                }
                                if (n6 > n5) {
                                    if (Utilities.getRowCount((BaseDocument)baseDocument) - 1 > n6) {
                                        jTextComponent.select(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n5), Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n6 + 1)));
                                    } else {
                                        jTextComponent.select(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n5), baseDocument.getLength());
                                    }
                                }
                            }
                        }
                        int n10 = Utilities.getRowStart((JTextComponent)jTextComponent, (int)caret.getDot());
                        int n11 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)caret.getDot());
                        n10 = n10 == -1 ? Utilities.getRowStart((BaseDocument)baseDocument, (int)caret.getDot()) : n10;
                        n11 = n11 == -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)caret.getDot()) : n11;
                        int n12 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n10);
                        int n13 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n11);
                        baseDocument.atomicLock();
                        try {
                            for (int i = n12; i <= n13; ++i) {
                                int n14 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                                int n15 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n14);
                                if (n15 == -1) continue;
                                int n16 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n15);
                                int n17 = n16 = n16 == -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)n15) : n16;
                                if (n16 - n15 >= n && baseDocument.getText(n15, n).equals(this.fPreferredCommentString)) {
                                    baseDocument.remove(n15, n);
                                    continue;
                                }
                                if (n2 == -1 || n16 - n15 < n2 || !baseDocument.getText(n15, n2).equals(this.fAlternateCommentString)) continue;
                                baseDocument.remove(n15, n2);
                            }
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }

        @Override
        public boolean areIdentical(InstancesNotEqual instancesNotEqual) {
            if (!(instancesNotEqual instanceof MWUncommentAction)) {
                return false;
            }
            MWUncommentAction mWUncommentAction = (MWUncommentAction)instancesNotEqual;
            if (mWUncommentAction.fPreferredCommentString == null ? this.fPreferredCommentString != null : !mWUncommentAction.fPreferredCommentString.equals(this.fPreferredCommentString)) {
                return false;
            }
            return !(mWUncommentAction.fAlternateCommentString == null ? this.fAlternateCommentString != null : !mWUncommentAction.fAlternateCommentString.equals(this.fAlternateCommentString));
        }
    }

    public static class MWCommentAction
    extends ExtKit.CommentAction
    implements InstancesNotEqual {
        private final String fCommentString;

        public MWCommentAction(String string) {
            super(string);
            this.fCommentString = string;
        }

        public boolean isEnabled() {
            return this.fCommentString != null && super.isEnabled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block21: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled() || this.fCommentString == null) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    Caret caret = jTextComponent.getCaret();
                    BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                    try {
                        if (caret.isSelectionVisible()) {
                            int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                            int n2 = jTextComponent.getSelectionEnd();
                            if (n2 > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) == n2) {
                                --n2;
                            }
                            int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
                            int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2);
                            if (baseDocument instanceof PrintableDocument) {
                                ((PrintableDocument)baseDocument).startEditGrouping();
                            } else {
                                baseDocument.atomicLock();
                            }
                            try {
                                for (int i = n3; i <= n4; ++i) {
                                    baseDocument.insertString(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i), this.fCommentString, null);
                                }
                                break block21;
                            }
                            finally {
                                if (baseDocument instanceof PrintableDocument) {
                                    ((PrintableDocument)baseDocument).endEditGrouping();
                                } else {
                                    baseDocument.atomicUnlock();
                                }
                                if (n4 > n3) {
                                    if (Utilities.getRowCount((BaseDocument)baseDocument) - 1 > n4) {
                                        jTextComponent.select(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n3), Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n4 + 1)));
                                    } else {
                                        jTextComponent.select(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n3), baseDocument.getLength());
                                    }
                                }
                            }
                        }
                        int n = Utilities.getRowStart((JTextComponent)jTextComponent, (int)caret.getDot());
                        int n5 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)caret.getDot());
                        n = n == -1 ? Utilities.getRowStart((BaseDocument)baseDocument, (int)caret.getDot()) : n;
                        n5 = n5 == -1 ? Utilities.getRowEnd((BaseDocument)baseDocument, (int)caret.getDot()) : n5;
                        int n6 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
                        int n7 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n5);
                        baseDocument.atomicLock();
                        try {
                            for (int i = n6; i <= n7; ++i) {
                                int n8 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)i);
                                if (n8 == -1) continue;
                                baseDocument.insertString(n8, this.fCommentString, null);
                            }
                        }
                        finally {
                            baseDocument.atomicUnlock();
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                        jTextComponent.getToolkit().beep();
                    }
                }
            }
        }

        @Override
        public boolean areIdentical(InstancesNotEqual instancesNotEqual) {
            if (!(instancesNotEqual instanceof MWCommentAction)) {
                return false;
            }
            MWCommentAction mWCommentAction = (MWCommentAction)instancesNotEqual;
            return !(mWCommentAction.fCommentString == null ? this.fCommentString != null : !mWCommentAction.fCommentString.equals(this.fCommentString));
        }
    }

    public static class MWShiftInsertBreakAction
    extends BaseAction {
        public MWShiftInsertBreakAction() {
            super(MWKit.shiftInsertBreakAction, 6);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (MWKit.forwardStroke(actionEvent, jTextComponent, MWKit.shiftInsertBreakAction)) {
                return;
            }
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    return;
                }
                jTextComponent.replaceSelection("\n");
            }
        }
    }

    public static class IncSearchBackwardAction
    extends BaseAction {
        public IncSearchBackwardAction() {
            super(MWKit.incSearchBackwardAction, 14);
            this.putValue("helpID", IncSearchBackwardAction.class.getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && jTextComponent instanceof STPBaseInterface) {
                STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
                sTPBaseInterface.startIncSearch(false);
            }
        }
    }

    public static class IncSearchForwardAction
    extends BaseAction {
        public IncSearchForwardAction() {
            super(MWKit.incSearchForwardAction, 14);
            this.putValue("helpID", IncSearchForwardAction.class.getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && jTextComponent instanceof STPBaseInterface) {
                STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
                sTPBaseInterface.startIncSearch(true);
            }
        }
    }

    public static class ClearSelectionAction
    extends BaseAction {
        public ClearSelectionAction() {
            super(MWKit.clearSelectionAction, 14);
            this.putValue("helpID", ClearSelectionAction.class.getName());
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                jTextComponent.select(jTextComponent.getCaret().getDot(), jTextComponent.getCaret().getDot());
            }
        }
    }

    public static class KillLineAction
    extends BaseAction {
        private String fLastText;
        private int fLastIndex;
        private JTextComponent fLastTarget;
        private boolean fInTheMiddleofKillAction;

        public KillLineAction() {
            super(MWKit.killLineAction, 14);
            this.putValue("helpID", KillLineAction.class.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                    jTextComponent.getToolkit().beep();
                    return;
                }
                this.fInTheMiddleofKillAction = true;
                Caret caret = jTextComponent.getCaret();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                baseDocument.atomicLock();
                try {
                    Object object;
                    int n;
                    int n2 = caret.getDot();
                    int n3 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n2);
                    if (n2 == n3 && (n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n2)) < Utilities.getRowCount((BaseDocument)baseDocument) - 1) {
                        n3 = Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n + 1));
                    }
                    String string = jTextComponent.getText(n2, n3 - n2);
                    boolean bl = false;
                    if (jTextComponent.equals(this.fLastTarget) && n2 == this.fLastIndex) {
                        try {
                            Transferable transferable = MJClipboard.getMJClipboard().getContents((Object)this);
                            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor) && (object = (String)transferable.getTransferData(DataFlavor.stringFlavor)) != null && ((String)object).equals(this.fLastText)) {
                                MJClipboard.getMJClipboard().setContents((String)object + string, null);
                                this.fLastText = (String)object + string;
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (bl) {
                        baseDocument.remove(n2, n3 - n2);
                    } else {
                        jTextComponent.select(n2, n3);
                        boolean bl2 = false;
                        if (jTextComponent instanceof JEditorPane && (object = ((BaseKit)((JEditorPane)jTextComponent).getEditorKit()).getActionByName("cut-to-clipboard")) != null) {
                            object.actionPerformed(new ActionEvent(jTextComponent, 0, null));
                            bl2 = true;
                        }
                        if (!bl2) {
                            jTextComponent.cut();
                        }
                        this.fLastText = string;
                    }
                    this.fLastIndex = jTextComponent.getCaretPosition();
                    this.fLastTarget = jTextComponent;
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
                finally {
                    baseDocument.atomicUnlock();
                }
                this.fInTheMiddleofKillAction = false;
            }
        }

        public void resetClipboardAccumulation() {
            if (!this.fInTheMiddleofKillAction) {
                this.fLastIndex = -1;
            }
        }
    }

    public static class MWFormatAction
    extends ActionFactory.FormatAction {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
                if (baseKit instanceof MWKit && !((MWKit)baseKit).supportSmartIndent()) {
                    return;
                }
                int n = jTextComponent.getSelectionStart();
                int n2 = jTextComponent.getSelectionEnd();
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                IndentingStyle indentingStyle = null;
                SmartFormatter smartFormatter = null;
                if (baseKit instanceof MWKit && ((MWKit)baseKit).supportSmartIndent()) {
                    smartFormatter = (SmartFormatter)baseDocument.getFormatter();
                    indentingStyle = smartFormatter.getFormattingType();
                    smartFormatter.setFormattingType(IndentingStyle.SMART);
                }
                try {
                    if (n == n2 && Utilities.isRowWhite((BaseDocument)baseDocument, (int)n)) {
                        n = baseDocument.getFormatter().indentLine((Document)baseDocument, n);
                        jTextComponent.getCaret().setDot(n);
                    } else {
                        boolean bl;
                        boolean bl2 = bl = n == n2;
                        if (!bl && n2 == Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) && n2 > 0) {
                            --n2;
                        }
                        Position position = baseDocument.createPosition(n);
                        Position position2 = baseDocument.createPosition(n2);
                        boolean bl3 = jTextComponent.getCaretPosition() > jTextComponent.getCaret().getMark();
                        int n3 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
                        int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2);
                        if (n3 != n || n4 != n2) {
                            jTextComponent.select(n3, Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4));
                        }
                        jTextComponent.getCaret().setSelectionVisible(true);
                        super.actionPerformed(actionEvent, jTextComponent);
                        if (bl) {
                            jTextComponent.setCaretPosition(position.getOffset());
                        } else if (!bl3) {
                            MWKit.selectIfChanged(position2.getOffset(), position.getOffset(), jTextComponent);
                        } else {
                            MWKit.selectIfChanged(position.getOffset(), position2.getOffset(), jTextComponent);
                        }
                    }
                    if (smartFormatter != null) {
                        smartFormatter.setFormattingType(indentingStyle);
                    }
                }
                catch (BadLocationException badLocationException) {
                    try {
                        Log.logException((Exception)badLocationException);
                        if (smartFormatter != null) {
                            smartFormatter.setFormattingType(indentingStyle);
                        }
                    }
                    catch (Throwable throwable) {
                        if (smartFormatter != null) {
                            smartFormatter.setFormattingType(indentingStyle);
                        }
                        throw throwable;
                    }
                }
            }
        }
    }

    public static class MWCutAction
    extends BaseKit.CutAction {
        public MWCutAction() {
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && jTextComponent.getCaret().isSelectionVisible()) {
                MWKit.setClipboardContents(jTextComponent, (Object)this);
                jTextComponent.replaceSelection("");
            }
        }
    }

    public static class CopySelectionValues {
        public final int iStartPos;
        public final int iEndPos;
        public final int iStartToSkip;
        public final int iEndStop;
        public final int iNumLines;

        private CopySelectionValues(int n, int n2, int n3, int n4, int n5) {
            this.iStartPos = n;
            this.iEndPos = n2;
            this.iStartToSkip = n3;
            this.iEndStop = n4;
            this.iNumLines = n5;
        }
    }

    public static class MWCopyAction
    extends BaseKit.CopyAction {
        public MWCopyAction() {
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null && jTextComponent.getCaret().isSelectionVisible()) {
                MWKit.setClipboardContents(jTextComponent, (Object)this);
            }
        }
    }

    public static class MWPasteAction
    extends BaseKit.PasteAction {
        public MWPasteAction() {
            super(false);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                try {
                    Transferable transferable = MJClipboard.getMJClipboard().getContents((Object)this);
                    if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        jTextComponent.replaceSelection(string);
                    } else {
                        super.actionPerformed(actionEvent, jTextComponent);
                    }
                }
                catch (Exception exception) {
                    Log.logException((Exception)exception);
                }
            }
        }
    }

    public static class MWBuildPopupMenuAction
    extends ExtKit.BuildPopupMenuAction {
        protected JPopupMenu buildPopupMenu(JTextComponent jTextComponent) {
            jTextComponent.requestFocusInWindow();
            if (jTextComponent instanceof STPBaseModelInterface) {
                return ((STPBaseModelInterface)((Object)jTextComponent)).getContextMenu();
            }
            return super.buildPopupMenu(jTextComponent);
        }
    }

    public static class MWDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            super.actionPerformed(actionEvent, jTextComponent);
            if (jTextComponent != null && jTextComponent.getCaret() instanceof MWCaret) {
                char c;
                String string = actionEvent.getActionCommand();
                int n = actionEvent.getModifiers();
                if (string != null && string.length() == 1 && (n & 2) == 0 && !Character.isISOControl(c = string.charAt(0)) && jTextComponent.getCaretPosition() > 0) {
                    ((MWCaret)((Object)jTextComponent.getCaret())).doDelimiterMatch(c, jTextComponent.getCaretPosition() - 1);
                }
            }
        }
    }

    public static class MWShiftLineAction
    extends ActionFactory.ShiftLineAction {
        public MWShiftLineAction(String string, boolean bl) {
            super(string, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            block13: {
                if (jTextComponent != null) {
                    if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                        jTextComponent.getToolkit().beep();
                        return;
                    }
                    try {
                        BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                        Caret caret = jTextComponent.getCaret();
                        if (baseDocument instanceof PrintableDocument) {
                            int n = -1;
                            int n2 = -1;
                            try {
                                ((PrintableDocument)baseDocument).startEditGrouping();
                                int n3 = Math.min(caret.getDot(), caret.getMark());
                                int n4 = Math.max(caret.getDot(), caret.getMark());
                                if (n4 == Utilities.getRowStart((BaseDocument)baseDocument, (int)n4) && n4 > n3) {
                                    --n4;
                                }
                                n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n3);
                                n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n4);
                                super.actionPerformed(actionEvent, jTextComponent);
                            }
                            finally {
                                ((PrintableDocument)baseDocument).endEditGrouping();
                            }
                            if (n != -1 && n2 != -1 && n != n2) {
                                jTextComponent.setSelectionStart(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n));
                                if (n2 < Utilities.getRowCount((BaseDocument)baseDocument) - 1) {
                                    jTextComponent.setSelectionEnd(Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)(n2 + 1)));
                                } else {
                                    jTextComponent.setSelectionEnd(Utilities.getRowEnd((BaseDocument)baseDocument, (int)Utilities.getRowStartFromLineOffset((BaseDocument)baseDocument, (int)n2)));
                                }
                            }
                            break block13;
                        }
                        super.actionPerformed(actionEvent, jTextComponent);
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                    }
                }
            }
        }
    }

    public static class ShiftTabKeyAction
    extends ActionFactory.ShiftLineAction {
        public ShiftTabKeyAction() {
            super(MWKit.shiftTabKeyAction, false);
            this.putValue("Name", MWKit.shiftTabKeyAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (((Boolean)Settings.getValue((Class)Utilities.getDocument((JTextComponent)jTextComponent).getKitClass(), (String)"emacs-smart-tab")).booleanValue()) {
                    Toolkit.getDefaultToolkit().beep();
                } else {
                    Caret caret = jTextComponent.getCaret();
                    if (caret.isSelectionVisible()) {
                        super.actionPerformed(actionEvent, jTextComponent);
                    } else {
                        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                        try {
                            int n = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)caret.getDot());
                            if (n == -1 || n >= caret.getDot()) {
                                super.actionPerformed(actionEvent, jTextComponent);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Log.logException((Exception)badLocationException);
                        }
                    }
                }
            }
        }
    }

    public static class TabKeyAction
    extends BaseKit.InsertTabAction {
        public TabKeyAction() {
            this.putValue("Name", MWKit.tabKeyAction);
        }

        public void actionPerformed(ActionEvent actionEvent, JTextComponent jTextComponent) {
            if (jTextComponent != null) {
                if (((Boolean)Settings.getValue((Class)Utilities.getDocument((JTextComponent)jTextComponent).getKitClass(), (String)"emacs-smart-tab")).booleanValue()) {
                    ((BaseAction)Utilities.getKit((JTextComponent)jTextComponent).getActionByName("format")).actionPerformed(actionEvent, jTextComponent);
                } else {
                    BaseDocument baseDocument = Utilities.getDocument((JTextComponent)jTextComponent);
                    boolean bl = true;
                    if (baseDocument != null && jTextComponent.getCaret().isSelectionVisible()) {
                        try {
                            if (Utilities.getLineOffset((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart()) == Utilities.getLineOffset((BaseDocument)baseDocument, (int)jTextComponent.getSelectionEnd())) {
                                jTextComponent.replaceSelection("\t");
                                bl = false;
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            Log.logException((Exception)badLocationException);
                        }
                    }
                    if (bl) {
                        super.actionPerformed(actionEvent, jTextComponent);
                    }
                }
            }
        }
    }

    private static class ImplProvider
    extends ImplementationProvider {
        private ImplProvider() {
        }

        public Action[] getGlyphGutterActions(JTextComponent jTextComponent) {
            return null;
        }

        public ResourceBundle getResourceBundle(String string) {
            return ResourceBundle.getBundle(string);
        }

        public boolean activateComponent(JTextComponent jTextComponent) {
            ComponentActivator componentActivator = (ComponentActivator)jTextComponent.getClientProperty("ComponentActivator");
            boolean bl = false;
            if (componentActivator != null) {
                bl = componentActivator.activateComponent(jTextComponent);
            }
            if (!bl) {
                Component component = SwingUtilities.getRoot(jTextComponent);
                if (component != null && component instanceof Window && !((Window)component).isFocused()) {
                    ((Window)component).toFront();
                }
                bl = jTextComponent.requestFocusInWindow();
            }
            return bl;
        }
    }
}

