/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.fold;

import com.mathworks.mwswing.WrapperAction;
import com.mathworks.widgets.text.ErrorLogger;
import com.mathworks.widgets.text.MWEditorUIUtils;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.ViewHierarchyChangeEvent;
import com.mathworks.widgets.text.ViewHierarchyChangeListener;
import com.mathworks.widgets.text.ViewHierarchyModificationComponent;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.CodeFoldingSideBar;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;

public class MWCodeFoldingSideBar
extends CodeFoldingSideBar
implements ViewHierarchyModificationComponent {
    private final List<ViewHierarchyChangeListener> viewHierarchyListeners = new ArrayList<ViewHierarchyChangeListener>();
    private FoldingSideBarMouseListener gutterListener;
    private ViewHierarchyChangeNotifier viewHierarchyChangeNotifier;
    private static final ErrorLogger LOGGER = ErrorLogger.getLogger();
    public static final String COMP_NAME = "MWCodeFoldingSideBar";

    public MWCodeFoldingSideBar() {
        this.setName(COMP_NAME);
    }

    public MWCodeFoldingSideBar(JTextComponent jTextComponent) {
        super(jTextComponent);
        this.gutterListener = new FoldingSideBarMouseListener();
        this.addMouseListener(this.gutterListener);
        this.addMouseMotionListener(this.gutterListener);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
        this.viewHierarchyChangeNotifier = new ViewHierarchyChangeNotifier();
        if (foldHierarchy != null) {
            foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)this.viewHierarchyChangeNotifier);
        }
        this.setName(COMP_NAME);
    }

    @Override
    public void addViewHierarchyChangeListener(ViewHierarchyChangeListener viewHierarchyChangeListener) {
        if (viewHierarchyChangeListener != null && this.viewHierarchyListeners != null) {
            this.viewHierarchyListeners.add(viewHierarchyChangeListener);
        }
    }

    @Override
    public void removeViewHierarchyChangeListener(ViewHierarchyChangeListener viewHierarchyChangeListener) {
        if (viewHierarchyChangeListener != null && this.viewHierarchyListeners != null) {
            this.viewHierarchyListeners.remove(viewHierarchyChangeListener);
        }
    }

    private ViewHierarchyChangeEvent createViewHierarchyChangeEvent(FoldHierarchyEvent foldHierarchyEvent) {
        return new ViewHierarchyChangeEvent(this.component, "FoldHierarchy", foldHierarchyEvent.getSource());
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        FoldHierarchy foldHierarchy;
        Document document;
        Class clazz;
        Boolean bl = null;
        if ((settingsChangeEvent == null || settingsChangeEvent.getSettingName().equals("code-folding-enable")) && this.component != null && this.component.getDocument() != null && !(bl = (Boolean)Settings.getValue((Class)(clazz = (document = this.component.getDocument()) instanceof BaseDocument ? Utilities.getKitClass((JTextComponent)this.component) : BaseKit.class), (String)"code-folding-enable")).booleanValue() && settingsChangeEvent != null && clazz == settingsChangeEvent.getKitClass() && (foldHierarchy = FoldHierarchy.get((JTextComponent)this.component)) != null) {
            FoldUtilities.expandAll((FoldHierarchy)foldHierarchy);
        }
        super.settingsChange(settingsChangeEvent);
        if (bl != null) {
            this.setVisible(bl);
            this.disableFoldActions(bl == false, this.component);
            this.enableCodeFoldingMenuAction(bl);
        }
    }

    public void validateCodeFoldPopupMenuActions(JTextComponent jTextComponent) {
        this.validateCodeFoldActions(jTextComponent);
    }

    public void validateColdFoldActions() {
        this.validateCodeFoldActions(this.component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCodeFoldActions(JTextComponent jTextComponent) {
        if (jTextComponent != null && jTextComponent.getDocument() != null && jTextComponent.getDocument() instanceof BaseDocument) {
            BaseKit baseKit = Utilities.getKit((JTextComponent)jTextComponent);
            boolean bl = (Boolean)Settings.getValue(baseKit.getClass(), (String)"code-folding-enable");
            if (baseKit instanceof ExtKit && ((ExtKit)baseKit).isCodeFoldingEnabled() && bl) {
                FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
                int n = jTextComponent.getCaret().getDot();
                if (foldHierarchy != null) {
                    int n2;
                    foldHierarchy.lock();
                    try {
                        Fold fold = foldHierarchy.getRootFold();
                        n2 = fold.getFoldCount();
                        if (n2 == 0) {
                            this.disableFoldActions(true, this.component);
                            return;
                        }
                    }
                    finally {
                        foldHierarchy.unlock();
                    }
                    try {
                        int n3 = Utilities.getRowStart((JTextComponent)jTextComponent, (int)n);
                        n2 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)n);
                        Fold fold = this.getPossibleFoldAtLine(foldHierarchy, n, n3, n2);
                        if (fold != null) {
                            int n4 = Utilities.getRowStart((JTextComponent)jTextComponent, (int)fold.getStartOffset());
                            int n5 = Utilities.getRowEnd((JTextComponent)jTextComponent, (int)fold.getEndOffset());
                            if (n4 > n || n5 < n) {
                                return;
                            }
                            this.disableCollapseAction(fold.isCollapsed(), this.component);
                        } else {
                            this.disableCollapseAndExpandAction(true, this.component);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        this.disableFoldActions(false, this.component);
                        LOGGER.nbDebugLog(badLocationException);
                    }
                    foldHierarchy.lock();
                    try {
                        if (this.getAllFoldsCollapsedStatus(foldHierarchy.getRootFold())) {
                            this.disableCollapseAllAction(true, this.component);
                        }
                        if (this.getAllFoldsExpandedStatus(foldHierarchy.getRootFold())) {
                            this.disableCollapseAllAction(false, this.component);
                        }
                        this.disableCollapseAllAndExpandAllAction(false, this.component);
                    }
                    finally {
                        foldHierarchy.unlock();
                    }
                }
            } else {
                this.disableFoldActions(true, this.component);
            }
        }
    }

    @Override
    public void cleanup() {
        FoldHierarchy foldHierarchy;
        if (this.component != null && (foldHierarchy = FoldHierarchy.get((JTextComponent)this.component)) != null && this.viewHierarchyChangeNotifier != null) {
            foldHierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this.viewHierarchyChangeNotifier);
            this.viewHierarchyChangeNotifier = null;
        }
        if (this.gutterListener != null) {
            this.removeMouseListener(this.gutterListener);
            this.removeMouseMotionListener(this.gutterListener);
            this.gutterListener = null;
        }
        this.viewHierarchyListeners.clear();
        Settings.removeSettingsChangeListener((SettingsChangeListener)this);
    }

    private void enableCodeFoldingMenuAction(boolean bl) {
        if (this.component instanceof STPBaseInterface) {
            ((STPBaseInterface)((Object)this.component)).getCodeFoldingMenuAction().setEnabled(bl);
        }
    }

    private void disableFoldActions(boolean bl, JTextComponent jTextComponent) {
        if (jTextComponent != null && jTextComponent instanceof STPBaseInterface) {
            STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
            if (sTPBaseInterface.getCollapseAllFoldsAction() != null) {
                ((WrapperAction)sTPBaseInterface.getCollapseAllFoldsAction()).setWrapperDisable(bl);
            }
            if (sTPBaseInterface.getCollapseFoldAction() != null) {
                ((WrapperAction)sTPBaseInterface.getCollapseFoldAction()).setWrapperDisable(bl);
            }
            if (sTPBaseInterface.getExpandAllFoldsAction() != null) {
                ((WrapperAction)sTPBaseInterface.getExpandAllFoldsAction()).setWrapperDisable(bl);
            }
            if (sTPBaseInterface.getExpandFoldAction() != null) {
                ((WrapperAction)sTPBaseInterface.getExpandFoldAction()).setWrapperDisable(bl);
            }
        }
    }

    private void disableCollapseAction(boolean bl, JTextComponent jTextComponent) {
        if (jTextComponent != null && jTextComponent instanceof STPBaseInterface) {
            STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
            ((WrapperAction)sTPBaseInterface.getCollapseFoldAction()).setWrapperDisable(bl);
            ((WrapperAction)sTPBaseInterface.getExpandFoldAction()).setWrapperDisable(!bl);
        }
    }

    private void disableCollapseAndExpandAction(boolean bl, JTextComponent jTextComponent) {
        if (jTextComponent != null && jTextComponent instanceof STPBaseInterface) {
            STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
            ((WrapperAction)sTPBaseInterface.getCollapseFoldAction()).setWrapperDisable(bl);
            ((WrapperAction)sTPBaseInterface.getExpandFoldAction()).setWrapperDisable(bl);
        }
    }

    private void disableCollapseAllAction(boolean bl, JTextComponent jTextComponent) {
        if (jTextComponent != null && jTextComponent instanceof STPBaseInterface) {
            STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
            ((WrapperAction)sTPBaseInterface.getCollapseAllFoldsAction()).setWrapperDisable(bl);
            ((WrapperAction)sTPBaseInterface.getExpandAllFoldsAction()).setWrapperDisable(!bl);
        }
    }

    private void disableCollapseAllAndExpandAllAction(boolean bl, JTextComponent jTextComponent) {
        if (jTextComponent != null && jTextComponent instanceof STPBaseInterface) {
            STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)jTextComponent);
            ((WrapperAction)sTPBaseInterface.getCollapseAllFoldsAction()).setWrapperDisable(bl);
            ((WrapperAction)sTPBaseInterface.getExpandAllFoldsAction()).setWrapperDisable(bl);
        }
    }

    private boolean getAllFoldsExpandedStatus(Fold fold) {
        boolean bl;
        boolean bl2 = bl = !fold.isCollapsed();
        if (!bl) {
            return bl;
        }
        int n = fold.getFoldCount();
        for (int i = 0; i < n; ++i) {
            Fold fold2 = fold.getFold(i);
            bl = this.getAllFoldsExpandedStatus(fold2);
            if (bl) continue;
            return bl;
        }
        return bl;
    }

    private boolean getAllFoldsCollapsedStatus(Fold fold) {
        int n = fold.getFoldCount();
        for (int i = 0; i < n; ++i) {
            Fold fold2 = fold.getFold(i);
            if (fold2.isCollapsed()) continue;
            return false;
        }
        return true;
    }

    private Fold getPossibleFoldAtLine(FoldHierarchy foldHierarchy, int n, int n2, int n3) {
        Fold fold;
        Fold fold2 = FoldUtilities.findOffsetFold((FoldHierarchy)foldHierarchy, (int)n);
        Fold fold3 = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)n2);
        while (fold3 != null && (fold3.getEndOffset() <= n || !fold3.isCollapsed() && fold3.getFoldCount() > 0 && fold3.getStartOffset() + 1 < n) && (fold = FoldUtilities.findNearestFold((FoldHierarchy)foldHierarchy, (int)(fold3.getFoldCount() > 0 ? fold3.getStartOffset() + 1 : fold3.getEndOffset()))) != null && fold.getStartOffset() < n3) {
            if (fold == fold3) {
                return fold3;
            }
            fold3 = fold;
        }
        if (fold3 == null || fold3.getStartOffset() > n3) {
            if (fold2 == null) {
                fold2 = FoldUtilities.findOffsetFold((FoldHierarchy)foldHierarchy, (int)n2);
            }
            return fold2;
        }
        if (fold2 == null) {
            return fold3;
        }
        if (fold2.isCollapsed()) {
            return fold2;
        }
        if (fold2.getEndOffset() > fold3.getEndOffset() && fold3.getEndOffset() > n) {
            return fold3;
        }
        if (fold3.getStartOffset() > fold2.getEndOffset()) {
            return fold2;
        }
        if (fold3.getEndOffset() < n) {
            return fold2;
        }
        return fold3;
    }

    class ViewHierarchyChangeNotifier
    implements FoldHierarchyListener {
        ViewHierarchyChangeNotifier() {
        }

        public void foldHierarchyChanged(FoldHierarchyEvent foldHierarchyEvent) {
            for (ViewHierarchyChangeListener viewHierarchyChangeListener : MWCodeFoldingSideBar.this.viewHierarchyListeners) {
                viewHierarchyChangeListener.viewHierarchyChanged(MWCodeFoldingSideBar.this.createViewHierarchyChangeEvent(foldHierarchyEvent));
            }
        }
    }

    private class FoldingSideBarMouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private Cursor curCursor;
        private boolean ignoreMouseRelease;

        private FoldingSideBarMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            block8: {
                CodeFoldingSideBar.Mark mark;
                if (!MWCodeFoldingSideBar.this.component.hasFocus()) {
                    MWCodeFoldingSideBar.this.component.requestFocusInWindow();
                }
                if ((mark = MWCodeFoldingSideBar.this.getClickedMark(mouseEvent, true)) != null) {
                    this.ignoreMouseRelease = true;
                    MWCodeFoldingSideBar.this.performAction(mark);
                } else {
                    this.ignoreMouseRelease = false;
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        try {
                            if (mouseEvent.isShiftDown()) {
                                MWCodeFoldingSideBar.this.component.getCaret().moveDot(this.rowEndWithEOLFromEvent(mouseEvent));
                                break block8;
                            }
                            MWCodeFoldingSideBar.this.component.getCaret().setDot(this.rowStartFromEvent(mouseEvent));
                        }
                        catch (BadLocationException badLocationException) {
                            LOGGER.nbDebugLog(badLocationException);
                        }
                    } else {
                        MWCodeFoldingSideBar.this.component.dispatchEvent(MWCodeFoldingSideBar.this.createNewMouseEvent(mouseEvent));
                    }
                }
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            MWCodeFoldingSideBar.this.setCursor(this.curCursor);
            if (!this.ignoreMouseRelease && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                try {
                    MWCodeFoldingSideBar.this.component.getCaret().moveDot(this.rowEndWithEOLFromEvent(mouseEvent));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.ignoreMouseRelease && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                try {
                    MWCodeFoldingSideBar.this.component.getCaret().moveDot(this.rowEndWithEOLFromEvent(mouseEvent));
                }
                catch (BadLocationException badLocationException) {
                    LOGGER.nbDebugLog(badLocationException);
                }
            } else {
                MWCodeFoldingSideBar.this.component.dispatchEvent(MWCodeFoldingSideBar.this.createNewMouseEvent(mouseEvent));
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.curCursor = MWCodeFoldingSideBar.this.getCursor();
            if (this.isInsideAnyMark(mouseEvent, false)) {
                MWCodeFoldingSideBar.this.setCursor(new Cursor(12));
            }
            if (!this.isInsideAnyMark(mouseEvent, true)) {
                MWCodeFoldingSideBar.this.component.dispatchEvent(MWCodeFoldingSideBar.this.createNewMouseEvent(mouseEvent));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            MWCodeFoldingSideBar.this.setCursor(this.curCursor);
            if (!this.isInsideAnyMark(mouseEvent, true)) {
                MWCodeFoldingSideBar.this.component.dispatchEvent(MWCodeFoldingSideBar.this.createNewMouseEvent(mouseEvent));
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (this.isInsideAnyMark(mouseEvent, false) && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                MWCodeFoldingSideBar.this.setCursor(new Cursor(12));
            } else {
                MWCodeFoldingSideBar.this.setCursor(this.curCursor);
                MWCodeFoldingSideBar.this.component.dispatchEvent(MWCodeFoldingSideBar.this.createNewMouseEvent(mouseEvent));
            }
        }

        private int rowStartFromEvent(MouseEvent mouseEvent) throws BadLocationException {
            return MWEditorUIUtils.getRowStartFromPoint(mouseEvent.getPoint(), MWCodeFoldingSideBar.this.component);
        }

        private int rowEndWithEOLFromEvent(MouseEvent mouseEvent) throws BadLocationException {
            return MWEditorUIUtils.getRowEndWithEOLFromPoint(mouseEvent.getPoint(), MWCodeFoldingSideBar.this.component);
        }

        private boolean isInsideAnyMark(MouseEvent mouseEvent, boolean bl) {
            return MWCodeFoldingSideBar.this.getClickedMark(mouseEvent, bl) != null;
        }
    }
}

