/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.analyzer;

import com.mathworks.matlab.api.editor.EditorLayer;
import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.matlab.api.editor.EditorMessageBarContributor;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.ColorPrefs;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.messagepanel.MessageModelListener;
import com.mathworks.widgets.text.ColoringDrawLayer;
import com.mathworks.widgets.text.ColoringFactory;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.LayerMarkList;
import com.mathworks.widgets.text.PrintableDocument;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.layer.EditorTip;
import com.mathworks.widgets.text.layer.LayerUtils;
import com.mathworks.widgets.text.mcode.CodeAnalyzerUtilities;
import com.mathworks.widgets.text.mcode.MEditorUI;
import com.mathworks.widgets.text.mcode.MKit;
import com.mathworks.widgets.text.mcode.MLint;
import com.mathworks.widgets.text.mcode.MLintConfiguration;
import com.mathworks.widgets.text.mcode.MLintPrefsUtils;
import com.mathworks.widgets.text.mcode.MSettingsInitializer;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerMessageBarContributor;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerMessageModel;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerThread;
import com.mathworks.widgets.text.mcode.analyzer.CodeAnalyzerUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang.Validate;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtEditorUI;

public final class CodeAnalyzerLayer
implements EditorLayer {
    public static final String LAYER_NAME = "Code Analyzer Layer";
    public static final int CODE_ANALYZER_VISIBILITY = 500000;
    private static final String ERROR_LAYER_NAME = "code-analyzer-error-layer";
    private static final String WARNING_LAYER_NAME = "code-analyzer-warning-layer";
    private static final String AUTOFIX_LAYER_NAME = "code-analyzer-autofix-layer";
    private static final int MAX_SQUIGGLE_LENGTH = 150;
    public static final int UNDERLINE_NONE = 0;
    public static final int UNDERLINE_ERRORS_ONLY = 1;
    public static final int UNDERLINE_ALL = 2;
    private static final int UNDERLINE_UNSET = -1;
    private boolean fFollowingMLintPreference = false;
    private PrefListener fColorPrefListener;
    private PrefListener fUseAutofixListener;
    private PropertyChangeListener fFilenameListener;
    private final ChangeListener fMLintConfigListener;
    private final DocumentListener fDocumentModificationListener;
    private boolean fEnabledWithTextPane;
    private CodeAnalyzerMessageModel fModel;
    private final ColoringDrawLayer fMLintWarningLayer;
    private final ColoringDrawLayer fMLintErrorLayer = new ColoringDrawLayer("code-analyzer-error-layer", ColoringFactory.createWavyUnderline(EditorPrefsAccessor.getErrorsColoring().getForeColor()));
    private final ColoringDrawLayer fMLintAutoFixLayer;
    private LayerMarkList fMarkList;
    private CodeAnalyzerThread fCodeAnalyzer;
    private boolean fShowEmlMessages = false;
    private STPBaseInterface fSyntaxPane;
    private int fUnderlineMode = -1;
    private CodeAnalyzerMessageBarContributor fMessageBarContributor;

    public CodeAnalyzerLayer() {
        this.fMLintWarningLayer = new ColoringDrawLayer(WARNING_LAYER_NAME, ColoringFactory.createWavyUnderline(CodeAnalyzerUtils.getWarningColor(MKit.class)));
        this.fMLintAutoFixLayer = new ColoringDrawLayer(AUTOFIX_LAYER_NAME, CodeAnalyzerLayer.createAutoFixColoring(MKit.class));
        this.fMLintConfigListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (CodeAnalyzerLayer.this.fEnabledWithTextPane) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            CodeAnalyzerLayer.this.fCodeAnalyzer.refresh();
                            CodeAnalyzerLayer.this.repositionMarksOnEDT();
                        }
                    });
                }
            }
        };
        this.fDocumentModificationListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                CodeAnalyzerLayer.this.handleDocumentModified();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                CodeAnalyzerLayer.this.handleDocumentModified();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        };
    }

    private void possiblyEnableOrDisableLayer(MEditorUI mEditorUI) {
        STPBaseInterface sTPBaseInterface = (STPBaseInterface)((Object)mEditorUI.getComponent());
        if (!this.fEnabledWithTextPane && sTPBaseInterface != null && this.shouldShow(sTPBaseInterface)) {
            mEditorUI.installLayer(this);
        } else if (this.fEnabledWithTextPane && !this.shouldShow(sTPBaseInterface)) {
            mEditorUI.disableLayer(this);
        }
    }

    private void handleDocumentModified() {
        this.fModel.setValid(false);
        this.fCodeAnalyzer.documentModified();
    }

    public void showEmlMessages() {
        this.fShowEmlMessages = true;
    }

    private static int getUnderlinePreference(STPBaseInterface sTPBaseInterface) {
        return SettingsUtil.getInteger((Class)Utilities.getKitClass((JTextComponent)sTPBaseInterface.getActiveTextComponent()), (String)"mlint-underlining", (int)MSettingsInitializer.defaultMLintUnderlining);
    }

    private void repaintAll() {
        if (this.fSyntaxPane != null) {
            this.fSyntaxPane.getEditorUI().getComponent().repaint();
        }
    }

    public void setConfiguration(MLintConfiguration mLintConfiguration) {
        this.fCodeAnalyzer.setConfiguration(mLintConfiguration);
    }

    public void enable(JTextComponent jTextComponent) {
        Validate.notNull((Object)jTextComponent);
        this.fSyntaxPane = (STPBaseInterface)((Object)jTextComponent);
        if (this.shouldShow(this.fSyntaxPane) && !this.fEnabledWithTextPane) {
            this.fEnabledWithTextPane = true;
            this.fModel = this.createMessageModel(this.fSyntaxPane);
            this.fMarkList = new LayerMarkList(this.fSyntaxPane);
            this.fMessageBarContributor = new CodeAnalyzerMessageBarContributor(this.fModel);
            this.fUnderlineMode = CodeAnalyzerLayer.getUnderlinePreference(this.fSyntaxPane);
            this.addUnderliningLayers(this.fSyntaxPane);
            this.addAutoFixLayer(this.fSyntaxPane);
            this.fSyntaxPane.getDocument().addDocumentListener(this.fDocumentModificationListener);
            this.fCodeAnalyzer = new CodeAnalyzerThread(this.fSyntaxPane, this.fModel);
            this.fCodeAnalyzer.showEMLMessages(this.fShowEmlMessages);
            this.fCodeAnalyzer.start();
            MLintPrefsUtils.addConfigurationListener(this.fMLintConfigListener);
            this.fColorPrefListener = new PrefListener(){

                public void prefChanged(PrefEvent prefEvent) {
                    CodeAnalyzerLayer.this.updateColors(prefEvent, CodeAnalyzerLayer.this.fSyntaxPane);
                }
            };
            this.fUseAutofixListener = new PrefListener(){

                public void prefChanged(PrefEvent prefEvent) {
                    CodeAnalyzerLayer.this.updateAutoFixLayer(CodeAnalyzerLayer.this.fSyntaxPane);
                }
            };
            ColorPrefs.addColorListener((String)"Colors_M_", (PrefListener)this.fColorPrefListener);
            ColorPrefs.addColorListener((String)"ColorsMLintAutoFixBackground", (PrefListener)this.fColorPrefListener);
            ColorPrefs.addUseMLintAutoFixBackgroundListener((PrefListener)this.fUseAutofixListener);
        }
        this.fFilenameListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CodeAnalyzerLayer.this.possiblyEnableOrDisableLayer((MEditorUI)CodeAnalyzerLayer.this.fSyntaxPane.getEditorUI());
                CodeAnalyzerLayer.this.refresh();
            }
        };
        this.addFilenameListener(this.fSyntaxPane.getDocument());
    }

    public void disable() {
        if (this.fEnabledWithTextPane) {
            this.fEnabledWithTextPane = false;
            this.fCodeAnalyzer.stop();
            ColorPrefs.removeColorListener((String)"Colors_M_", (PrefListener)this.fColorPrefListener);
            ColorPrefs.removeColorListener((String)"ColorsMLintAutoFixBackground", (PrefListener)this.fColorPrefListener);
            ColorPrefs.removeUseMLintAutoFixBackgroundListener((PrefListener)this.fUseAutofixListener);
            MLintPrefsUtils.removeConfigurationListener(this.fMLintConfigListener);
            this.fMarkList.clear();
            CodeAnalyzerLayer.removeUnderliningLayers(this.fSyntaxPane);
            CodeAnalyzerLayer.removeAutoFixLayer(this.fSyntaxPane);
            this.fSyntaxPane.getDocument().removeDocumentListener(this.fDocumentModificationListener);
        }
    }

    public void cleanup() {
        this.disable();
        this.removeFilenameListener(this.fSyntaxPane.getDocument());
        this.fSyntaxPane = null;
    }

    public EditorMessageBarContributor getMessageBarContributor() {
        return this.fMessageBarContributor;
    }

    private void updateColors(PrefEvent prefEvent, STPBaseInterface sTPBaseInterface) {
        assert (this.fEnabledWithTextPane) : "Code Analyzer not enabled";
        assert (prefEvent.getPrefKey().equals("Colors_M_") || prefEvent.getPrefKey().equals("ColorsMLintAutoFixBackground"));
        if (prefEvent.getPrefKey().equals("Colors_M_")) {
            this.fMLintErrorLayer.setColoring(ColoringFactory.createWavyUnderline(CodeAnalyzerUtils.getErrorColor(this.fSyntaxPane.getEditorKit().getClass())));
            this.fMLintWarningLayer.setColoring(ColoringFactory.createWavyUnderline(CodeAnalyzerUtils.getWarningColor(this.fSyntaxPane.getEditorKit().getClass())));
        } else if (prefEvent.getPrefKey().equals("ColorsMLintAutoFixBackground")) {
            this.updateAutoFixLayer(sTPBaseInterface);
        }
    }

    private static Coloring createAutoFixColoring(Class<? extends EditorKit> clazz) {
        return ColoringFactory.createTextHighlight(CodeAnalyzerUtils.getAutofixBackgroundColor(clazz));
    }

    private void addUnderliningLayers(STPBaseInterface sTPBaseInterface) {
        if (this.fUnderlineMode == 2) {
            sTPBaseInterface.getEditorUI().addLayer((DrawLayer)this.fMLintWarningLayer, 500000);
        }
        if (this.fUnderlineMode == 2 || this.fUnderlineMode == 1) {
            sTPBaseInterface.getEditorUI().addLayer((DrawLayer)this.fMLintErrorLayer, 500000);
        }
    }

    private static void removeUnderliningLayers(STPBaseInterface sTPBaseInterface) {
        sTPBaseInterface.getEditorUI().removeLayer(ERROR_LAYER_NAME);
        sTPBaseInterface.getEditorUI().removeLayer(WARNING_LAYER_NAME);
    }

    private void updateAutoFixLayer(STPBaseInterface sTPBaseInterface) {
        CodeAnalyzerLayer.removeAutoFixLayer(sTPBaseInterface);
        this.addAutoFixLayer(sTPBaseInterface);
        this.repositionMarksOnEDT();
    }

    private void addAutoFixLayer(STPBaseInterface sTPBaseInterface) {
        if (this.fEnabledWithTextPane && CodeAnalyzerUtils.isAutofixEnabled(sTPBaseInterface.getEditorKit().getClass())) {
            this.fMLintAutoFixLayer.setColoring(CodeAnalyzerLayer.createAutoFixColoring(sTPBaseInterface.getEditorKit().getClass()));
            sTPBaseInterface.getEditorUI().addLayer((DrawLayer)this.fMLintAutoFixLayer, 2100);
        }
    }

    private static void removeAutoFixLayer(STPBaseInterface sTPBaseInterface) {
        sTPBaseInterface.getEditorUI().removeLayer(AUTOFIX_LAYER_NAME);
    }

    public void updateDocuments(Document document, Document document2) {
        if (document != null) {
            document.removeDocumentListener(this.fDocumentModificationListener);
            this.removeFilenameListener(document);
        }
        if (document2 != null) {
            if (this.fEnabledWithTextPane) {
                document2.addDocumentListener(this.fDocumentModificationListener);
            }
            this.addFilenameListener(document2);
        }
        this.refresh();
    }

    public String getLayerName() {
        return LAYER_NAME;
    }

    private boolean shouldShow(STPBaseInterface sTPBaseInterface) {
        return MLint.nativeLibraryExists() && this.fFollowingMLintPreference && CodeAnalyzerLayer.isMLintEnabledInPreferences() && CodeAnalyzerLayer.isDotMFile(sTPBaseInterface);
    }

    private static boolean isMLintEnabledInPreferences() {
        return SettingsUtil.getBoolean(MKit.class, (String)"mlint-display", (Boolean)MSettingsInitializer.defaultMLintDisplay);
    }

    private static boolean isDotMFile(STPBaseInterface sTPBaseInterface) {
        String string = CodeAnalyzerLayer.getFilename(sTPBaseInterface.getDocument());
        return string == null || CodeAnalyzerLayer.isDotMFile(string);
    }

    private static boolean isDotMFile(String string) {
        String string2 = PlatformInfo.isWindows() ? string.toLowerCase() : string;
        return string2.endsWith(".m");
    }

    public boolean supportsMessageBar() {
        return this.fEnabledWithTextPane;
    }

    public void settingsChanged(String string, ExtEditorUI extEditorUI) {
        MEditorUI mEditorUI = (MEditorUI)extEditorUI;
        if (string == null || "mlint-display".equals(string)) {
            this.possiblyEnableOrDisableLayer(mEditorUI);
        } else if ("mlint-underlining".equals(string) && this.fEnabledWithTextPane) {
            int n = CodeAnalyzerLayer.getUnderlinePreference((STPBaseInterface)((Object)extEditorUI.getComponent()));
            if (n != this.fUnderlineMode) {
                this.fUnderlineMode = n;
                this.fMarkList.clear();
                CodeAnalyzerLayer.removeUnderliningLayers(this.fSyntaxPane);
                if (this.fUnderlineMode != 0) {
                    this.addUnderliningLayers(this.fSyntaxPane);
                }
                this.repositionMarksOnEDT();
                this.repaintAll();
            }
        } else if (ColorPrefs.MatlabColor.WARNING.getKey().equals(string) && this.fEnabledWithTextPane) {
            this.fMLintWarningLayer.setColoring(ColoringFactory.createWavyUnderline(CodeAnalyzerUtils.getWarningColor(this.fSyntaxPane.getEditorKit().getClass())));
            this.repaintAll();
        } else if (ColorPrefs.MatlabColor.ERROR.getKey().equals(string) && this.fEnabledWithTextPane) {
            this.fMLintErrorLayer.setColoring(ColoringFactory.createWavyUnderline(CodeAnalyzerUtils.getErrorColor(this.fSyntaxPane.getEditorKit().getClass())));
            this.repaintAll();
        } else if (("ColorsMLintAutoFixBackground".equals(string) || "ColorsUseMLintAutoFixBackground".equals(string)) && this.fEnabledWithTextPane) {
            this.updateAutoFixLayer(this.fSyntaxPane);
        }
    }

    public boolean isEnabled() {
        return this.fEnabledWithTextPane;
    }

    private void removeFilenameListener(Document document) {
        if (document instanceof PrintableDocument) {
            ((PrintableDocument)document).removePropertyChangeListener("filename", this.fFilenameListener);
        }
    }

    private void addFilenameListener(Document document) {
        if (document instanceof PrintableDocument) {
            ((PrintableDocument)document).addPropertyChangeListener("filename", this.fFilenameListener);
        }
    }

    public void refresh() {
        if (this.fEnabledWithTextPane) {
            this.fCodeAnalyzer.refresh();
        }
    }

    public void refreshSynchronously() {
        if (this.fEnabledWithTextPane) {
            this.fCodeAnalyzer.refreshSynchronously();
        }
    }

    public boolean messageUnderSelection() {
        return this.fEnabledWithTextPane && this.fMarkList.textSelectionWithinAMark();
    }

    public List<CodeAnalyzerMessageModel.CodeAnalyzerMessage> getMessagesAtPosition(int n, int n2) {
        List<CodeAnalyzerMessageModel.CodeAnalyzerMessage> list = Collections.emptyList();
        Predicate<EditorMessage> predicate = new Predicate<EditorMessage>(){

            public boolean accept(EditorMessage editorMessage) {
                return CodeAnalyzerLayer.this.isShowingMessage(((CodeAnalyzerMessageModel.CodeAnalyzerMessage)editorMessage).getMLintMessage());
            }
        };
        if (this.fEnabledWithTextPane && !this.fCodeAnalyzer.isOutOfSync() && this.isDecoratingText()) {
            list = LayerUtils.getMessagesFromModel(n, n2, this.fModel, predicate);
        }
        return list;
    }

    private boolean isShowingMessage(MLint.Message message) {
        boolean bl = false;
        if (this.fUnderlineMode == 2) {
            bl = true;
        } else if (this.fUnderlineMode == 1 && CodeAnalyzerUtils.isError(message)) {
            bl = true;
        } else if (ColorPrefs.isMLintAutoFixBackgroundEnabled() && message.hasAutoFix()) {
            bl = true;
        }
        return bl;
    }

    private CodeAnalyzerMessageModel createMessageModel(STPBaseInterface sTPBaseInterface) {
        CodeAnalyzerMessageModel codeAnalyzerMessageModel = new CodeAnalyzerMessageModel(sTPBaseInterface);
        codeAnalyzerMessageModel.addListener(new MessageModelListener(){

            @Override
            public void messagesUpdated() {
                CodeAnalyzerLayer.this.repositionMarksOnEDT();
            }
        });
        return codeAnalyzerMessageModel;
    }

    private int getLayerCount() {
        int n = 0;
        if (this.fSyntaxPane.getEditorUI().findLayer(WARNING_LAYER_NAME) != null) {
            ++n;
        }
        if (this.fSyntaxPane.getEditorUI().findLayer(ERROR_LAYER_NAME) != null) {
            ++n;
        }
        if (this.fSyntaxPane.getEditorUI().findLayer(AUTOFIX_LAYER_NAME) != null) {
            ++n;
        }
        return n;
    }

    private void repositionMarksOnEDT() {
        MJUtilities.assertIsEventThread();
        if (this.fCodeAnalyzer.isOutOfSync() || !this.isDecoratingText()) {
            return;
        }
        this.fMarkList.clear();
        for (int i = 0; i < this.fModel.getMessageCount(); ++i) {
            MLint.Message message = this.fModel.getMLintMessageAt(i);
            try {
                boolean bl;
                int n = CodeAnalyzerUtilities.getStartPosition(this.fSyntaxPane.getDocument(), message);
                int n2 = CodeAnalyzerUtilities.getEndPosition(this.fSyntaxPane.getDocument(), message);
                int n3 = n2 - n;
                if (n3 > 150) {
                    n3 = 150;
                }
                if ((bl = CodeAnalyzerUtils.isError(message)) && this.fUnderlineMode != 0 || this.fUnderlineMode == 2) {
                    String string = bl ? ERROR_LAYER_NAME : WARNING_LAYER_NAME;
                    this.fMarkList.addMark(string, n, n3);
                }
                if (!ColorPrefs.isMLintAutoFixBackgroundEnabled() || !message.hasAutoFix()) continue;
                this.fMarkList.addMark(AUTOFIX_LAYER_NAME, n, n3);
                continue;
            }
            catch (Exception exception) {
                Log.logException((Exception)exception);
            }
        }
    }

    private boolean isDecoratingText() {
        return this.fEnabledWithTextPane && (this.fUnderlineMode != 0 || ColorPrefs.isMLintAutoFixBackgroundEnabled());
    }

    static String getFilename(Document document) {
        return document instanceof PrintableDocument ? ((PrintableDocument)document).getFilename() : null;
    }

    public void setFollowingMLintPreference(boolean bl) {
        this.fFollowingMLintPreference = bl;
    }

    static {
        EditorTip.preInit();
    }
}

