/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sql;

import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionLocation;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sql.SQLInsert;
import net.sf.saxon.sql.SQLUpdate;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class SQLColumn
extends XSLGeneralVariable {
    public boolean isInstruction() {
        return false;
    }

    public boolean mayContainSequenceConstructor() {
        return false;
    }

    public void prepareAttributes() throws XPathException {
        this.getVariableQName();
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String nameAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            String localName = atts.getLocalName(a);
            if (localName.equals("name")) {
                nameAtt = Whitespace.trim((CharSequence)atts.getValue(a));
                continue;
            }
            if (localName.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNameCode(a));
        }
        if (nameAtt == null) {
            this.reportAbsence("name");
        } else if (!this.getConfiguration().getNameChecker().isQName(nameAtt)) {
            this.compileError("Column name must be a valid QName");
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate() throws XPathException {
        if (!(this.getParent() instanceof SQLInsert) && !(this.getParent() instanceof SQLUpdate)) {
            this.compileError("parent node must be either sql:insert or sql:update");
        }
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator role = new RoleLocator(4, (Object)"sql:column/select", 0, null);
            role.setSourceLocator((SourceLocator)new ExpressionLocation((SourceLocator)((Object)this)));
            this.select = TypeChecker.staticTypeCheck((Expression)this.select, (SequenceType)SequenceType.SINGLE_ATOMIC, (boolean)false, (RoleLocator)role, (ExpressionVisitor)this.makeExpressionVisitor());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        ColumnInstruction inst = new ColumnInstruction();
        this.initializeInstruction(exec, inst);
        return inst;
    }

    public String getColumnName() {
        return Navigator.getAttributeValue((NodeInfo)this, (String)"", (String)"name");
    }

    protected static class ColumnInstruction
    extends GeneralVariable {
        public InstructionInfo getInstructionInfo() {
            InstructionDetails details = (InstructionDetails)super.getInstructionInfo();
            details.setConstructType(2005);
            return details;
        }

        public TailCall processLeavingTail(XPathContext context) {
            return null;
        }

        public ValueRepresentation evaluateVariable(XPathContext context) throws XPathException {
            throw new UnsupportedOperationException();
        }
    }
}

