/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.DebugUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class Point3D {
    private double x;
    private double y;
    private double z;

    public Point3D(double d, double d2, double d3) {
        this.set(d, d2, d3);
    }

    public Point3D(double[] dArray) {
        this.set(dArray);
    }

    public Point3D(Point3D point3D) {
        if (point3D == null) {
            throw new IllegalArgumentException();
        }
        this.x = point3D.x;
        this.y = point3D.y;
        this.z = point3D.z;
    }

    public Point3D() {
    }

    public void set(double[] dArray) {
        if (dArray == null) {
            return;
        }
        assert (dArray.length == 3) : DebugUtils.argStr(dArray.length);
        this.x = dArray[0];
        this.y = dArray[1];
        this.z = dArray[2];
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public double[] get() {
        double[] dArray = new double[]{this.x, this.y, this.z};
        return dArray;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double d) {
        this.x = d;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Point3D)) {
            return false;
        }
        Point3D point3D = (Point3D)object;
        return this.x == point3D.x && this.y == point3D.y && this.z == point3D.z;
    }

    public boolean epsilonEquals(Point3D point3D, double d) {
        if (point3D == this) {
            return true;
        }
        if (point3D == null) {
            return false;
        }
        double d2 = this.x - point3D.x;
        if (Double.isNaN(d2)) {
            return false;
        }
        double d3 = d2 < 0.0 ? -d2 : d2;
        if (d3 > d) {
            return false;
        }
        d2 = this.y - point3D.y;
        if (Double.isNaN(d2)) {
            return false;
        }
        double d4 = d2 < 0.0 ? -d2 : d2;
        if (d4 > d) {
            return false;
        }
        d2 = this.z - point3D.z;
        if (Double.isNaN(d2)) {
            return false;
        }
        double d5 = d2 < 0.0 ? -d2 : d2;
        return !(d5 > d);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public final double distance(Point3D point3D) {
        assert (point3D != null);
        double d = this.x - point3D.x;
        double d2 = this.y - point3D.y;
        double d3 = this.z - point3D.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }
}

