/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import javax.swing.SwingUtilities;

public class RequestQueue {
    private final String fName;
    private final Queue<Runnable> fQueue;
    private Thread fThread;
    private static final long KEEP_ALIVE_MILLISECONDS = 10000L;
    public static final RequestQueue EDT = new RequestQueue("EDT RequestQueue"){

        @Override
        public void request(Runnable runnable) {
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    };

    public RequestQueue(String string) {
        this.fName = string;
        this.fQueue = new LinkedList<Runnable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(Runnable runnable) {
        Queue<Runnable> queue = this.fQueue;
        synchronized (queue) {
            this.fQueue.offer(runnable);
            this.startThreadIfNecessary();
            this.fQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThreadIfNecessary() {
        Queue<Runnable> queue = this.fQueue;
        synchronized (queue) {
            if (this.fThread == null) {
                this.fThread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        do {
                            RequestQueue.this.execute();
                        } while (RequestQueue.this.waitForRequestUntilTimeout());
                        Queue queue = RequestQueue.this.fQueue;
                        synchronized (queue) {
                            RequestQueue.this.fThread = null;
                        }
                    }
                });
                this.fThread.setName(this.fName);
                this.fThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        ArrayList<Runnable> arrayList;
        Queue<Runnable> queue = this.fQueue;
        synchronized (queue) {
            arrayList = new ArrayList<Runnable>(this.fQueue);
            this.fQueue.clear();
        }
        for (Runnable runnable : arrayList) {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForRequestUntilTimeout() {
        Queue<Runnable> queue = this.fQueue;
        synchronized (queue) {
            if (this.fQueue.isEmpty()) {
                try {
                    this.fQueue.wait(10000L);
                    return !this.fQueue.isEmpty();
                }
                catch (InterruptedException interruptedException) {
                    return false;
                }
            }
            return true;
        }
    }
}

