/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ObjArray
implements Serializable {
    static final long serialVersionUID = 7448768847663119705L;
    private int size;
    private transient Object OEAB;
    private transient Object add;
    private transient Object append;
    private transient Object arraycopy;
    private transient Object defaultReadObject;
    private transient Object defaultWriteObject;
    private transient Object[] equals;

    public ObjArray() {
    }

    public ObjArray(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n > 6) {
            this.equals = new Object[n - 6];
        }
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final int size() {
        return this.size;
    }

    public final void setSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int n2 = this.size;
        if (n < n2) {
            int n3 = n;
            while (n3 != n2) {
                this.append(n3, null);
                ++n3;
            }
        } else if (n > n2 && n > 6) {
            this.arraycopy(n);
        }
        this.size = n;
    }

    public final Object get(int n) {
        if (0 > n || n >= this.size) {
            throw ObjArray.defaultReadObject(n, this.size);
        }
        return this.OEAB(n);
    }

    public final void set(int n, Object object) {
        if (0 > n || n >= this.size) {
            throw ObjArray.defaultReadObject(n, this.size);
        }
        this.append(n, object);
    }

    private Object OEAB(int n) {
        switch (n) {
            case 0: {
                return this.OEAB;
            }
            case 1: {
                return this.add;
            }
            case 2: {
                return this.append;
            }
            case 3: {
                return this.arraycopy;
            }
            case 4: {
                return this.defaultReadObject;
            }
            case 5: {
                return this.defaultWriteObject;
            }
        }
        return this.equals[n - 6];
    }

    private void append(int n, Object object) {
        switch (n) {
            case 0: {
                this.OEAB = object;
                break;
            }
            case 1: {
                this.add = object;
                break;
            }
            case 2: {
                this.append = object;
                break;
            }
            case 3: {
                this.arraycopy = object;
                break;
            }
            case 4: {
                this.defaultReadObject = object;
                break;
            }
            case 5: {
                this.defaultWriteObject = object;
                break;
            }
            default: {
                this.equals[n - 6] = object;
            }
        }
    }

    public int indexOf(Object object) {
        int n = this.size;
        int n2 = 0;
        while (n2 != n) {
            Object object2 = this.OEAB(n2);
            if (object2 == object || object2 != null && object2.equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        int n = this.size;
        while (n != 0) {
            Object object2;
            if ((object2 = this.OEAB(--n)) != object && (object2 == null || !object2.equals(object))) continue;
            return n;
        }
        return -1;
    }

    public final Object peek() {
        int n = this.size;
        if (n == 0) {
            throw ObjArray.defaultWriteObject();
        }
        return this.OEAB(n - 1);
    }

    public final Object pop() {
        Object object;
        int n = this.size;
        switch (--n) {
            case -1: {
                throw ObjArray.defaultWriteObject();
            }
            case 0: {
                object = this.OEAB;
                this.OEAB = null;
                break;
            }
            case 1: {
                object = this.add;
                this.add = null;
                break;
            }
            case 2: {
                object = this.append;
                this.append = null;
                break;
            }
            case 3: {
                object = this.arraycopy;
                this.arraycopy = null;
                break;
            }
            case 4: {
                object = this.defaultReadObject;
                this.defaultReadObject = null;
                break;
            }
            case 5: {
                object = this.defaultWriteObject;
                this.defaultWriteObject = null;
                break;
            }
            default: {
                object = this.equals[n - 6];
                this.equals[n - 6] = null;
            }
        }
        this.size = n;
        return object;
    }

    public final void push(Object object) {
        this.add(object);
    }

    public final void add(Object object) {
        int n = this.size;
        if (n >= 6) {
            this.arraycopy(n + 1);
        }
        this.size = n + 1;
        this.append(n, object);
    }

    public final void add(int n, Object object) {
        int n2 = this.size;
        if (0 > n || n > n2) {
            throw ObjArray.defaultReadObject(n, n2 + 1);
        }
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    this.OEAB = object;
                    break;
                }
                Object object2 = this.OEAB;
                this.OEAB = object;
                object = object2;
            }
            case 1: {
                if (n2 == 1) {
                    this.add = object;
                    break;
                }
                Object object2 = this.add;
                this.add = object;
                object = object2;
            }
            case 2: {
                if (n2 == 2) {
                    this.append = object;
                    break;
                }
                Object object2 = this.append;
                this.append = object;
                object = object2;
            }
            case 3: {
                if (n2 == 3) {
                    this.arraycopy = object;
                    break;
                }
                Object object2 = this.arraycopy;
                this.arraycopy = object;
                object = object2;
            }
            case 4: {
                if (n2 == 4) {
                    this.defaultReadObject = object;
                    break;
                }
                Object object2 = this.defaultReadObject;
                this.defaultReadObject = object;
                object = object2;
            }
            case 5: {
                if (n2 == 5) {
                    this.defaultWriteObject = object;
                    break;
                }
                Object object2 = this.defaultWriteObject;
                this.defaultWriteObject = object;
                object = object2;
                n = 6;
            }
            default: {
                this.arraycopy(n2 + 1);
                if (n != n2) {
                    System.arraycopy(this.equals, n - 6, this.equals, n - 6 + 1, n2 - n);
                }
                this.equals[n - 6] = object;
            }
        }
        this.size = n2 + 1;
    }

    public final void remove(int n) {
        int n2 = this.size;
        if (0 > n || n >= n2) {
            throw ObjArray.defaultReadObject(n, n2);
        }
        --n2;
        switch (n) {
            case 0: {
                if (n2 == 0) {
                    this.OEAB = null;
                    break;
                }
                this.OEAB = this.add;
            }
            case 1: {
                if (n2 == 1) {
                    this.add = null;
                    break;
                }
                this.add = this.append;
            }
            case 2: {
                if (n2 == 2) {
                    this.append = null;
                    break;
                }
                this.append = this.arraycopy;
            }
            case 3: {
                if (n2 == 3) {
                    this.arraycopy = null;
                    break;
                }
                this.arraycopy = this.defaultReadObject;
            }
            case 4: {
                if (n2 == 4) {
                    this.defaultReadObject = null;
                    break;
                }
                this.defaultReadObject = this.defaultWriteObject;
            }
            case 5: {
                if (n2 == 5) {
                    this.defaultWriteObject = null;
                    break;
                }
                this.defaultWriteObject = this.equals[0];
                n = 6;
            }
            default: {
                if (n != n2) {
                    System.arraycopy(this.equals, n - 6 + 1, this.equals, n - 6, n2 - n);
                }
                this.equals[n2 - 6] = null;
            }
        }
        this.size = n2;
    }

    public final void clear() {
        int n = this.size;
        int n2 = 0;
        while (n2 != n) {
            this.append(n2, null);
            ++n2;
        }
        this.size = 0;
    }

    public final Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        this.toArray(objectArray, 0);
        return objectArray;
    }

    public final void toArray(Object[] objectArray) {
        this.toArray(objectArray, 0);
    }

    public final void toArray(Object[] objectArray, int n) {
        int n2 = this.size;
        switch (n2) {
            default: {
                System.arraycopy(this.equals, 0, objectArray, n + 6, n2 - 6);
            }
            case 6: {
                objectArray[n + 5] = this.defaultWriteObject;
            }
            case 5: {
                objectArray[n + 4] = this.defaultReadObject;
            }
            case 4: {
                objectArray[n + 3] = this.arraycopy;
            }
            case 3: {
                objectArray[n + 2] = this.append;
            }
            case 2: {
                objectArray[n + 1] = this.add;
            }
            case 1: {
                objectArray[n + 0] = this.OEAB;
            }
            case 0: 
        }
    }

    private void arraycopy(int n) {
        int n2 = n - 6;
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.equals == null) {
            int n3 = 12;
            if (n3 < n2) {
                n3 = n2;
            }
            this.equals = new Object[n3];
        } else {
            int n4 = this.equals.length;
            if (n4 < n2) {
                n4 = n4 <= 6 ? 12 : (n4 *= 2);
                if (n4 < n2) {
                    n4 = n2;
                }
                Object[] objectArray = new Object[n4];
                if (this.size > 6) {
                    System.arraycopy(this.equals, 0, objectArray, 0, this.size - 6);
                }
                this.equals = objectArray;
            }
        }
    }

    private static RuntimeException defaultReadObject(int n, int n2) {
        String string = n + " \u2209 [0, " + n2 + ')';
        return new IndexOutOfBoundsException(string);
    }

    private static RuntimeException defaultWriteObject() {
        throw new RuntimeException("Empty stack");
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        int n = this.size;
        int n2 = 0;
        while (n2 != n) {
            Object object = this.OEAB(n2);
            objectOutputStream.writeObject(object);
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = this.size;
        if (n > 6) {
            this.equals = new Object[n - 6];
        }
        int n2 = 0;
        while (n2 != n) {
            Object object = objectInputStream.readObject();
            this.append(n2, object);
            ++n2;
        }
    }
}

