/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.pilots.html4.AttributeSelector;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DNode;
import ice.pilots.html4.Names;
import ice.util.alg.CharKit;
import java.util.Vector;

class SimpleSelector {
    private static final int S_PSEUDO_LINK = 1;
    private static final int S_PSEUDO_VISITED = 2;
    private static final int S_PSEUDO_FIRST_LETTER = 4;
    private static final int S_PSEUDO_FIRST_LINE = 8;
    private static final int S_PSEUDO_FIRST_CHILD = 16;
    private static final int S_PSEUDO_LAST_CHILD = 32;
    private static final int S_PSEUDO_IGNORE = 64;
    Names names;
    int elementNameId;
    String idString = null;
    private Vector attributeSelectors = new Vector();
    private String universalClassKey;
    private int pseudoCount = 0;
    byte pseudo = 0;
    private boolean isFirstChild = false;
    private boolean isLastChild = false;
    private byte special = 0;
    int combinator = -1;

    SimpleSelector(Names names, int n) {
        this.names = names;
        this.elementNameId = n;
    }

    void addPseudoSelector(String string) {
        if ((string = CharKit.toLowerCase((String)string)).equals("hover")) {
            this.pseudo = (byte)(this.pseudo | 1);
        } else if (string.equals("active")) {
            this.pseudo = (byte)(this.pseudo | 2);
        } else if (string.equals("focus")) {
            this.pseudo = (byte)(this.pseudo | 4);
        } else if (string.equals("before")) {
            this.pseudo = (byte)(this.pseudo | 8);
        } else if (string.equals("after")) {
            this.pseudo = (byte)(this.pseudo | 0x10);
        } else if (string.equals("first-child")) {
            this.isFirstChild = true;
        } else if (string.equals("last-child")) {
            this.isLastChild = true;
        } else {
            this.special = string.equals("link") ? (byte)(this.special | 1) : (string.equals("visited") ? (byte)(this.special | 2) : (string.equals("first-letter") ? (byte)(this.special | 4) : (string.equals("first-line") ? (byte)(this.special | 8) : (byte)(this.special | 0x40))));
        }
        ++this.pseudoCount;
    }

    String getUniversalClassKey() {
        return this.universalClassKey;
    }

    void addAttributeSelector(AttributeSelector attributeSelector) {
        if (this.elementNameId == 0) {
            this.universalClassKey = attributeSelector.getClassKey();
        }
        this.attributeSelectors.addElement(attributeSelector);
    }

    void setIDSelector(String string) {
        this.idString = string;
    }

    int computeWeight() {
        int n = 0;
        if (this.elementNameId > 0) {
            ++n;
        }
        n += (this.attributeSelectors.size() + this.pseudoCount) * 10;
        if (this.idString != null) {
            n += 100;
        }
        return n;
    }

    boolean match(DElement dElement) {
        Object object;
        Object object2;
        if (this.elementNameId > 0 && this.elementNameId != dElement.tagId) {
            return false;
        }
        if (this.elementNameId < 0) {
            return false;
        }
        if (this.isFirstChild) {
            object2 = dElement.getParentDNode();
            if (object2 == null) {
                return false;
            }
            object2 = ((DNode)object2).getFirstDChild();
            while (object2 != null && object2 != dElement) {
                if (object2 instanceof DElement && ((DNode)object2).getNameId() != 70) {
                    return false;
                }
                object2 = ((DNode)object2).next;
            }
            if (object2 != dElement) {
                return false;
            }
        }
        if (this.isLastChild) {
            object2 = (DNode)dElement.getParentNode();
            if (object2 == null) {
                return false;
            }
            object = (DNode)((DNode)object2).getLastChild();
            while (object != null && object != dElement) {
                if (object instanceof DElement) {
                    return false;
                }
                object = ((DNode)object).prev;
            }
            if (object != dElement) {
                return false;
            }
        }
        if (this.special != 0) {
            if ((this.special & 0x40) != 0) {
                return false;
            }
            if ((this.special & 3) == 0) {
                return false;
            }
            if ((this.special & 1) != 0) {
                if (dElement.tagId != 1) {
                    return false;
                }
                if (dElement.getAttribute(46) == null) {
                    return false;
                }
                if (!(dElement instanceof DAnchorElement)) {
                    return false;
                }
                if (((DAnchorElement)dElement).getVisited()) {
                    return false;
                }
            }
            if ((this.special & 2) != 0) {
                if (!(dElement instanceof DAnchorElement)) {
                    return false;
                }
                if (!((DAnchorElement)dElement).getVisited()) {
                    return false;
                }
            }
        }
        if (this.idString != null) {
            object2 = dElement.getId();
            if (object2 == null) {
                return false;
            }
            if (!DDocument.STRICT) {
                this.idString = CharKit.toLowerCase((String)this.idString);
                object2 = CharKit.toLowerCase((String)object2);
            }
            if (!((String)object2).equals(this.idString)) {
                return false;
            }
        }
        for (int i = 0; i < this.attributeSelectors.size(); ++i) {
            object = (AttributeSelector)this.attributeSelectors.elementAt(i);
            if (((AttributeSelector)object).match(dElement)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "*";
        if (this.elementNameId > 0) {
            string = this.names.getTagName(this.elementNameId);
        }
        stringBuffer.append(string);
        int n = this.attributeSelectors.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.attributeSelectors.elementAt(i).toString());
        }
        if (this.idString != null) {
            stringBuffer.append("#");
            stringBuffer.append(this.idString);
        }
        if ((this.pseudo & 1) != 0) {
            stringBuffer.append(":hover");
        }
        if ((this.pseudo & 2) != 0) {
            stringBuffer.append(":active");
        }
        if ((this.pseudo & 4) != 0) {
            stringBuffer.append(":focus");
        }
        if ((this.pseudo & 8) != 0) {
            stringBuffer.append(":before");
        }
        if ((this.pseudo & 0x10) != 0) {
            stringBuffer.append(":after");
        }
        if (this.isFirstChild) {
            stringBuffer.append(":first-child");
        }
        if (this.isLastChild) {
            stringBuffer.append(":last-child");
        }
        if ((this.special & 1) != 0) {
            stringBuffer.append(":link");
        }
        if ((this.special & 2) != 0) {
            stringBuffer.append(":visited");
        }
        if (this.combinator >= 0) {
            stringBuffer.append((char)this.combinator);
        }
        return stringBuffer.toString();
    }
}

