/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.text;

import ice.pilots.text.ThePilot;
import ice.storm.print.AbstractStormPrinter;
import ice.storm.print.PageDecoration;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

class ThePrinter
extends AbstractStormPrinter {
    private Vector textLines = new Vector();
    private ThePilot pilot = null;
    private int lineSpacing = 0;
    private int linesPerPage;
    private FontMetrics fontMetrics;
    private int spaceWidth;
    Font fonts = new Font("Arial", 0, 10);

    protected ThePrinter(ThePilot thePilot) {
        this.pilot = thePilot;
        this.getPageCount();
    }

    public int getPageCount() {
        if (this.pageFormat == null) {
            throw new NullPointerException();
        }
        if (this.pageFormat.hasImageableAreaChanged()) {
            int n;
            this.fonts = ThePilot.getDefaultFont();
            if (this.fonts != null) {
                n = ThePilot.DEFAULT_FONT_SIZE;
                int n2 = n * (int)(this.pageFormat.getScale() * 256.0) >> 8;
                if (n2 < 4) {
                    n2 = 4;
                }
                this.fonts = new Font(this.fonts.getName(), this.fonts.getStyle(), n2);
            }
            this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.fonts);
            this.lineSpacing = this.fontMetrics.getAscent();
            this.spaceWidth = this.fontMetrics.charWidth(' ');
            this.linesPerPage = (int)this.pageFormat.getImageableHeight() / this.lineSpacing;
            this.textLines = (Vector)this.pilot.getLines().clone();
            if (this.pageFormat.isTextWrappingEnabled()) {
                n = 0;
                Enumeration enumeration = this.textLines.elements();
                while (enumeration.hasMoreElements() && (int)Math.ceil((double)this.textLines.size() / (double)this.linesPerPage) < 2000) {
                    String string = (String)enumeration.nextElement();
                    int n3 = this.fontMetrics.stringWidth(string);
                    if ((double)n3 > this.pageFormat.getImageableWidth()) {
                        this.lineWrapper(this.textLines, string, n);
                    }
                    ++n;
                }
            }
            this.numberOfPages = (int)Math.ceil((double)this.textLines.size() / (double)this.linesPerPage);
            this.currentPageIndex = -1;
            this.pageFormat.setImageableAreaChangedFlag(false);
        }
        return this.numberOfPages;
    }

    private void lineWrapper(Vector vector, String string, int n) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                n4 = this.spaceWidth;
                n2 += n4;
                ++n3;
            } else {
                n4 = this.fontMetrics.stringWidth(string2);
                n2 += n4;
                n3 += string2.length();
            }
            if (!((double)n2 > this.pageFormat.getImageableWidth()) || !((double)(n2 - n4) <= this.pageFormat.getImageableWidth())) continue;
            if ((double)n4 <= this.pageFormat.getImageableWidth()) {
                String string3 = string.substring(0, n3 - string2.length());
                String string4 = string.substring(n3 - string2.length(), string.length()).trim();
                vector.setElementAt(string3, n);
                vector.insertElementAt(string4, n + 1);
                continue;
            }
            int n5 = n2 - n4;
            for (int i = 0; i < string2.length() - 1; ++i) {
                if (!((double)(n5 += this.fontMetrics.stringWidth(string2.substring(i, i + 1))) > this.pageFormat.getImageableWidth())) continue;
                String string5 = string2.substring(0, i);
                String string6 = string2.substring(i, string2.length()).trim();
                vector.setElementAt(string5, n);
                vector.setElementAt(string6 + " " + vector.elementAt(n + 1), n + 1);
                continue block0;
            }
        }
    }

    public void printPage(Graphics graphics, int n) {
        Object object;
        if (n < 0) {
            n = 0;
        } else if (n > this.numberOfPages - 1) {
            n = this.numberOfPages - 1;
        }
        graphics.setColor(Color.black);
        graphics.setFont(this.fonts);
        Graphics graphics2 = graphics.create((int)this.pageFormat.getMargin(2), (int)this.pageFormat.getMargin(1), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        graphics2.translate(0, 0);
        graphics2.setClip(0, 0, (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        int n2 = this.fontMetrics.getMaxAscent() - 3;
        int n3 = this.linesPerPage * n;
        int n4 = n3 + this.linesPerPage;
        for (int i = n3; i < this.textLines.size() && i < n4; ++i) {
            object = (String)this.textLines.elementAt(i);
            graphics2.drawString((String)object, 0, n2);
            n2 += this.lineSpacing;
        }
        graphics2.dispose();
        Graphics graphics3 = graphics.create(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        graphics3.translate(0, 0);
        graphics3.setClip(0, 0, (int)this.pageFormat.getPageWidth(), (int)this.pageFormat.getPageHeight());
        object = this.pageFormat.getDecoration();
        for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
            PageDecoration pageDecoration = (PageDecoration)((Vector)object).elementAt(i);
            pageDecoration.paint(graphics3, n, this.numberOfPages, this.pageFormat);
        }
        graphics3.dispose();
    }

    public void print(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.setFont(ThePilot.getDefaultFont());
        int n = this.lineSpacing;
        for (int i = 0; i < this.textLines.size(); ++i) {
            String string = (String)this.textLines.elementAt(i);
            graphics.drawString(string, 0, n);
            n += this.lineSpacing;
        }
    }

    public void setZoom(int n) {
        double d = (double)Math.abs(n) / 256.0;
        this.pageFormat.setScale(d);
        this.getPageCount();
    }

    public int getZoom() {
        return (int)(this.pageFormat.getScale() * 256.0);
    }

    public Dimension getDimension() {
        int n = (int)this.pageFormat.getImageableWidth();
        int n2 = this.lineSpacing * this.numberOfPages;
        return new Dimension(n, n2);
    }

    public void dispose() {
    }
}

