/*
 * Decompiled with CFR 0.152.
 */
package ice.storm;

import ice.debug.Debug;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.PilotFactory;
import ice.storm.PilotInfo;
import ice.storm.Scripter;
import ice.storm.ScripterInfo;
import ice.storm.StormPropertiesLoader;
import ice.storm.URLClassLoaderFactory;
import ice.util.Defs;
import ice.util.security.SecurityKit;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DefaultFactory
implements PilotFactory,
URLClassLoaderFactory {
    private static final String propFileName = "storm";
    private Vector pilotInfos = new Vector();
    private Vector scripterInfos = new Vector();
    private Hashtable hashByScripterAlias = new Hashtable();
    private Hashtable fileExtToContentType = new Hashtable();

    public void addPilotInfo(PilotInfo pilotInfo) {
        this.pilotInfos.addElement(pilotInfo);
    }

    public void removePilotInfo(PilotInfo pilotInfo) {
        this.pilotInfos.removeElement(pilotInfo);
    }

    public void addScripterInfo(ScripterInfo scripterInfo) {
        if (scripterInfo.aliases != null && scripterInfo.aliases.length > 0) {
            this.scripterInfos.addElement(scripterInfo);
            for (int i = 0; i < scripterInfo.aliases.length; ++i) {
                this.hashByScripterAlias.put(scripterInfo.aliases[i], scripterInfo);
            }
        }
    }

    public void removeScripterInfo(ScripterInfo scripterInfo) {
        if (this.scripterInfos.removeElement(scripterInfo)) {
            for (int i = 0; i < scripterInfo.aliases.length; ++i) {
                this.hashByScripterAlias.remove(scripterInfo.aliases[i]);
            }
        }
    }

    public Enumeration getAllPilotInfos() {
        return this.pilotInfos.elements();
    }

    public Enumeration getAllScripterInfos() {
        return this.scripterInfos.elements();
    }

    public Scripter createScripter(String string) {
        ScripterInfo scripterInfo = this.getScripterInfo(string);
        if (scripterInfo == null) {
            return null;
        }
        Scripter scripter = (Scripter)Defs.newClassInstance((String)scripterInfo.className);
        if (scripter == null) {
            if (Debug.trace) {
                Debug.trace((String)("Failed to load scripter for " + string));
            }
            this.removeScripterInfo(scripterInfo);
            return null;
        }
        scripterInfo.loaded = true;
        return scripter;
    }

    public ScripterInfo getScripterInfo(String string) {
        ScripterInfo scripterInfo = (ScripterInfo)this.hashByScripterAlias.get(string.toLowerCase());
        if (scripterInfo != null && !scripterInfo.enabled) {
            scripterInfo = null;
        }
        return scripterInfo;
    }

    public Pilot createPilot(String string) {
        int n = string.indexOf(59);
        if (n > 0) {
            string = string.substring(0, n);
        }
        Pilot pilot = null;
        block0: for (int i = 0; i < this.pilotInfos.size(); ++i) {
            PilotInfo pilotInfo = (PilotInfo)this.pilotInfos.elementAt(i);
            if (!pilotInfo.enabled) continue;
            for (int j = 0; j < pilotInfo.supportedContentTypes.length; ++j) {
                String string2 = pilotInfo.supportedContentTypes[j];
                if (this.matchContentType(string2, string) && (pilot = this.createPilot(pilotInfo)) != null) break block0;
            }
        }
        return pilot;
    }

    public Pilot createPilot(ContentLoader contentLoader) {
        String string = this.extractContentType(contentLoader);
        return this.createPilot(string);
    }

    private Pilot createPilot(PilotInfo pilotInfo) {
        Pilot pilot;
        block6: {
            pilot = null;
            try {
                if (pilotInfo.cl == null && pilotInfo.codeBaseURLs != null && pilotInfo.codeBaseURLs.length > 0) {
                    pilotInfo.cl = this.createURLClassLoader(pilotInfo.codeBaseURLs);
                }
                Class<?> clazz = pilotInfo.cl != null ? pilotInfo.cl.loadClass(pilotInfo.className) : Class.forName(pilotInfo.className);
                pilot = (Pilot)Defs.newClassInstance(clazz);
            }
            catch (Throwable throwable) {
                if (!Debug.ex) break block6;
                Debug.ex((Throwable)throwable);
            }
        }
        if (pilot != null) {
            pilotInfo.loaded = true;
        } else {
            if (Debug.trace) {
                Debug.trace((String)("Could not load " + pilotInfo.className));
            }
            this.removePilotInfo(pilotInfo);
        }
        return pilot;
    }

    public boolean isContentTypeSupported(Pilot pilot, ContentLoader contentLoader, String string) {
        String string2 = pilot.getClass().getName();
        if (string == null) {
            string = this.extractContentType(contentLoader);
        }
        int n = this.pilotInfos.size() - 1;
        for (int i = 0; i != n; ++i) {
            PilotInfo pilotInfo = (PilotInfo)this.pilotInfos.elementAt(i);
            if (!pilotInfo.enabled || !string2.equals(pilotInfo.className)) continue;
            String[] stringArray = pilotInfo.supportedContentTypes;
            int n2 = stringArray.length;
            for (int j = 0; j != n2; ++j) {
                if (!this.matchContentType(stringArray[j], string)) continue;
                return true;
            }
        }
        return false;
    }

    public ClassLoader createURLClassLoader(URL[] uRLArray) {
        return SecurityKit.newURLClassLoader((URL[])uRLArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDefaultResources() {
        boolean bl;
        block15: {
            Object object;
            block14: {
                String string = Defs.sysProperty((String)"ice.storm.storm");
                bl = false;
                if (string != null) {
                    try {
                        object = new URL(string);
                        InputStream inputStream = ((URL)object).openStream();
                        try {
                            this.loadInfos(inputStream);
                            bl = true;
                        }
                        finally {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {
                        if (Debug.ex) {
                            Debug.ex((Throwable)iOException);
                        }
                        if (!Debug.trace) break block14;
                        Debug.trace((String)("ERROR: failed to load properties from " + string + ", trying built-in."));
                    }
                }
            }
            if (!bl && (object = this.getClass().getResourceAsStream(propFileName)) != null) {
                try {
                    try {
                        this.loadInfos((InputStream)object);
                        bl = true;
                    }
                    finally {
                        ((InputStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    if (!Debug.ex) break block15;
                    Debug.ex((Throwable)iOException);
                }
            }
        }
        if (!bl && Debug.trace) {
            Debug.trace((String)"ERROR: Could not load default storm properties file");
        }
    }

    private void loadInfos(InputStream inputStream) throws IOException {
        int n;
        StormPropertiesLoader stormPropertiesLoader = new StormPropertiesLoader();
        stormPropertiesLoader.loadProperties(inputStream, this.fileExtToContentType);
        Object e = null;
        int n2 = this.pilotInfos.size();
        if (n2 > 0) {
            e = this.pilotInfos.elementAt(n2 - 1);
            this.pilotInfos.removeElementAt(n2 - 1);
        }
        for (n = 0; n < stormPropertiesLoader.infos.size(); ++n) {
            this.pilotInfos.addElement(stormPropertiesLoader.infos.elementAt(n));
        }
        if (e != null) {
            this.pilotInfos.addElement(e);
        }
        for (n = 0; n < stormPropertiesLoader.scripters.size(); ++n) {
            ScripterInfo scripterInfo = (ScripterInfo)stormPropertiesLoader.scripters.elementAt(n);
            this.addScripterInfo(scripterInfo);
        }
    }

    protected String extractContentType(ContentLoader contentLoader) {
        String string = contentLoader.getContentType();
        String string2 = null;
        if (string == null) {
            string2 = this.getExtensionBasedType(contentLoader.getLocation());
        } else {
            int n = (string = string.toLowerCase()).indexOf(59);
            if (n >= 0) {
                string = string.substring(0, n).trim();
            } else if (string.indexOf("unknown") >= 0) {
                string2 = this.getExtensionBasedType(contentLoader.getLocation());
            } else if (string.equalsIgnoreCase("text/html") || string.equalsIgnoreCase("text/plain")) {
                // empty if block
            }
        }
        if (string2 != null) {
            string = string2;
            contentLoader.setContentType(string2);
        }
        return string;
    }

    private String getExtensionBasedType(String string) {
        String string2;
        int n;
        String string3 = "content/unknown";
        String string4 = null;
        if (string != null && (n = string.lastIndexOf(47)) >= 0) {
            int n2 = string.indexOf(35, n + 1);
            int n3 = string.indexOf(63, n + 1);
            int n4 = n2 < 0 || n3 < 0 ? string.length() : (n2 < 0 || n2 > n3 ? n3 : n2);
            int n5 = string.lastIndexOf(46, n4 - 1);
            if (n5 > n && n5 != n4 - 1) {
                string4 = string.substring(n5, n4);
            }
        }
        if (string4 != null && (string2 = (String)this.fileExtToContentType.get(string4)) != null) {
            string3 = string2;
        }
        return string3;
    }

    private boolean matchContentType(String string, String string2) {
        if (string.indexOf(42) < 0) {
            return string.equals(string2);
        }
        int n = string.indexOf(47);
        if (n < 0) {
            return string.length() == 1;
        }
        String string3 = string.substring(0, n);
        String string4 = string.substring(n + 1);
        return !(!string3.equals("*") && !string2.startsWith(string3) || !string4.equals("*") && !string2.endsWith(string4));
    }
}

