/*
 * Decompiled with CFR 0.152.
 */
package ice.storm.print.jdk12;

import ice.debug.Debug;
import ice.storm.print.StormPageFormat;
import ice.util.unit.PointUnit;
import ice.util.unit.Unit;
import java.awt.print.PageFormat;
import java.awt.print.Paper;

public class PageFormatConverter {
    public static PageFormat getPageFormat(StormPageFormat stormPageFormat) {
        if (stormPageFormat == null) {
            stormPageFormat = new StormPageFormat();
        }
        int n = stormPageFormat.getOrientation();
        PageFormat pageFormat = new PageFormat();
        Paper paper = new Paper();
        switch (n) {
            case 1: {
                pageFormat.setOrientation(1);
                paper.setSize(stormPageFormat.getPageWidth(), stormPageFormat.getPageHeight());
                paper.setImageableArea(stormPageFormat.getMargin(2) + stormPageFormat.getPageGutter(), stormPageFormat.getMargin(1), stormPageFormat.getImageableWidth(), stormPageFormat.getImageableHeight());
                break;
            }
            case 0: {
                pageFormat.setOrientation(0);
                paper.setSize(stormPageFormat.getPageHeight(), stormPageFormat.getPageWidth());
                paper.setImageableArea(stormPageFormat.getMargin(1), stormPageFormat.getMargin(2) + stormPageFormat.getPageGutter(), stormPageFormat.getImageableHeight(), stormPageFormat.getImageableWidth());
            }
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public static StormPageFormat getStormPageFormat(PageFormat pageFormat) {
        if (pageFormat == null) {
            pageFormat = new PageFormat();
        }
        StormPageFormat stormPageFormat = new StormPageFormat();
        if (pageFormat.getOrientation() == 1) {
            stormPageFormat.setOrientation(1);
        } else if (pageFormat.getOrientation() == 0) {
            stormPageFormat.setOrientation(0);
        } else {
            Debug.trace((String)("Unknown Orientation " + pageFormat.getOrientation()));
        }
        stormPageFormat.setMargin((Unit)new PointUnit(pageFormat.getImageableX()), 2);
        stormPageFormat.setMargin((Unit)new PointUnit(pageFormat.getWidth() - pageFormat.getImageableWidth() - pageFormat.getImageableX()), 4);
        stormPageFormat.setMargin((Unit)new PointUnit(pageFormat.getImageableY()), 1);
        stormPageFormat.setMargin((Unit)new PointUnit(pageFormat.getHeight() - pageFormat.getImageableHeight() - pageFormat.getImageableY()), 3);
        stormPageFormat.setPageSize((Unit)new PointUnit(pageFormat.getWidth()), (Unit)new PointUnit(pageFormat.getHeight()));
        return stormPageFormat;
    }
}

