/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.scomp;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MGridLayout;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJPanel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.border.Border;

public class SystemObjectsPrefsPanel
extends MJPanel {
    private static SystemObjectsPrefsPanel sPrefsPanel;
    private static ResourceBundle sRes;
    static MJPanel mSystemObjectPanel;
    private MJCheckBox mFixptPropsDisplayCheckBox;

    private SystemObjectsPrefsPanel() {
        this.setName("SystemObjectsPrefsPanel");
        this.setLayout((LayoutManager)new MGridLayout(0, 1, 10, 10, 131072));
        mSystemObjectPanel = new MJPanel((LayoutManager)new MGridLayout(0, 1, 8, 8, 131072));
        mSystemObjectPanel.setBorder((Border)BorderFactory.createTitledBorder(sRes.getString("systemobjects.title")));
        this.add((Component)mSystemObjectPanel);
        this.mFixptPropsDisplayCheckBox = new MJCheckBox(sRes.getString("systemobjects.fixptPropsDisp"));
        mSystemObjectPanel.add((Component)this.mFixptPropsDisplayCheckBox);
        this.mFixptPropsDisplayCheckBox.setName("SystemObjectsFixptDisplayCheckbox");
        this.setEnabled(false);
    }

    public void setEnabled(boolean bl) {
        this.mFixptPropsDisplayCheckBox.setEnabled(bl);
    }

    private SystemObjectPrefs getPreferences() {
        SystemObjectPrefs systemObjectPrefs = new SystemObjectPrefs();
        systemObjectPrefs.fixptPropsDisplay = this.mFixptPropsDisplayCheckBox.isSelected();
        return systemObjectPrefs;
    }

    private void setPreferences(SystemObjectPrefs systemObjectPrefs) {
        if (systemObjectPrefs.fixptPropsDisplay) {
            this.mFixptPropsDisplayCheckBox.setSelected(true);
        } else {
            this.mFixptPropsDisplayCheckBox.setSelected(false);
        }
    }

    public static MJPanel createPrefsPanel() {
        if (sPrefsPanel == null) {
            sPrefsPanel = new SystemObjectsPrefsPanel();
        }
        sPrefsPanel.setEnabled(false);
        GetprefWorker getprefWorker = new GetprefWorker();
        getprefWorker.start();
        return sPrefsPanel;
    }

    public static boolean validatePrefsPanel() {
        return true;
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl && sPrefsPanel != null) {
            SetprefWorker setprefWorker = new SetprefWorker();
            setprefWorker.start();
        }
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"dsp", (String)"dsp"), "showFixptProp"};
    }

    static /* synthetic */ SystemObjectPrefs access$200(SystemObjectsPrefsPanel systemObjectsPrefsPanel) {
        return systemObjectsPrefsPanel.getPreferences();
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.toolbox.shared.scomp.resources.RES_systemobjects_prefs_localized");
    }

    private static class GetprefWorker
    extends MatlabWorker {
        private SystemObjectPrefs prefs = new SystemObjectPrefs();

        private GetprefWorker() {
        }

        public Object runOnMatlabThread() {
            Object object;
            try {
                Object[] objectArray = new Object[]{"SystemObjects", "DisplayFixedPointProperties", false};
                object = GetprefWorker.feval((String)"getpref", (Object[])objectArray, (int)1, (boolean)false);
                boolean[] blArray = (boolean[])object;
                this.prefs.fixptPropsDisplay = blArray[0];
            }
            catch (Exception exception) {
                object = "Error " + exception.getMessage();
                System.out.println(object);
            }
            return object;
        }

        public void runOnAWTEventDispatchThread(Object object) {
            sPrefsPanel.setPreferences(this.prefs);
            sPrefsPanel.setEnabled(true);
            sPrefsPanel.validate();
            sPrefsPanel.repaint();
        }
    }

    private static class SetprefWorker
    extends MatlabWorker {
        private SystemObjectPrefs prefs = SystemObjectsPrefsPanel.access$200(SystemObjectsPrefsPanel.access$100());

        SetprefWorker() {
        }

        public Object runOnMatlabThread() {
            Object object;
            try {
                Object[] objectArray = new Object[]{"SystemObjects", "DisplayFixedPointProperties", this.prefs.fixptPropsDisplay};
                object = SetprefWorker.feval((String)"setpref", (Object[])objectArray, (int)0, (boolean)false);
            }
            catch (Exception exception) {
                object = "Error " + exception.getMessage().replaceAll("\n", " ");
                System.out.println(object);
            }
            return object;
        }

        public void runOnAWTEventDispatchThread(Object object) {
        }
    }

    private static class SystemObjectPrefs {
        boolean fixptPropsDisplay = false;

        private SystemObjectPrefs() {
        }
    }
}

