/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.appmanagement;

import com.mathworks.appmanagement.AppManagementMatlabWorker;
import com.mathworks.jmi.MatlabWorker;
import java.util.concurrent.Semaphore;

abstract class AbstractAppManagementMatlabWorker<V>
extends MatlabWorker<V>
implements AppManagementMatlabWorker<V> {
    private final Semaphore semaphore;
    private Exception exception;
    private V result;

    AbstractAppManagementMatlabWorker(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    public final V runOnMatlabThread() throws Exception {
        try {
            V v = this.result = this.doOnMatlabThread();
            return v;
        }
        catch (Exception exception) {
            this.exception = exception;
            throw exception;
        }
        finally {
            this.semaphore.release();
        }
    }

    protected abstract V doOnMatlabThread() throws Exception;

    protected final void handleException(Exception exception, boolean bl) {
    }

    public final void runOnAWTEventDispatchThread(V v) {
    }

    @Override
    public final void go() {
        try {
            this.semaphore.acquire();
            this.exception = null;
            super.start();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final V get() throws Exception {
        this.semaphore.acquire();
        try {
            if (this.exception != null) {
                throw this.exception;
            }
            V v = this.result;
            return v;
        }
        finally {
            this.semaphore.release();
        }
    }
}

