/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.ProcessExecutor;
import com.mathworks.instutil.StreamGobbler;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ProcessExecutorImpl
implements ProcessExecutor {
    private static final long DEFAULT_TIMEOUT = 60000L;

    @Override
    public int executeWithTimeout(Process process, String[] stringArray, long l) throws IOException, TimeoutException {
        Timer timer = new Timer();
        timer.schedule((TimerTask)new InterruptScheduler(Thread.currentThread()), l);
        int n = -1;
        try {
            ProcessExecutorImpl.gobbleStreams(process);
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            process.destroy();
            String string = "";
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (string.length() > 0) {
                        string = string.concat(" ");
                    }
                    string = string.concat(string2);
                }
            }
            TimeoutException timeoutException = new TimeoutException("External process (" + string + ") did not return after " + l + " milliseconds");
            timeoutException.initCause(interruptedException);
            throw timeoutException;
        }
        finally {
            timer.cancel();
        }
        return n;
    }

    int executeWithTimeoutUsingFuture(final Process process, String[] stringArray, long l, ExecutorService executorService) throws ExecutionException, TimeoutException, InterruptedException {
        int n = -1;
        Callable<Integer> callable = new Callable<Integer>(){

            @Override
            public Integer call() throws InterruptedException {
                process.waitFor();
                return process.exitValue();
            }
        };
        Future<Integer> future = executorService.submit(callable);
        try {
            ProcessExecutorImpl.gobbleStreams(process);
            n = future.get(l, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            process.destroy();
            String string = "";
            if (stringArray != null) {
                for (String string2 : stringArray) {
                    if (string.length() > 0) {
                        string = string.concat(" ");
                    }
                    string = string.concat(string2);
                }
            }
            TimeoutException timeoutException2 = new TimeoutException("External process (" + string + ") did not return after " + l + " milliseconds");
            timeoutException2.initCause(timeoutException);
            throw timeoutException2;
        }
        finally {
            future.cancel(true);
        }
        return n;
    }

    @Override
    public int executeWithTimeout(Process process, long l) throws IOException, TimeoutException {
        return this.executeWithTimeout(process, null, l);
    }

    @Override
    public int executeWithTimeout(Process process) throws IOException, TimeoutException {
        return this.executeWithTimeout(process, 60000L);
    }

    @Override
    public int executeWithTimeout(String[] stringArray) throws IOException, TimeoutException {
        return this.executeWithTimeout(stringArray, 60000L);
    }

    @Override
    public int executeWithTimeout(String[] stringArray, long l) throws IOException, TimeoutException {
        Process process = this.start(stringArray);
        return this.executeWithTimeout(process, stringArray, l);
    }

    @Override
    public int runtimeExecWithTimeout(String[] stringArray, long l, ExecutorService executorService) throws TimeoutException, IOException, ExecutionException, InterruptedException {
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(stringArray);
        return this.executeWithTimeoutUsingFuture(process, stringArray, l, executorService);
    }

    @Override
    public Process start(String[] stringArray) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
        return ProcessExecutorImpl.start(processBuilder);
    }

    @Override
    public Process start(String[] stringArray, File file) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(stringArray).directory(file);
        return ProcessExecutorImpl.start(processBuilder);
    }

    private static Process start(ProcessBuilder processBuilder) throws IOException {
        Process process = processBuilder.start();
        ProcessExecutorImpl.gobbleStreams(process);
        return process;
    }

    private static void gobbleStreams(Process process) {
        StreamGobbler streamGobbler = new StreamGobbler(process.getErrorStream());
        StreamGobbler streamGobbler2 = new StreamGobbler(process.getInputStream());
        streamGobbler.start();
        streamGobbler2.start();
    }

    private static class InterruptScheduler
    extends TimerTask {
        private Thread target = null;

        InterruptScheduler(Thread thread) {
            this.target = thread;
        }

        @Override
        public void run() {
            this.target.interrupt();
        }
    }
}

