/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.toolbox.testmeas.propertyeditor.HelpWindow;
import com.mathworks.toolbox.testmeas.propertyeditor.IPropertySetter;
import com.mathworks.toolbox.testmeas.propertyeditor.Property;
import com.mathworks.toolbox.testmeas.propertyeditor.PropertyContainer;
import com.mathworks.toolbox.testmeas.propertyeditor.PropertyWidgetMap;
import com.mathworks.toolbox.testmeas.propertyeditor.RadioButtonWidget;
import com.mathworks.toolbox.testmeas.propertyeditor.ReadStatus;
import com.mathworks.toolbox.testmeas.propertyeditor.UIConstants;
import com.mathworks.toolbox.testmeas.propertyeditor.Widget;
import com.mathworks.toolbox.testmeas.tmswing.TMAbstractStyleGuideJPanel;
import com.mathworks.toolbox.testmeas.tmswing.TMStyleGuideRelatedJPanel;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class EditorPanel
implements PropertyContainer {
    private IPropertySetter fPropertySetter;
    private final Map<Property, Widget> fWidgetPropertyStore = new LinkedHashMap<Property, Widget>();
    private PropertyWidgetMap fPropertyWidgetMap;
    private TMAbstractStyleGuideJPanel fEditorContainer = new TMStyleGuideRelatedJPanel();
    private boolean fShowWhatIsThisMenu = true;
    private boolean fSortLabels;
    private boolean fShowResetToDefaultButton = true;
    private final MJButton fResetDefaultButton = new MJButton(UIConstants.getResourceBundle().getString("PropertyEditor.resetToDefault"));
    private int fLabelAlignment = 4;
    private String fLabelColonSpacing = " ";

    public EditorPanel(IPropertySetter iPropertySetter, PropertyWidgetMap propertyWidgetMap, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.fPropertySetter = iPropertySetter;
        this.fPropertyWidgetMap = propertyWidgetMap;
        this.fShowResetToDefaultButton = bl;
        this.fShowWhatIsThisMenu = bl2;
        this.fSortLabels = bl3;
        this.fLabelColonSpacing = bl4 ? " " : "";
    }

    @Override
    public TMAbstractStyleGuideJPanel getPropertyContainer() {
        return this.fEditorContainer;
    }

    @Override
    public void setProperties(List<Property> list) {
        this.fWidgetPropertyStore.clear();
        if (this.fSortLabels) {
            TreeSet<String> treeSet = new TreeSet<String>();
            Hashtable<String, Property> hashtable = new Hashtable<String, Property>();
            for (Property object : list) {
                treeSet.add(object.getName());
                hashtable.put(object.getName(), object);
            }
            for (String string : treeSet) {
                this.fWidgetPropertyStore.put((Property)hashtable.get(string), NullWidget.NULL_WIDGET);
            }
        } else {
            for (Property property : list) {
                this.fWidgetPropertyStore.put(property, NullWidget.NULL_WIDGET);
            }
        }
    }

    @Override
    public void enableWhileRunningProperties(boolean bl) {
        for (Property property : this.fWidgetPropertyStore.keySet()) {
            if (property.getReadStauts() != ReadStatus.WHILE_RUNNING) continue;
            this.fWidgetPropertyStore.get(property).enableWidget(bl);
        }
    }

    @Override
    public void draw() {
        this.fEditorContainer.setName("PropertiesPanel");
        if (this.fShowResetToDefaultButton) {
            this.addResetToDefaultButton();
        }
        double d = 0.0;
        double d2 = 0.0;
        ArrayList<MJLabel> arrayList = new ArrayList<MJLabel>();
        for (Property object : this.fWidgetPropertyStore.keySet()) {
            Widget widget = this.fPropertyWidgetMap.getWidget(object);
            TMAbstractStyleGuideJPanel tMAbstractStyleGuideJPanel = widget.getWidget();
            this.fWidgetPropertyStore.put(object, widget);
            MJLabel mJLabel = this.createWidgetLabel(object);
            arrayList.add(mJLabel);
            if (widget instanceof RadioButtonWidget) {
                mJLabel.setAlignmentY(0.0f);
                tMAbstractStyleGuideJPanel.setAlignmentY(0.0f);
            }
            Dimension dimension = mJLabel.getPreferredSize();
            d = Math.max(d, dimension.getWidth());
            if (d2 == 0.0) {
                d2 = dimension.getHeight();
            }
            MJPanel mJPanel = new MJPanel();
            mJPanel.setLayout((LayoutManager)new BoxLayout((Container)mJPanel, 2));
            mJPanel.add((Component)mJLabel);
            mJPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            mJPanel.add((Component)((Object)tMAbstractStyleGuideJPanel));
            this.fEditorContainer.addLine((JComponent)mJPanel);
            if (!this.fShowWhatIsThisMenu) continue;
            this.addHelpContextMenu(mJLabel);
        }
        Dimension dimension = new Dimension((int)d, (int)d2);
        for (MJLabel mJLabel : arrayList) {
            mJLabel.setPreferredSize(dimension);
        }
        this.fEditorContainer.revalidate();
        this.fEditorContainer.repaint();
    }

    @Override
    public void destroy() {
        ActionListener[] actionListenerArray = this.fWidgetPropertyStore.values().iterator();
        while (actionListenerArray.hasNext()) {
            ActionListener[] actionListenerArray2 = actionListenerArray.next();
            actionListenerArray2.destroy();
        }
        for (ActionListener actionListener : actionListenerArray = this.fResetDefaultButton.getActionListeners()) {
            this.fResetDefaultButton.removeActionListener(actionListener);
        }
    }

    @Override
    public List<Property> getProperties() {
        return new ArrayList<Property>(this.fWidgetPropertyStore.keySet());
    }

    @Override
    public void setLabelAlignment(boolean bl) {
        this.fLabelAlignment = bl ? 2 : 4;
    }

    private void addResetToDefaultButton() {
        this.fResetDefaultButton.setName("ResetToDefaultsButton");
        this.fResetDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EditorPanel.this.fPropertySetter.setToDefault(new ArrayList<Property>(EditorPanel.this.fWidgetPropertyStore.keySet()));
            }
        });
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new FlowLayout(2, 0, 0));
        mJPanel.add((Component)this.fResetDefaultButton);
        this.fEditorContainer.addLine((JComponent)mJPanel);
    }

    private MJLabel createWidgetLabel(Property property) {
        MJLabel mJLabel = new MJLabel();
        String string = property.getUserFriendlyLabel().length() > 0 ? property.getUserFriendlyLabel() : TMStringUtil.splitOnUpperCase(property.getName());
        mJLabel.setText(string + this.fLabelColonSpacing + ":");
        mJLabel.setName(property.getName() + "Label");
        mJLabel.setHorizontalAlignment(this.fLabelAlignment);
        return mJLabel;
    }

    private void addHelpContextMenu(final MJLabel mJLabel) {
        final MJPopupMenu mJPopupMenu = new MJPopupMenu();
        mJPopupMenu.setName("WhatIsThismenu");
        MJMenuItem mJMenuItem = new MJMenuItem(UIConstants.getResourceBundle().getString("PropertyEditor.helpContextMenu"));
        mJMenuItem.setName("WhatIsThismenuitem");
        mJPopupMenu.add((JMenuItem)mJMenuItem);
        mJLabel.add((Component)mJPopupMenu);
        mJLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showPopup(mouseEvent);
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    mJPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        mJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HelpWindow helpWindow = new HelpWindow(UIConstants.getResourceBundle().getString("PropertyEditor.helpWindowTitle"), mJLabel.getText().replaceAll(":", ""), new Dimension(300, 400), EditorPanel.this.fWidgetPropertyStore.keySet());
                helpWindow.show();
            }
        });
    }

    private static class NullWidget
    extends Widget {
        private static final NullWidget NULL_WIDGET = new NullWidget(null, new Property());

        private NullWidget(IPropertySetter iPropertySetter, Property property) {
            super(iPropertySetter, property);
        }

        @Override
        public void addContent(TMAbstractStyleGuideJPanel tMAbstractStyleGuideJPanel) {
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void displayValue(Object object) {
        }

        @Override
        public void enableWidget(boolean bl) {
        }
    }
}

