/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.tmswing.table;

import com.mathworks.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ColumnInfo {
    private String fName;
    private boolean fEditable;
    private List fData;
    private Map<Integer, Pair<Annotation, String>> fAnnotationMessageMap = new HashMap<Integer, Pair<Annotation, String>>();
    private static final Pair<Annotation, String> NORMAL_ANNOTATION_MESSAGE = new Pair((Object)Annotation.NORMAL, (Object)"");

    public ColumnInfo(List list, String string, boolean bl) {
        assert (string != null) : "column name cannot be null or empty.";
        this.setData(list);
        this.fName = string;
        this.fEditable = bl;
    }

    public Class getColumnClass() {
        if (this.fData.isEmpty()) {
            return String.class;
        }
        return this.fData.get(0).getClass();
    }

    public String getName() {
        return this.fName;
    }

    public Object getValueAtRow(int n) {
        assert (n >= 0 && n < this.fData.size()) : "Invalid index in getColumnValue";
        return this.fData.get(n);
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public int getLength() {
        return this.fData.size();
    }

    protected void setData(List list) {
        assert (list != null) : "column data must not be null";
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            list.set(i, this.convertData(e));
        }
        this.fData = list;
    }

    protected void setData(int n, Object object) {
        assert (n <= this.fData.size()) : "invalid row index : " + n;
        this.fData.set(n, this.convertData(object));
    }

    protected void setAnnotationMessage(int n, Annotation annotation, String string) {
        assert (n <= this.fData.size()) : "invalid row index : " + n;
        if (annotation == Annotation.NORMAL) {
            this.fAnnotationMessageMap.remove(n);
            return;
        }
        assert (string != null && string.length() > 0) : "message cannot be null or empty";
        this.fAnnotationMessageMap.put(n, (Pair<Annotation, String>)new Pair((Object)annotation, (Object)string));
    }

    public Pair<Annotation, String> getAnnotationMessage(int n) {
        assert (n <= this.fData.size()) : "invalid row index : " + n;
        if (this.fAnnotationMessageMap.containsKey(n)) {
            return this.fAnnotationMessageMap.get(n);
        }
        return NORMAL_ANNOTATION_MESSAGE;
    }

    private Object convertData(Object object) {
        assert (object != null && (object instanceof String || object instanceof Boolean || object instanceof Character)) : "cell data must not be a non-null boolean , character or string";
        if (object instanceof Character) {
            return String.valueOf(object);
        }
        return object;
    }

    public static enum Annotation {
        NORMAL,
        WARNING,
        ERROR;

    }
}

