/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractFigureFrameProxy;
import com.mathworks.hg.peer.AcceleratorEventNotification;
import com.mathworks.hg.peer.FigureFrameProxyBase;
import com.mathworks.hg.peer.FigureMenuBarNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigureToolBarNotification;
import com.mathworks.hg.peer.FigureWindowListener;
import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.ControlKeyInterceptor;
import com.mathworks.util.NativeJava;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTSingleClientFrame;
import com.mathworks.widgets.desk.DTToolBarContainer;
import com.mathworks.widgets.desk.Desktop;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class FigureFrameProxy
implements FigureFrameProxyBase,
AbstractFigureFrameProxy {
    private FigureFrame fFrame;
    private boolean fModal;
    private boolean fResizable;
    private FigureNotificationHandlerImpl fNotificationHandler;
    private FigureWindowListener fFigureWindowListener;
    private FigureFrameAdapter fFrameAdapter = new FigureFrameAdapter();
    private boolean fFrameShown = false;
    private JButton fDefaultButton;
    private String fName;

    public FigureFrameProxy() {
        this.fNotificationHandler = new FigureNotificationHandlerImpl();
        this.fFigureWindowListener = new FigureWindowListener();
        this.fFigureWindowListener.setNotificationSuccessor(this);
    }

    @Override
    public void setModal(boolean bl) {
        if (this.fModal != bl) {
            if (this.fFrame != null) {
                this.fFrame.setModal(bl);
            }
            this.fModal = bl;
        }
    }

    @Override
    public boolean isModal() {
        return this.fModal;
    }

    @Override
    public DTSingleClientFrame createFigurePeerFrame(Desktop desktop, String string, boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fFrame != null) {
            assert (bl);
            return this.fFrame;
        }
        this.fFrame = new FigureFrame(desktop, string);
        this.fFrame.addComponentListener(this.fFrameAdapter);
        this.fFrame.setResizable(this.fResizable);
        this.fFrame.addWindowListener(this.fFigureWindowListener);
        this.fFrame.addWindowStateListener(this.fFigureWindowListener);
        return this.fFrame;
    }

    public void setMaximized(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fFrame.setMaximized(bl);
    }

    public boolean isMaximized() {
        return this.fFrame != null && this.fFrame.isMaximized();
    }

    public boolean isMinimized() {
        return this.fFrame != null && this.fFrame.isMinimized();
    }

    public void setMinimized(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fFrame.setMinimized(bl);
    }

    public void setName(String string) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fName = string;
        if (this.fFrame != null && this.fName != null) {
            this.fFrame.setName(this.fName);
        }
    }

    public void repaint() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.fFrame != null) {
            this.fFrame.repaint();
        }
    }

    public DTToolBarContainer getToolBarContainer() {
        return this.fFrame.getToolBar();
    }

    public void setResizable(boolean bl) {
        this.fResizable = bl;
        if (this.fFrame != null) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    FigureFrameProxy.this.fFrame.setResizable(FigureFrameProxy.this.fResizable);
                }
            };
            FigurePeer.runOnEDT(runnable);
        }
    }

    public boolean isResizable() {
        return this.fResizable;
    }

    @Override
    public boolean isShowing() {
        return this.fFrame != null;
    }

    private static void doDispose(Window window) {
        assert (SwingUtilities.isEventDispatchThread());
        try {
            window.dispose();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void dispose() {
        if (this.fFrame != null) {
            this.fFrame.setDefaultCloseOperation(2);
            FigureFrameProxy.doDispose((Window)((Object)this.fFrame));
            this.fFrame = null;
        }
        this.setNotificationSuccessor(null);
    }

    public void toFront() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fFrame.toFront();
    }

    public void validate() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fFrame.getRootPane().validate();
    }

    public void addComponentListener(ComponentListener componentListener) {
        this.fFrame.addComponentListener(componentListener);
    }

    public void removeComponentListener(ComponentListener componentListener) {
        this.fFrame.removeComponentListener(componentListener);
    }

    public void addWindowListener(WindowListener windowListener) {
        this.fFrame.addWindowListener(windowListener);
    }

    public void addWindowStateListener(WindowStateListener windowStateListener) {
        this.fFrame.addWindowStateListener(windowStateListener);
    }

    public void removeWindowListener(WindowListener windowListener) {
        this.fFrame.removeWindowListener(windowListener);
    }

    public void setTitle(String string) {
        assert (SwingUtilities.isEventDispatchThread());
        this.fFrame.setTitle(string);
    }

    @Override
    public Rectangle getBounds() {
        return this.fFrame.getBounds();
    }

    @Override
    public void pack() {
        assert (SwingUtilities.isEventDispatchThread());
        this.fFrame.pack();
    }

    void setDefaultButton(JButton jButton) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.isShowing()) {
            this.fFrame.getRootPane().setDefaultButton(jButton);
        } else {
            this.fDefaultButton = jButton;
        }
    }

    @Override
    public Insets getInsets() {
        return this.fFrame.getInsets();
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        this.fNotificationHandler.handleNotification(figureNotification);
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    @Override
    public void fireToolbarContainerEvent(int n) {
        this.handleNotification(new FigureToolBarNotification(n));
    }

    public void fireToolbarContainerEvent() {
        DTToolBarContainer dTToolBarContainer = this.getToolBarContainer();
        int n = 0;
        if (dTToolBarContainer != null) {
            n = dTToolBarContainer.getHeight();
        }
        this.fireToolbarContainerEvent(n);
    }

    @Override
    public void fireToolbarPreferredHeight(JToolBar[] jToolBarArray, boolean bl) {
        if (this.isShowing()) {
            if (this.getToolBarContainer() != null) {
                this.fireToolbarContainerPreferredHeight();
            }
        } else if (jToolBarArray != null && jToolBarArray.length > 0) {
            int n = 0;
            for (JToolBar jToolBar : jToolBarArray) {
                n += jToolBar.getPreferredSize().height;
            }
            n += 2 * (jToolBarArray.length - 1);
            if (bl) {
                n += 2;
            }
            this.fireToolbarContainerEvent(n);
        }
    }

    protected void fireToolbarContainerPreferredHeight() {
        DTToolBarContainer dTToolBarContainer = this.getToolBarContainer();
        if (dTToolBarContainer != null) {
            int n = dTToolBarContainer.getPreferredSize().height;
            this.fireToolbarContainerEvent(n);
        }
    }

    private class FigureFrameAdapter
    extends ComponentAdapter {
        private FigureFrameAdapter() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            FigureFrameProxy.this.fFrameShown = true;
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            FigureFrameProxy.this.fFrameShown = false;
        }
    }

    private class FigureFrameKeyAdapter
    implements KeyListener {
        FigureFrameKeyAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            FigureFrameProxy.this.fNotificationHandler.sendJavaEventNotification(keyEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            FigureFrameProxy.this.fNotificationHandler.sendJavaEventNotification(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            FigureFrameProxy.this.fNotificationHandler.sendJavaEventNotification(keyEvent);
        }
    }

    private class ToolbarContainerAdapter
    extends ComponentAdapter {
        private ToolbarContainerAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            if (FigureFrameProxy.this.fFrameShown) {
                FigureFrameProxy.this.fireToolbarContainerEvent();
            }
        }
    }

    private class FigureFrame
    extends DTSingleClientFrame
    implements ControlKeyInterceptor {
        private ToolbarContainerAdapter fToolbarContainerAdapter;
        private boolean fUsingNativeEvents;
        private FigureFrameKeyAdapter fKeyListener;
        private boolean disposing;

        public FigureFrame() {
            this.fToolbarContainerAdapter = null;
            this.fUsingNativeEvents = false;
            this.disposing = false;
        }

        public void processControlKey(KeyEvent keyEvent) {
            FigureFrameProxy.this.fNotificationHandler.handleNotification(new AcceleratorEventNotification((Object)this, keyEvent));
        }

        FigureFrame(Desktop desktop, String string) {
            super(desktop, string);
            this.fToolbarContainerAdapter = null;
            this.fUsingNativeEvents = false;
            this.disposing = false;
            super.useToFront(false);
            this.fKeyListener = new FigureFrameKeyAdapter();
            this.addKeyListener(this.fKeyListener);
        }

        protected boolean supportDesktopNavigationBindings() {
            return false;
        }

        public void setResizable(boolean bl) {
            super.setResizable(bl);
            this.validate();
        }

        public void dispose() {
            if (this.disposing) {
                return;
            }
            this.disposing = true;
            this.setEnabled(false);
            this.setVisible(false);
            FigureFrameProxy.this.fFrameShown = false;
            this.setModal(false);
            this.getRootPane().getInputMap(2).setParent(null);
            this.removeWindowListener(FigureFrameProxy.this.fFigureWindowListener);
            this.removeComponentListener(FigureFrameProxy.this.fFrameAdapter);
            this.removeKeyListener(this.fKeyListener);
            FigureFrameProxy.this.fFrame = null;
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        FigureFrame.super.dispose();
                    }
                    finally {
                        FigureFrame.this.disposing = false;
                    }
                }
            };
            if (Matlab.isMatlabAvailable()) {
                EventQueue.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }

        public DTToolBarContainer getToolBar() {
            return this.getToolBarContainer();
        }

        DTClient getDTClient() {
            return this.fClient;
        }

        public void addNotify() {
            DTToolBarContainer dTToolBarContainer;
            super.addNotify();
            this.setModal(FigureFrameProxy.this.fModal);
            if (null != FigureFrameProxy.this.fName) {
                this.setName(FigureFrameProxy.this.fName);
            }
            if ((dTToolBarContainer = this.getToolBar()) != null) {
                FigureFrameProxy.this.fireToolbarContainerPreferredHeight();
                if (this.fToolbarContainerAdapter == null) {
                    this.fToolbarContainerAdapter = new ToolbarContainerAdapter();
                    dTToolBarContainer.addComponentListener((ComponentListener)this.fToolbarContainerAdapter);
                }
            }
            FigureMenuBarNotification figureMenuBarNotification = new FigureMenuBarNotification(4, 0, null);
            FigureFrameProxy.this.handleNotification(figureMenuBarNotification);
            if (FigureFrameProxy.this.fDefaultButton != null) {
                this.getRootPane().setDefaultButton(FigureFrameProxy.this.fDefaultButton);
                FigureFrameProxy.this.fDefaultButton = null;
            }
        }

        public void removeNotify() {
            DTToolBarContainer dTToolBarContainer;
            if (this.fUsingNativeEvents) {
                NativeJava.disableNativeEvents((long)this.getHWnd());
                this.fUsingNativeEvents = false;
            }
            if (this.fToolbarContainerAdapter != null && (dTToolBarContainer = this.getToolBar()) != null) {
                dTToolBarContainer.removeComponentListener((ComponentListener)this.fToolbarContainerAdapter);
                this.fToolbarContainerAdapter = null;
            }
            super.removeNotify();
        }
    }
}

