/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.FigureMenuBarNotification;
import com.mathworks.hg.peer.FigureNotification;
import com.mathworks.hg.peer.FigureNotificationHandler;
import com.mathworks.hg.peer.FigureNotificationHandlerImpl;
import com.mathworks.mwswing.MJMenuBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.SwingUtilities;

public class FigureMenuBar
extends MJMenuBar
implements FigureNotificationHandler {
    private FigureNotificationHandlerImpl fNotificationHandler = new FigureNotificationHandlerImpl();

    public FigureMenuBar() {
        this.setMoreMenuEnabled(false);
        this.init();
    }

    protected void init() {
        ComponentTracker componentTracker = new ComponentTracker();
        this.addComponentListener(componentTracker);
        FigureMenuBarContainerListener figureMenuBarContainerListener = new FigureMenuBarContainerListener();
        this.addContainerListener(figureMenuBarContainerListener);
        this.addComponentListener(figureMenuBarContainerListener);
    }

    @Override
    public void handleNotification(FigureNotification figureNotification) {
        this.fNotificationHandler.handleNotification(figureNotification);
    }

    @Override
    public FigureNotificationHandler getNotificationSuccessor() {
        return this.fNotificationHandler.getNotificationSuccessor();
    }

    @Override
    public void setNotificationSuccessor(FigureNotificationHandler figureNotificationHandler) {
        this.fNotificationHandler.setNotificationSuccessor(figureNotificationHandler);
    }

    public void addNotify() {
        super.addNotify();
        this.calculatePreferredMenuBarHeight();
    }

    private void calculateMenuBarHeight() {
        int n = this.getHeight();
        this.fireMenuBarSizeChanged(n);
    }

    public void calculatePreferredMenuBarHeight() {
        int n = this.getPreferredSize().height;
        this.fireMenuBarSizeChanged(n);
    }

    public void preShowFigureMenuBar() {
        this.calculatePreferredMenuBarHeight();
    }

    public void preHideFigureMenuBar() {
        this.fireMenuBarSizeChanged(0);
    }

    void showMenuBar() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call showMenuBar from Event dispatch thread");
        }
        this.fireMenuBarAdded();
        this.preShowFigureMenuBar();
    }

    void hideMenuBar() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new Error("Must call hideMenuBar from Event dispatch thread");
        }
        this.fireMenuBarRemoved();
        this.preHideFigureMenuBar();
    }

    private void fireNotification(int n, int n2, MJMenuBar mJMenuBar) {
        FigureMenuBarNotification figureMenuBarNotification = new FigureMenuBarNotification(n, n2, mJMenuBar);
        this.fNotificationHandler.handleNotification(figureMenuBarNotification);
    }

    private void fireMenuBarSizeChanged(int n) {
        this.fireNotification(1, n, null);
    }

    private void fireMenuBarAdded() {
        this.fireNotification(2, 0, this);
    }

    private void fireMenuBarRemoved() {
        this.fireNotification(3, 0, this);
    }

    private class FigureMenuBarContainerListener
    extends ComponentAdapter
    implements ContainerListener {
        private boolean fInShowMenuBarExecution = false;

        private FigureMenuBarContainerListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component;
            int n = ((Container)containerEvent.getSource()).getComponentCount();
            if ((n == 1 && !FigureMenuBar.this.hasMoreMenu() || n == 2 && FigureMenuBar.this.hasMoreMenu()) && !this.fInShowMenuBarExecution) {
                this.fInShowMenuBarExecution = true;
                FigureMenuBar.this.showMenuBar();
                this.fInShowMenuBarExecution = false;
            }
            if ((component = containerEvent.getComponent()) != null) {
                component.repaint();
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            int n;
            Object object = containerEvent.getSource();
            if (object != null && ((n = ((Container)object).getComponentCount()) == 0 || n == 1 && FigureMenuBar.this.hasMoreMenu())) {
                FigureMenuBar.this.hideMenuBar();
            }
        }
    }

    private class ComponentTracker
    extends ComponentAdapter {
        private ComponentTracker() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            FigureMenuBar.this.calculateMenuBarHeight();
        }
    }
}

