/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.CDataGrabber;
import com.mathworks.hg.peer.DebugUtilities;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.JavaSceneServerPeerAdapter;
import com.mathworks.hg.peer.JavaSceneServerPeerInterface;
import com.mathworks.util.GraphicsDeviceUtilities;
import java.awt.Dimension;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;

public class GLEventListenerWithReset
implements GLEventListener {
    private JavaSceneServerPeerInterface fJSSP;
    private static int sListenerCounter = 0;
    private boolean fInitialized;
    private boolean fNeedsReset;
    private boolean fWantToGrabCData;
    private int fListenerId;
    private boolean fSizeValid;

    public GLEventListenerWithReset(boolean bl, JavaSceneServerPeerInterface javaSceneServerPeerInterface) {
        this.fWantToGrabCData = bl;
        this.fInitialized = false;
        this.fNeedsReset = false;
        this.fListenerId = -1;
        if (javaSceneServerPeerInterface == null) {
            javaSceneServerPeerInterface = new JavaSceneServerPeerAdapter();
        }
        this.fJSSP = javaSceneServerPeerInterface;
    }

    public void setWantToGrabCData(boolean bl) {
        this.fWantToGrabCData = bl;
    }

    private static void initMaxDimensions(JavaSceneServerPeerInterface javaSceneServerPeerInterface, GLAutoDrawable gLAutoDrawable) {
        int[] nArray = new int[2];
        boolean bl = false;
        if (bl && gLAutoDrawable != null) {
            GL gL = gLAutoDrawable.getGL();
            gL.glGetIntegerv(3386, IntBuffer.wrap(nArray));
        } else {
            nArray[0] = GraphicsDeviceUtilities.getDefaultScreenWidth();
            nArray[1] = GraphicsDeviceUtilities.getDefaultScreenHeight();
        }
        javaSceneServerPeerInterface.setMaxViewportSize(new Dimension(nArray[0], nArray[1]));
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        DebugUtilities.logMessage(512, "GLEventListenerWithReset.init", this);
        GLEventListenerWithReset.initMaxDimensions(this.fJSSP, gLAutoDrawable);
        this.validateSize(gLAutoDrawable, this.fJSSP.getViewportWidth(), this.fJSSP.getViewportHeight());
        this.fInitialized = true;
        this.fNeedsReset = false;
        this.fListenerId = ++sListenerCounter;
        this.fJSSP.causeExpose();
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        DebugUtilities.logMessage(512, "GLEventListenerWithReset.reshape", this);
        this.validateSize(gLAutoDrawable, n3, n4);
        if (!this.fWantToGrabCData) {
            this.fJSSP.reshape(n, n2, n3, n4, this.fJSSP.getServerProxyHandle());
        }
        this.fJSSP.setGrabCDataWidth(n3);
        this.fJSSP.setGrabCDataHeight(n4);
    }

    private boolean validateSize(GLAutoDrawable gLAutoDrawable, int n, int n2) {
        Dimension dimension = this.fJSSP.getMaxViewportSize();
        if (n <= dimension.width && n2 <= dimension.height) {
            this.fSizeValid = true;
        } else {
            this.fJSSP.reportError("MATLAB:HG:Java:ViewportTooLarge", "Viewport [" + n + "x" + n2 + "]" + " too large for OpenGL implementation:" + " max [" + dimension.width + "x" + dimension.height + "]");
            this.fSizeValid = false;
        }
        gLAutoDrawable.setAutoSwapBufferMode(this.fSizeValid);
        return this.fSizeValid;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        DebugUtilities.logMessage(512, "GLEventListenerWithReset.displayChanged", this);
        this.fJSSP.reportError(true, "MATLAB:HG:Java:DisplayChanged", "Got displayChanged() call");
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        boolean bl;
        DebugUtilities.logMessage(512, "GLEventListenerWithReset.display", this);
        if (this.fNeedsReset) {
            if (this.fListenerId >= 0) {
                this.fJSSP.doRestart(this.fJSSP.getServerProxyHandle(), this.fListenerId);
            } else {
                this.fJSSP.reportError("MATLAB:HG:Java:RestartContext", "No context ID defined during restart");
            }
            this.fNeedsReset = false;
            this.fInitialized = false;
        }
        if (!this.fInitialized) {
            return;
        }
        if (this.fListenerId < 0) {
            this.fJSSP.reportError("MATLAB:HG:Java:DisplayContext", "No context ID defined during display");
            return;
        }
        if (!this.fSizeValid) {
            return;
        }
        try {
            bl = this.fJSSP.setupForGrabbingCDataIfNeeded(gLAutoDrawable);
        }
        catch (JavaSceneServerPeer.HGGLException hGGLException) {
            bl = false;
            this.fJSSP.setDisplayException(hGGLException);
        }
        this.fJSSP.doDisplay(this.fJSSP.getServerProxyHandle(), this.fListenerId);
        if (bl) {
            CDataGrabber cDataGrabber = ((CDataGrabber.CDataGrabberProvider)gLAutoDrawable).getCDataGrabber();
            this.fJSSP.setCDataImage(cDataGrabber.doGrabBufferedImage(gLAutoDrawable));
            JavaSceneServerPeer.stopGrabbingCData(gLAutoDrawable);
        }
    }

    public void setReady() {
        DebugUtilities.logMessage(512, "GLEventListenerWithReset.setReady", this);
        this.fInitialized = true;
    }

    public void reset() {
        DebugUtilities.logMessage(512, "GLEventListenerWithReset.reset", this);
        this.fInitialized = false;
        this.fNeedsReset = true;
    }

    public boolean isReady() {
        return this.fInitialized;
    }
}

