/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.EditTextPeer;
import com.mathworks.hg.peer.FigureEditableComponentManager;
import com.mathworks.hg.peer.FigureKeyEvent;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.FigurePeerMouseEvent;
import com.mathworks.hg.peer.FigurePeerScrollWheelEvent;
import com.mathworks.hg.peer.NotificationEvent;
import com.mathworks.hg.peer.event.UicontrolEvent;
import com.mathworks.hg.peer.utils.FigureEventSilencer;
import com.mathworks.hg.peer.utils.UIJ_Conversion;
import com.mathworks.util.FactoryUtils;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;

public class HG1FigureEventSimulator {
    private HG1FigureEventSimulator() {
    }

    private static void checkReady(String string, ReadyChecker readyChecker) throws TimeoutException {
        long l = System.currentTimeMillis();
        while (!readyChecker.isReady()) {
            if (System.currentTimeMillis() - l > 10000L) {
                throw new TimeoutException(string);
            }
            FactoryUtils.processPendingEvents();
        }
    }

    static Object simulateWindowEvent(final FigurePeer figurePeer, Object object, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n2, char c, int n3, int n4, int n5, boolean bl7, int n6, int n7, int n8) throws IllegalArgumentException, TimeoutException {
        Object object2;
        Component component;
        if (n8 != 16838) {
            throw new IllegalArgumentException("Wrong number of inputs passed to simulateWindowEvent. Last input must be the int 040706.");
        }
        HG1FigureEventSimulator.checkReady("Timeout waiting Listeners to be enabled?", new ReadyChecker(){

            @Override
            public boolean isReady() {
                return figurePeer.isListenersEnabled();
            }
        });
        if (object == null) {
            throw new IllegalArgumentException("Null component passed to simulateWindowEvent.");
        }
        AbstractUicontrolPeer abstractUicontrolPeer = null;
        if (object instanceof FigurePeer) {
            assert (object.equals(figurePeer));
            component = ((FigurePeer)object).getAxisComponent();
        } else if (object instanceof JComponent) {
            component = (Component)object;
        } else if (object instanceof AbstractUicontrolPeer) {
            object2 = (AbstractUicontrolPeer)object;
            HG1FigureEventSimulator.checkReady("Timeout waiting for component peer. Was the component created visible?", new ReadyChecker((AbstractUicontrolPeer)object2){
                final /* synthetic */ AbstractUicontrolPeer val$cpeer;
                {
                    this.val$cpeer = abstractUicontrolPeer;
                }

                @Override
                public boolean isReady() {
                    return this.val$cpeer.getComponentPeer() != null;
                }
            });
            abstractUicontrolPeer = object2;
            component = ((AbstractUicontrolPeer)object2).getComponentPeer();
        } else {
            throw new IllegalArgumentException("Unrecognized component passed to simulateWindowEvent.");
        }
        if (!(bl ^ bl2 ^ bl3 ^ bl4 ^ bl5 ^ bl6)) {
            throw new IllegalArgumentException("Only one of isDown, isMotion, isUp, isScroll, isKeyDown, and isKeyUp can be true");
        }
        KeyEventProvider keyEventProvider = new KeyEventProvider();
        Point point = new Point(n3, n4);
        int n9 = UIJ_Conversion.umods_to_jmods(n5);
        object2 = bl5 || bl6 ? HG1FigureEventSimulator.createKeyEvent(bl5, bl6, n2, c, component, keyEventProvider, n9) : (bl4 ? HG1FigureEventSimulator.createMouseWheelEvent(bl7, n6, n7, component, point, n9) : HG1FigureEventSimulator.createMouseEvent(n, bl, bl2, bl3, bl7, component, point, n9));
        assert (object2 != null);
        assert (object2 instanceof AWTEvent);
        final AWTEvent aWTEvent = (AWTEvent)object2;
        final Component component2 = component;
        if (keyEventProvider.getKeyEvent() != null) {
            EventQueue.invokeLater(new NotificationEvent(keyEventProvider.getKeyEvent(), component, figurePeer));
            EventQueue.invokeLater(new NotificationEvent((AWTEvent)object2, component, figurePeer));
            if (abstractUicontrolPeer != null && abstractUicontrolPeer instanceof EditTextPeer) {
                EditTextPeer editTextPeer = (EditTextPeer)abstractUicontrolPeer;
                FigureEditableComponentManager.setCurrentEditableComponent(editTextPeer);
                UicontrolEvent uicontrolEvent = new UicontrolEvent(abstractUicontrolPeer, component);
                abstractUicontrolPeer.fireUicontrolAction(uicontrolEvent);
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    NotificationEvent notificationEvent = new NotificationEvent(aWTEvent, component2, figurePeer);
                    try {
                        FigureEventSilencer.disable();
                        notificationEvent.run();
                    }
                    finally {
                        FigureEventSilencer.enable();
                    }
                }
            });
        }
        return object2;
    }

    protected static KeyEvent createKeyEvent(boolean bl, boolean bl2, int n, char c, Component component, KeyEventProvider keyEventProvider, int n2) {
        int n3 = 0;
        if (bl) {
            n3 = 401;
        } else if (bl2) {
            n3 = 402;
        }
        int n4 = UIJ_Conversion.ukey_to_jkey(n);
        if (c == '\u0000') {
            c = (char)65535;
        }
        if ((n2 & 1) != 0 && c != '\uffff' && c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
        }
        if (c < '\t' || c > '~') {
            c = (char)65535;
        }
        if (bl2 && c != '\uffff') {
            keyEventProvider.setKeyEvent(new FigureKeyEvent(component, 400, System.currentTimeMillis(), 0, 0, c));
        }
        return new FigureKeyEvent(component, n3, System.currentTimeMillis(), bl2 ? 0 : n2, n4, c);
    }

    static MouseWheelEvent createMouseWheelEvent(boolean bl, int n, int n2, Component component, Point point, int n3) {
        return new FigurePeerScrollWheelEvent(component, 507, System.currentTimeMillis(), n3, point, bl ? 2 : 1, false, 0, n2, n);
    }

    static MouseEvent createMouseEvent(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, Component component, final Point point, final int n2) throws IllegalArgumentException {
        int n3;
        int n4;
        int n5;
        switch (n) {
            case 1: {
                n5 = 1;
                break;
            }
            case 2: {
                n5 = 2;
                break;
            }
            case 3: {
                n5 = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized mouse button id");
            }
        }
        int n6 = n4 = bl4 ? 2 : 1;
        if (bl) {
            n3 = 501;
        } else if (bl2) {
            n3 = 503;
        } else if (bl3) {
            n3 = 502;
        } else {
            throw new IllegalArgumentException("Unrecognized mouse event type");
        }
        final FigurePeerMouseEvent[] figurePeerMouseEventArray = new FigurePeerMouseEvent[1];
        final Component component2 = component;
        final int n7 = n5;
        final int n8 = n3;
        final long l = System.currentTimeMillis();
        FactoryUtils.invokeAndWait((Runnable)new Runnable(){

            @Override
            public void run() {
                figurePeerMouseEventArray[0] = new FigurePeerMouseEvent(component2, n7, n8, l, point, n2, n4, false);
            }
        });
        return figurePeerMouseEventArray[0];
    }

    private static class KeyEventProvider {
        private KeyEvent fKeyEvent;

        private KeyEventProvider() {
        }

        public KeyEvent getKeyEvent() {
            return this.fKeyEvent;
        }

        public void setKeyEvent(KeyEvent keyEvent) {
            this.fKeyEvent = keyEvent;
        }
    }

    private static interface ReadyChecker {
        public boolean isReady();
    }
}

