/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.types.table.panel;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.hg.types.table.TablePropertyModel;
import com.mathworks.hg.types.table.panel.AbstractEditorPanel;
import com.mathworks.hg.types.table.panel.EditableTableUtils;
import com.mathworks.hg.types.table.panel.MessagePanel;
import com.mathworks.hg.types.table.panel.PropertyPanelEnum;
import com.mathworks.mlwidgets.workspace.IWorkspaceActionProvider;
import com.mathworks.mlwidgets.workspace.MatlabWorkspaceModel;
import com.mathworks.mlwidgets.workspace.WorkspaceDialogs;
import com.mathworks.mlwidgets.workspace.WorkspaceTable;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJRadioButton;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.recordlist.IDeletionObserver;
import com.mathworks.widgets.recordlist.IEditingObserver;
import com.mathworks.widgets.recordlist.IGenericNameSupplier;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.RecordlistTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TableDataPanel
extends AbstractEditorPanel {
    private static final String PREF_KEY = "TableEditor_DataTable";
    private MatlabWorkspaceModel workspaceModel;
    private IDeletionObserver deletionObserver;
    private IEditingObserver editingObserver;
    private MJRadioButton noneButton;
    private MJRadioButton currentButton;
    private MJRadioButton chooseButton;
    private WorkspaceTable workspaceTable;
    private MessagePanel infoPanel;
    private MJRadioButton previousChoice;

    public TableDataPanel(PropertyPanelEnum propertyPanelEnum, TablePropertyModel tablePropertyModel) {
        super(propertyPanelEnum, tablePropertyModel);
    }

    @Override
    public void cleanup() {
        this.workspaceModel.unregisterInterests();
        if (this.workspaceTable != null) {
            this.workspaceTable.setDeletionObserver(null);
            this.workspaceTable.setEditingObserver(null);
            this.workspaceTable.cleanup();
        }
        this.deletionObserver = null;
        this.editingObserver = null;
    }

    @Override
    protected JPanel buildEditorPanel() {
        this.infoPanel = new MessagePanel(this.getResourceString("data.info_default"));
        this.infoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("data.info_default"));
        FormLayout formLayout = new FormLayout("12dlu, p, 0dlu:g(1.0)", "p, 4dlu, p, 0dlu:g(1.0)");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.createChoicePanel(), cellConstraints.xyw(1, 1, 2));
        panelBuilder.add((Component)this.createWorkspaceTablePanel(), cellConstraints.xy(2, 3));
        panelBuilder.setBorder(Borders.createEmptyBorder((String)"6dlu, 0dlu, 0dlu, 0dlu"));
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)this.infoPanel), (Object)"North");
        mJPanel.add((Component)panelBuilder.getPanel(), (Object)"Center");
        mJPanel.setBorder(Borders.createEmptyBorder((String)"7dlu, 7dlu, 0dlu, 0dlu"));
        mJPanel.getAccessibleContext().setAccessibleName(this.getResourceString("acc.data.name"));
        return mJPanel;
    }

    @Override
    protected void initializePanel() {
        this.workspaceTable.clearSelection();
        MJRadioButton mJRadioButton = this.noneButton;
        Object object = this.getMetadataValue("DataPropertySource");
        if (object != null) {
            mJRadioButton = "DataDefault".equals(object) ? this.noneButton : this.currentButton;
        }
        mJRadioButton.setSelected(true);
        this.previousChoice = mJRadioButton;
    }

    @Override
    public void commit() {
        String string;
        if (this.noneButton.isSelected()) {
            string = "DataDefault";
        } else if (this.currentButton.isSelected()) {
            string = "DataExisting";
        } else {
            string = "DataVariable";
            int n = this.workspaceTable.getRowCount();
            if (n > 0) {
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = i;
                }
                String[] stringArray = this.workspaceTable.getVariableNames(nArray);
                int n2 = this.workspaceTable.getSelectedRow();
                if (n2 >= 0) {
                    string = stringArray[n2];
                }
            }
        }
        this.setMetadataValue("DataPropertySource", string);
    }

    @Override
    public boolean validatePanel() {
        int n = this.workspaceTable.getSelectedRow();
        if (this.chooseButton.isSelected()) {
            if (n == -1) {
                EditableTableUtils.showWarningMessage((JComponent)this.chooseButton, this.getResourceString("data.validate_msg1"));
                return false;
            }
        } else if ((this.currentButton.isSelected() || this.noneButton.isSelected()) && n != -1) {
            int n2 = EditableTableUtils.showYesNoCancelMessage((JComponent)this.currentButton, this.getResourceString("data.validate_msg2"));
            if (n2 == 2) {
                return false;
            }
            if (n2 == 0) {
                this.chooseButton.setSelected(true);
            } else {
                this.workspaceTable.getSelectionModel().clearSelection();
            }
        }
        return true;
    }

    private JPanel createChoicePanel() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TableDataPanel.this.updateInfoPanel();
            }
        };
        this.noneButton = this.createRadioButton("data.none", "data.tip_none", actionListener);
        this.currentButton = this.createRadioButton("data.current", "data.tip_current", actionListener);
        this.chooseButton = this.createRadioButton("data.choose", "data.tip_choose", actionListener);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.noneButton);
        buttonGroup.add((AbstractButton)this.currentButton);
        buttonGroup.add((AbstractButton)this.chooseButton);
        FormLayout formLayout = new FormLayout("p, 0dlu:g(1.0)", "p, 4dlu, p, 4dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.noneButton, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.currentButton, cellConstraints.xy(1, 3));
        panelBuilder.add((Component)this.chooseButton, cellConstraints.xy(1, 5));
        return panelBuilder.getPanel();
    }

    private MJRadioButton createRadioButton(String string, String string2, ActionListener actionListener) {
        MJRadioButton mJRadioButton = new MJRadioButton(this.getResourceString(string));
        mJRadioButton.setToolTipText(this.getResourceString(string2));
        mJRadioButton.addActionListener(actionListener);
        return mJRadioButton;
    }

    private JPanel createWorkspaceTablePanel() {
        this.workspaceModel = new MatlabWorkspaceModel();
        this.workspaceModel.registerInterests();
        int[] nArray = new int[]{this.workspaceModel.NAME(), this.workspaceModel.VALUE(), this.workspaceModel.SIZE(), this.workspaceModel.CLASS()};
        RecordlistTable.setInitialShownColumns((String)PREF_KEY, (int[])nArray, (int)this.workspaceModel.getFieldCount());
        RecordlistTable.setInitialShownColumnWidths((String)PREF_KEY, (int[])new int[]{100, 120, 70, 70});
        this.workspaceTable = new WorkspaceTable((IRecordlistModel)this.workspaceModel, PREF_KEY);
        this.workspaceTable.setName("WorkspaceDataTable");
        this.workspaceTable.getAccessibleContext().setAccessibleName(this.getResourceString("acc.data.table"));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.workspaceTable);
        mJScrollPane.setPreferredSize(new Dimension(360, 200));
        mJScrollPane.getViewport().setBackground(this.workspaceTable.getBackground());
        this.deletionObserver = WorkspaceDialogs.getDefaultDeletionObserver((IGenericNameSupplier)this.workspaceModel, (Component)((Object)this));
        this.workspaceTable.setDeletionObserver(this.deletionObserver);
        this.editingObserver = WorkspaceDialogs.getDefaultEditingObserver((IGenericNameSupplier)this.workspaceModel, (Component)((Object)this));
        this.workspaceTable.setEditingObserver(this.editingObserver);
        this.workspaceTable.setSelectionMode(0);
        this.disablePopupMenusAndDoubleClick();
        TableDataToolBar tableDataToolBar = new TableDataToolBar((IWorkspaceActionProvider)this.workspaceTable);
        tableDataToolBar.setFloatable(false);
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)mJScrollPane, (Object)"Center");
        return mJPanel;
    }

    private void disablePopupMenusAndDoubleClick() {
        this.workspaceTable.setDefaultAction(new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.workspaceTable.setSelectionPopupMenu(null);
        this.workspaceTable.setNoSelectionPopupMenu(null);
    }

    private void updateInfoPanel() {
        if (!this.chooseButton.isSelected() && this.previousChoice.equals(this.chooseButton)) {
            this.workspaceTable.getSelectionModel().clearSelection();
        }
        if (this.chooseButton.isSelected()) {
            this.infoPanel.setMessage(this.getResourceString("data.info_load"));
            this.infoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("data.info_load"));
            this.previousChoice = this.chooseButton;
        } else {
            this.infoPanel.setMessage(this.getResourceString("data.info_default"));
            this.infoPanel.getAccessibleContext().setAccessibleDescription(this.getResourceString("data.info_default"));
            this.previousChoice = this.noneButton.isSelected() ? this.noneButton : this.currentButton;
        }
    }

    class TableDataToolBar
    extends MJToolBar {
        public TableDataToolBar(IWorkspaceActionProvider iWorkspaceActionProvider) {
            JButton jButton;
            JButton jButton2;
            JButton jButton3;
            boolean bl = false;
            MJAbstractAction mJAbstractAction = iWorkspaceActionProvider.getAction(10);
            if (mJAbstractAction != null) {
                jButton3 = this.add((Action)mJAbstractAction);
                jButton3.getAccessibleContext().setAccessibleName(jButton3.getToolTipText());
                bl = true;
            }
            if ((jButton3 = iWorkspaceActionProvider.getAction(110)) != null) {
                jButton2 = this.add((Action)((Object)jButton3));
                jButton2.getAccessibleContext().setAccessibleName(jButton2.getToolTipText());
                bl = true;
            }
            if ((jButton2 = iWorkspaceActionProvider.getAction(140)) != null) {
                jButton = this.add((Action)((Object)jButton2));
                jButton.getAccessibleContext().setAccessibleName(jButton.getToolTipText());
                bl = true;
            }
            if (bl) {
                this.addSeparator();
            }
            if ((jButton = iWorkspaceActionProvider.getAction(20)) != null) {
                JButton jButton4 = this.add((Action)((Object)jButton));
                jButton4.getAccessibleContext().setAccessibleName(jButton4.getToolTipText());
            }
        }
    }
}

